/*
 * Decompiled with CFR 0.152.
 */
package com.algenta.crossip;

import com.algenta.crossip.Actions;
import com.algenta.crossip.Config;
import com.algenta.crossip.ConfigFileException;
import com.algenta.crossip.CrossIPConstants;
import com.algenta.crossip.CrossIPException;
import com.algenta.thatip.Record;
import com.algenta.thatip.ThatIP;
import com.algenta.thatip.ThatIPConstants;
import com.algenta.thatip.ThatIPServer;
import com.algenta.thatip.ThatIPServerException;
import com.algenta.thatip.ThatIPServerUpdateException;
import com.algenta.util.MD5Crypt3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;

public class CrossIP
implements CrossIPConstants,
ThatIPConstants {
    private static Config conf = new Config();
    private static Actions actions = new Actions();

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            try {
                conf = CrossIP.parseConfigFile(args[0], conf);
            }
            catch (ConfigFileException e) {
                System.err.println("Problem loading config file: " + args[0]);
                System.err.println(e.getMessage());
                System.exit(1);
            }
        } else {
            try {
                conf = CrossIP.launchWizard(conf);
            }
            catch (CrossIPException e) {
                System.err.println("Problem running wizard: ");
                System.err.println(e.getMessage());
                System.exit(1);
            }
        }
        System.out.println("Loaded Config File: " + conf.getConfigFile());
        try {
            actions = CrossIP.parseUpdateFile(conf.getUpdateFile(), actions);
        }
        catch (ConfigFileException e) {
            System.err.println("Problem loading update file: " + conf.getUpdateFile());
            System.err.println(e.getMessage());
            System.exit(1);
        }
        System.out.println("Loaded Update File: " + conf.getUpdateFile());
        Record[] records = conf.getRecords();
        String[] groups = ThatIP.getGroups(records, true);
        String ip = "";
        if (conf.getNat() != null && conf.getNat().compareToIgnoreCase("no") == 0) {
            ip = CrossIP.getCurrentIP();
            System.out.println("Found local IP Address: " + ip);
            System.out.println("If this IP is incorrect, please specify you are behind");
            System.out.println("a NAT or router to do advanced tests.");
        }
        String[] updates = actions.clientIP(groups, ip);
        try {
            CrossIP.performUpdates(updates, ip);
        }
        catch (CrossIPException e1) {
            System.err.println("Problem updating client determined hostnames");
            System.err.println(e1.getMessage());
            System.exit(1);
        }
        try {
            CrossIP.performUpdates(actions.autoIP(groups));
        }
        catch (CrossIPException e2) {
            System.err.println("Problem updating server determined hostnames");
            System.err.println(e2.getMessage());
            System.exit(1);
        }
        try {
            CrossIP.commitActions();
        }
        catch (ConfigFileException e3) {
            System.err.println("Problem writing update file");
            System.err.println(e3.getMessage());
        }
        if (conf.isUpdated()) {
            try {
                CrossIP.commitConfig();
            }
            catch (ConfigFileException e4) {
                System.err.println("Problem writing update file");
                System.err.println(e4.getMessage());
            }
        }
        System.out.println("Wrote configurations");
    }

    private static String getCurrentIP() {
        InetAddress i;
        try {
            i = new Socket("www.internic.net", 80).getLocalAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        return i.getHostAddress();
    }

    private static Config launchWizard(Config c) throws CrossIPException {
        return CrossIP.launchTextWizard(c);
    }

    private static Config launchTextWizard(Config c) throws CrossIPException {
        System.out.println("CrossIP v.1.2");
        System.out.println("CrossIP uses ThatIP-J v.1.3 p.1.1");
        System.out.println("Copyright (C) 2003-2004 Algenta Technologies, LLC.");
        System.out.println("Written by Dan Smith and Jeremy Iverson");
        System.out.println("http://www.algenta.com - http://www.thatip.com");
        System.out.println("==============================================");
        System.out.println("Welcome to the CrossIP console setup wizard!");
        System.out.println("It will guide you through the setup for CrossIP");
        System.out.println("for use with a ThatIP compatible server.");
        c = CrossIP.textQuestions(c);
        System.out.print("Hashing password...");
        try {
            c.setPassword(MD5Crypt3.MD5Hash(c.getPassword().getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Failed, MD5 not present");
            throw new CrossIPException("Your version of java does not include MD5", e);
        }
        System.out.println("Done!");
        conf = c;
        System.out.println("Logging into ThatIP server at " + conf.getServer());
        CrossIP.performUpdates(new String[0]);
        System.out.println("Retrieved domain records.");
        conf.setUpdated(true);
        actions = CrossIP.textGroups(actions);
        System.out.println("Writing config file.");
        try {
            CrossIP.commitConfig();
            System.out.println("Writing update file.");
            CrossIP.commitActions();
        }
        catch (ConfigFileException e1) {
            throw new CrossIPException("Unable to write file", e1);
        }
        return c;
    }

    private static void commitConfig() throws ConfigFileException {
        CrossIP.writeFile(conf.getConfigFile(), conf.toString());
    }

    private static void commitActions() throws ConfigFileException {
        CrossIP.writeFile(conf.getUpdateFile(), actions.toString());
    }

    /*
     * Exception decompiling
     */
    public static void writeFile(String path, String contents) throws ConfigFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 200->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void performUpdates(String[] groups) throws CrossIPException {
        CrossIP.performUpdates(groups, null);
    }

    private static void performUpdates(String[] groups, String ipAddr) throws CrossIPException {
        try {
            ThatIP.setClientName("CrossIP");
            ThatIP.setClientVersion("1.2");
            ThatIPServer server = ThatIP.getServer();
            server.connect(conf.getServer(), conf.getPort());
            int serial = server.loginMD5(conf.getUsername(), "thatip.com", conf.getPassword());
            if (serial > conf.getSerial()) {
                Record[] records = server.getRecords();
                conf.clearRecords();
                conf.addRecord(records);
                conf.setSerial(serial);
                conf.setUpdated(true);
            }
            if (ipAddr == null) {
                System.out.print("Updating groups from client ip: ");
            } else {
                System.out.print("Updating groups from server ip: ");
            }
            int i = 0;
            while (i < groups.length) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(groups[i]);
                ++i;
            }
            System.out.println();
            if (ipAddr == null) {
                actions.clientUpdate(groups, server.update(groups));
            } else {
                actions.autoUpdate(groups, server.update(groups, ipAddr));
            }
            server.quit();
        }
        catch (UnknownHostException e1) {
            throw new CrossIPException("Unable to find host " + conf.getServer(), e1);
        }
        catch (IOException e1) {
            throw new CrossIPException("A network error occurred", e1);
        }
        catch (ThatIPServerException e1) {
            throw new CrossIPException(e1.getMessage(), e1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CrossIPException("Your version of java does not include MD5", e);
        }
        catch (ThatIPServerUpdateException e) {
            throw new CrossIPException(e.getErrorMessage(), e);
        }
    }

    private static Actions textGroups(Actions a) throws CrossIPException {
        System.out.println("\nThatIP uses a concept called groups, when you update");
        System.out.println("a group all domains you have placed in it are updated to");
        System.out.println("the same ip address.  You can now select which groups");
        System.out.println("you would like updated from this computer");
        System.out.println("* Press n if you do not want to update the group");
        System.out.println("* Type auto if you want the thatip server to determine the ip");
        System.out.println("* Type client if you want the client to determine the ip");
        Record[] records = conf.getRecords();
        String[] groups = ThatIP.getGroups(records);
        System.out.print("Press <Enter> to begin.");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        String line = "";
        try {
            line = r.readLine();
            int i = 0;
            while (i < groups.length) {
                System.out.println("Group: " + groups[i]);
                int j = 0;
                while (j < records.length) {
                    if (records[j].getGroup().equalsIgnoreCase(groups[i])) {
                        System.out.println(" + " + records[j].toString());
                    }
                    ++j;
                }
                boolean correct = false;
                while (!correct) {
                    System.out.print("Update this group from this machine? (n,auto,client) :");
                    line = r.readLine();
                    if (line.length() <= 0) continue;
                    if (line.equalsIgnoreCase("n")) {
                        correct = true;
                        continue;
                    }
                    if (line.equalsIgnoreCase("auto")) {
                        correct = true;
                        a.autoUpdate(groups[i], "");
                        continue;
                    }
                    if (line.equalsIgnoreCase("client")) {
                        correct = true;
                        a.clientUpdate(groups[i], "");
                        continue;
                    }
                    System.out.println("Please enter n, auto, or client");
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new CrossIPException("Unable to read console input", e);
        }
        return a;
    }

    private static Config textQuestions(Config c) throws CrossIPException {
        System.out.print("Press <Enter> to begin.");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = r.readLine();
            System.out.println("Please enter your...");
            System.out.print("ThatIP account name " + CrossIP.textDefault(c.getUsername()));
            line = r.readLine();
            if (line.length() > 0) {
                c.setUsername(line);
            }
            System.out.print("ThatIP account password " + CrossIP.textDefault(c.getPassword()));
            line = r.readLine();
            if (line.length() > 0) {
                c.setPassword(line);
            }
            System.out.print("Config file pathname " + CrossIP.textDefault(c.getConfigFile()));
            line = r.readLine();
            if (line.length() > 0) {
                c.setConfigFile(line);
            }
            System.out.print("Update file pathname " + CrossIP.textDefault(c.getUpdateFile()));
            line = r.readLine();
            if (line.length() > 0) {
                c.setUpdateFile(line);
            }
            System.out.print("ThatIP server hostname " + CrossIP.textDefault(c.getServer()));
            line = r.readLine();
            if (line.length() > 0) {
                c.setServer(line);
            }
            boolean number = false;
            while (!number) {
                System.out.print("ThatIP server port " + CrossIP.textDefault(c.getPort()));
                line = r.readLine();
                if (line.length() > 0) {
                    try {
                        c.setPort(Integer.parseInt(line));
                        number = true;
                    }
                    catch (NumberFormatException e1) {
                        System.out.println("Please enter an integer");
                    }
                    continue;
                }
                number = true;
            }
            boolean nat = false;
            while (!nat) {
                System.out.print("Are you behind a NAT or router (y/n) " + CrossIP.textDefault(c.getNat()));
                line = r.readLine();
                if (line.length() > 0) {
                    if (line.equalsIgnoreCase("n") || line.equalsIgnoreCase("y")) {
                        c.setNat(line);
                        nat = true;
                        continue;
                    }
                    System.out.println("Please enter y or n");
                    continue;
                }
                nat = true;
            }
            System.out.println("==============================================");
            System.out.println("username " + c.getUsername());
            System.out.println("password " + c.getPassword());
            System.out.println("updatefile " + c.getUpdateFile());
            System.out.println("server " + c.getServer());
            System.out.println("port " + c.getPort());
            System.out.println("nat " + c.getNat());
            System.out.println("==============================================");
            boolean correct = false;
            while (!correct) {
                System.out.print("Are these values correct? (y/n) :");
                line = r.readLine();
                if (line.length() <= 0) continue;
                if (line.equalsIgnoreCase("n")) {
                    correct = true;
                    c = CrossIP.textQuestions(c);
                    continue;
                }
                if (line.equalsIgnoreCase("y")) {
                    correct = true;
                    continue;
                }
                System.out.println("Please enter y or n");
            }
        }
        catch (IOException e) {
            throw new CrossIPException("Unable to read console input", e);
        }
        return c;
    }

    private static String textDefault(String s) {
        if (s == null || s.length() == 0) {
            return "[] :";
        }
        return "[" + s + "] :";
    }

    private static String textDefault(int i) {
        if (i == 0) {
            return "[] :";
        }
        return "[" + i + "] :";
    }

    /*
     * Exception decompiling
     */
    private static Actions parseUpdateFile(String pathname, Actions a) throws ConfigFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 204->207)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static Config parseConfigFile(String pathname, Config c) throws ConfigFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 510->513)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

