/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public abstract class Certificate
implements Serializable {
    private final String type;
    private transient int cachedHashCode = -1;

    protected Certificate(String type) {
        this.type = type;
    }

    public boolean equals(Object other) {
        try {
            byte[] thatBytes;
            if (!(other instanceof Certificate)) {
                return false;
            }
            Certificate that = (Certificate)other;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            byte[] thisBytes = this.getEncoded();
            if (thisBytes.length != (thatBytes = that.getEncoded()).length) {
                return false;
            }
            int i = 0;
            while (i < thisBytes.length) {
                if (thisBytes[i] != thatBytes[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract PublicKey getPublicKey();

    public final String getType() {
        return this.type;
    }

    public int hashCode() {
        if (this.cachedHashCode != -1) {
            return this.cachedHashCode;
        }
        try {
            byte[] thisBytes = this.getEncoded();
            int hash = 0;
            int i = 0;
            while (i < thisBytes.length) {
                hash = (hash << 7 | hash >>> 25) ^ thisBytes[i] & 0xFF;
                ++i;
            }
            this.cachedHashCode = hash;
            return this.cachedHashCode;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
    }

    public abstract String toString();

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    protected Object writeReplace() throws ObjectStreamException {
        throw new RuntimeException("NYI");
    }
}

