/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.Support;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int PRIVATE_KEY = 3;
    public static final int PUBLIC_KEY = 4;
    public static final int SECRET_KEY = 5;
    public static final int UNWRAP_MODE = 6;
    public static final int WRAP_MODE = 7;
    private final CipherSpi spi;
    private final Provider provider;
    private final String transformation;
    private final ExemptionMechanism mechanism = null;
    private boolean isInitialized = false;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.spi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(null, 0, 0);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(input, 0, input.length);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.spi.engineDoFinal(null, 0, 0, output, outputOffset);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.spi.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        return this.spi.engineGetBlockSize();
    }

    private static Object[] getCipherImplementation(String transformation, Provider p) throws NoSuchPaddingException {
        String part_alg;
        String part_mode = "//";
        String part_pad = "//";
        int index_1 = transformation.indexOf(47);
        int index_2 = transformation.indexOf(47, index_1 + 1);
        if (index_1 == -1) {
            part_alg = transformation;
        } else {
            if (index_2 == -1) {
                return null;
            }
            part_alg = transformation.substring(0, index_1);
            part_mode = transformation.substring(index_1 + 1, index_2);
            part_pad = transformation.substring(index_2 + 1);
        }
        try {
            Object[] res = new Object[2];
            res[1] = p;
            String class_name = Support.getClassName("Cipher", transformation, p);
            if (class_name != null) {
                res[0] = Class.forName(class_name).newInstance();
                return res;
            }
            class_name = Support.getClassName("Cipher", String.valueOf(part_alg) + "/" + part_mode, p);
            if (class_name != null) {
                CipherSpi spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetPadding(part_pad);
                res[0] = spi;
                return res;
            }
            class_name = Support.getClassName("Cipher", String.valueOf(part_alg) + "//" + part_alg, p);
            if (class_name != null) {
                CipherSpi spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetMode(part_mode);
                res[0] = spi;
                return res;
            }
            class_name = Support.getClassName("Cipher", part_alg, p);
            if (class_name != null) {
                CipherSpi spi = (CipherSpi)Class.forName(class_name).newInstance();
                spi.engineSetMode(part_mode);
                spi.engineSetPadding(part_pad);
                res[0] = spi;
                return res;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (LinkageError linkageError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final byte[] getIV() {
        return this.spi.engineGetIV();
    }

    public static Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providers = Security.getProviders();
        if (providers == null || providers.length == 0) {
            throw new NoSuchAlgorithmException("No providers installed");
        }
        int i = 0;
        while (i < providers.length) {
            Object[] res = Cipher.getCipherImplementation(transformation, providers[i]);
            if (res != null) {
                return new Cipher((CipherSpi)res[0], (Provider)res[1], transformation);
            }
            ++i;
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + transformation + "]");
    }

    public static Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException("Provider not found. [" + provider + "]");
        }
        Object[] res = Cipher.getCipherImplementation(transformation, p);
        if (res != null) {
            return new Cipher((CipherSpi)res[0], (Provider)res[1], transformation);
        }
        throw new NoSuchAlgorithmException("Algorithm not found. [Cipher." + transformation + "]");
    }

    public final int getOutputSize(int inputLen) throws IllegalStateException {
        if (inputLen < 0) {
            throw new IllegalArgumentException("Input size must be >= 0");
        }
        return this.spi.engineGetOutputSize(inputLen);
    }

    public final AlgorithmParameters getParameters() {
        return this.spi.engineGetParameters();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        this.spi.engineInit(opmode, key, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(opmode, key, params, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(opmode, key, params, random);
        this.isInitialized = true;
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.spi.engineInit(opmode, key, random);
        this.isInitialized = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(opmode, key, params, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.spi.engineInit(opmode, key, params, random);
        this.isInitialized = true;
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        this.init(opmode, certificate, new SecureRandom());
        this.isInitialized = true;
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        if (certificate instanceof X509Certificate) {
            Iterator<String> it = ((X509Certificate)certificate).getCriticalExtensionOIDs().iterator();
            boolean[] blArray = ((X509Certificate)certificate).getKeyUsage();
        }
        PublicKey pk = certificate.getPublicKey();
        this.spi.engineInit(opmode, pk, random);
        this.isInitialized = true;
    }

    public String toString() {
        return "Cipher object: " + this.transformation;
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cipher not initialized!");
        }
        return this.spi.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        return this.spi.engineUpdate(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLen) throws IllegalStateException {
        return this.spi.engineUpdate(input, inputOffset, inputLen);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws IllegalStateException, ShortBufferException {
        return this.spi.engineUpdate(input, inputOffset, inputLen, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException {
        return this.spi.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (!this.isInitialized) {
            throw new IllegalStateException("Cipher not initialized!");
        }
        return this.spi.engineWrap(key);
    }
}

