/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import cryptix.jce.test.Util;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

abstract class CipherTest
extends Test {
    private static SecureRandom random = new SecureRandom();
    private final String alg;
    private final boolean testStreamCipher;

    protected CipherTest(String name) {
        super(name);
        this.alg = name;
        this.testStreamCipher = false;
    }

    protected CipherTest(String name, boolean testStreamCipher) {
        super(name);
        this.alg = name;
        this.testStreamCipher = testStreamCipher;
    }

    protected void testCipher(String[][] testValues) throws Exception {
        this.testExistence(this.alg);
        this.testValuesECB(this.alg, testValues);
        this.testKeyGenExistence(this.alg);
        this.testKeyGenWorks(this.alg);
    }

    protected void testExistence(String alg) throws Exception {
        this.beginTest("Algorithm available as " + alg);
        boolean res = true;
        try {
            Cipher c = Cipher.getInstance(alg, "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            res = false;
        }
        this.passIf(res);
    }

    protected void testKeyGenExistence(String alg) throws Exception {
        this.beginTest("KeyGenerator available");
        boolean res = true;
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(alg, "CryptixCrypto");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            res = false;
        }
        this.passIf(res);
    }

    protected void testKeyGenWorks(String alg) throws Exception {
        boolean res = true;
        this.beginTest("KeyGenerator works");
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(alg, "CryptixCrypto");
            keygen.init(random);
            String transform = String.valueOf(alg) + "/ECB/None";
            if (this.testStreamCipher) {
                transform = alg;
            }
            Cipher c = Cipher.getInstance(transform, "CryptixCrypto");
            int block_size = c.getBlockSize();
            byte[] pt = new byte[block_size];
            int i = 0;
            while (i < pt.length) {
                pt[i] = (byte)i;
                ++i;
            }
            int i2 = 0;
            while (i2 < 1000) {
                SecretKey k = keygen.generateKey();
                c.init(1, k);
                byte[] tmp = c.doFinal(pt);
                c.init(2, k);
                tmp = c.doFinal(tmp);
                res = Util.areEqual(tmp, pt);
                if (res) {
                    ++i2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf(res);
    }

    protected void testValuesCFB(String alg, String[][] testValues) throws Exception {
        this.beginTest("CFB Test Values (" + alg + ")");
        boolean res = true;
        try {
            int i = 0;
            while (i < testValues.length) {
                byte[] key = Util.hexFromString(testValues[i][0]);
                byte[] iv = Util.hexFromString(testValues[i][1]);
                byte[] pt = Util.hexFromString(testValues[i][2]);
                byte[] ct = Util.hexFromString(testValues[i][3]);
                IvParameterSpec ivs = new IvParameterSpec(iv);
                Cipher c = Cipher.getInstance(alg, "CryptixCrypto");
                c.init(1, (Key)new K(alg, key), ivs);
                byte[] trial_ct = c.doFinal(pt);
                c.init(2, (Key)new K(alg, key), ivs);
                byte[] trial_pt = c.doFinal(ct);
                if (!Util.areEqual(ct, trial_ct) || !Util.areEqual(pt, trial_pt)) {
                    res = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf(res);
    }

    protected void testValuesECB(String alg, String[][] testValues) throws Exception {
        this.beginTest("ECB Test Values");
        boolean res = true;
        try {
            int i = 0;
            while (i < testValues.length) {
                byte[] key = Util.hexFromString(testValues[i][0]);
                byte[] pt = Util.hexFromString(testValues[i][1]);
                byte[] ct = Util.hexFromString(testValues[i][2]);
                String transform = String.valueOf(alg) + "/ECB/None";
                if (this.testStreamCipher) {
                    transform = alg;
                }
                Cipher c = Cipher.getInstance(transform, "CryptixCrypto");
                c.init(1, new K(alg, key));
                byte[] trial_ct = c.doFinal(pt);
                c.init(2, new K(alg, key));
                byte[] trial_pt = c.doFinal(ct);
                if (!Util.areEqual(ct, trial_ct) || !Util.areEqual(pt, trial_pt)) {
                    System.out.println(testValues[i][0]);
                    res = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            res = false;
        }
        this.passIf(res);
    }

    private class K
    implements Key {
        private final byte[] keyBytes;
        private final String alg;

        K(String alg, byte[] keyBytes) {
            this.alg = alg;
            this.keyBytes = keyBytes;
        }

        public String getAlgorithm() {
            return this.alg;
        }

        public byte[] getEncoded() {
            return (byte[])this.keyBytes.clone();
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

