/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.test;

import cryptix.jce.test.Test;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import javax.crypto.Cipher;

class TestElGamal
extends Test {
    private static SecureRandom random = new SecureRandom();
    private KeyPair kp;
    private Cipher c;

    TestElGamal() {
        super("ElGamal");
    }

    protected void doIt() {
        this.doItPrivate2();
        this.doItPrivate3();
    }

    private void doItPrivate2() {
        this.beginTest("ElGamal KeyGen");
        boolean res = false;
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("ElGamal");
            gen.initialize(2048, new SecureRandom());
            this.kp = ((KeyPairGeneratorSpi)gen).generateKeyPair();
            this.c = Cipher.getInstance("ElGamal/ECB/PKCS#1");
            res = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.passIf(res);
    }

    private void doItPrivate3() {
        this.beginTest("ElGamal encrypting");
        boolean res = true;
        try {
            byte[] data = new byte[20];
            random.nextBytes(data);
            this.c.init(1, (Key)this.kp.getPublic(), random);
            byte[] encrypted = this.c.doFinal(data);
            this.c.init(2, (Key)this.kp.getPrivate(), random);
            byte[] data2 = this.c.doFinal(encrypted);
            int i = 0;
            while (i < data2.length) {
                if (data[i] != data2[i]) {
                    res = false;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable t) {
            res = false;
            t.printStackTrace();
        }
        this.passIf(res);
    }
}

