/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.elgamal;

import cryptix.jce.ElGamalKey;
import cryptix.jce.ElGamalParams;
import cryptix.jce.ElGamalPrivateKey;
import cryptix.jce.ElGamalPublicKey;
import cryptix.jce.provider.elgamal.ElGamalAlgorithm;
import cryptix.jce.provider.util.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class ElGamalCipher
extends CipherSpi {
    private BigInteger p;
    private BigInteger g;
    private BigInteger z;
    private int messageMaxLength;
    private boolean decrypt;

    protected final byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int ret;
        byte[] o = new byte[this.engineGetOutputSize(inputLen)];
        try {
            ret = this.engineDoFinal(input, inputOffset, inputLen, o, 0);
            if (ret == o.length) {
                return o;
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("PANIC: Should not happned!");
        }
        byte[] r = new byte[ret];
        System.arraycopy(o, 0, r, 0, ret);
        return r;
    }

    protected final int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output.length < this.engineGetOutputSize(inputLen)) {
            throw new ShortBufferException("Output buffer too small!");
        }
        int blocksize = this.engineGetBlockSize() / 2;
        if (this.decrypt) {
            BigInteger[] res = new BigInteger[2];
            byte[] tmp1 = new byte[blocksize];
            System.arraycopy(input, 0, tmp1, 0, blocksize);
            res[0] = new BigInteger(1, tmp1);
            byte[] tmp2 = new byte[blocksize];
            System.arraycopy(input, blocksize, tmp2, 0, blocksize);
            res[1] = new BigInteger(1, tmp2);
            BigInteger m = null;
            try {
                m = ElGamalAlgorithm.decrypt(res, this.p, this.z);
            }
            catch (ArithmeticException arithmeticException) {
                throw new BadPaddingException("Decryption Failed.");
            }
            byte[] b = Util.toFixedLenByteArray(m, blocksize);
            return this.unpad(b, b.length, 0, output, outputOffset);
        }
        BigInteger bi = new BigInteger(1, this.pad(input, inputLen, inputOffset, 2));
        BigInteger[] res = ElGamalAlgorithm.encrypt(bi, this.p, this.g, this.z);
        byte[] tmp1 = Util.toFixedLenByteArray(res[0], blocksize);
        byte[] tmp2 = Util.toFixedLenByteArray(res[1], blocksize);
        System.arraycopy(tmp1, 0, output, outputOffset, tmp1.length);
        System.arraycopy(tmp2, 0, output, outputOffset + tmp1.length, tmp2.length);
        return tmp1.length + tmp2.length;
    }

    protected final int engineGetBlockSize() {
        return (this.p.bitLength() + 7) / 8 * 2;
    }

    protected final byte[] engineGetIV() {
        return null;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof ElGamalKey)) {
            throw new InvalidKeyException("Not an ElGamalKey!");
        }
        ElGamalParams params = ((ElGamalKey)((Object)key)).getParams();
        return params.getP().bitLength();
    }

    protected final int engineGetOutputSize(int inputLen) {
        return inputLen < this.engineGetBlockSize() + 1 ? this.engineGetBlockSize() + 1 : inputLen;
    }

    protected final AlgorithmParameters engineGetParameters() {
        throw new RuntimeException("NYI");
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameters");
    }

    protected final void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        boolean bl = this.decrypt = opmode == 2;
        if (!(key instanceof ElGamalKey)) {
            throw new InvalidKeyException("Not an ElGamalKey");
        }
        this.g = ((ElGamalKey)((Object)key)).getParams().getG();
        this.p = ((ElGamalKey)((Object)key)).getParams().getP();
        if (this.decrypt) {
            if (!(key instanceof ElGamalPrivateKey)) {
                throw new InvalidKeyException("Not a private key");
            }
            this.z = ((ElGamalPrivateKey)key).getX();
        } else {
            if (!(key instanceof ElGamalPublicKey)) {
                throw new InvalidKeyException("Not a public key");
            }
            this.z = ((ElGamalPublicKey)key).getY();
        }
        this.messageMaxLength = (this.p.bitLength() - 1) / 8;
    }

    protected final void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This cipher do not support AlgorithmParameterSpecs");
    }

    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Wrong mode type!");
        }
    }

    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!(padding.equalsIgnoreCase("PKCS1") || padding.equalsIgnoreCase("PKCS#1") || padding.equalsIgnoreCase("PKCS1Padding"))) {
            throw new NoSuchPaddingException("Wrong padding scheme!");
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKeyType != 5) {
            throw new InvalidKeyException("Wrong keytype!");
        }
        try {
            KeyGenerator.getInstance(wrappedKeyAlgorithm, "Cryptix");
            byte[] buf = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            SecretKeySpec sks = new SecretKeySpec(buf, 0, buf.length, wrappedKeyAlgorithm);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(wrappedKeyAlgorithm);
            return skf.generateSecret(sks);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("Algorithm not supported!");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("PANIC: Should not happend!");
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    protected final byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected final int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new RuntimeException("You can't do an update when using PKCS1!");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        String format = key.getFormat();
        if (format == null || !format.equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format on key!");
        }
        byte[] buf = key.getEncoded();
        try {
            return this.engineDoFinal(buf, 0, buf.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new RuntimeException("PANIC: This should not happend!");
        }
    }

    private byte[] pad(byte[] input, int inputLen, int offset, int bt) throws BadPaddingException {
        int k = (this.p.bitLength() + 7) / 8;
        if (inputLen > k - 11) {
            throw new BadPaddingException("Data too long for this modulus!");
        }
        byte[] ed = new byte[k];
        int padLen = k - 3 - inputLen;
        ed[2 + padLen] = 0;
        ed[0] = 0;
        switch (bt) {
            case 0: {
                int i = 1;
                while (i < 2 + padLen) {
                    ed[i] = 0;
                    ++i;
                }
                break;
            }
            case 1: {
                ed[1] = 1;
                int i = 2;
                while (i < 2 + padLen) {
                    ed[i] = -1;
                    ++i;
                }
                break;
            }
            case 2: {
                ed[1] = 2;
                byte[] b = new byte[1];
                SecureRandom sr = new SecureRandom();
                int i = 2;
                while (i < 2 + padLen) {
                    b[0] = 0;
                    while (b[0] == 0) {
                        sr.nextBytes(b);
                    }
                    ed[i] = b[0];
                    ++i;
                }
                break;
            }
            default: {
                throw new BadPaddingException("Wrong block type!");
            }
        }
        System.arraycopy(input, offset, ed, padLen + 3, inputLen);
        return ed;
    }

    private int unpad(byte[] input, int inputLen, int inOffset, byte[] output, int outOffset) throws BadPaddingException {
        byte bt = input[inOffset + 1];
        int padLen = 1;
        try {
            switch (bt) {
                case 0: {
                    while (input[inOffset + padLen + 1] == 0) {
                        ++padLen;
                    }
                    break;
                }
                case 1: 
                case 2: {
                    while (input[inOffset + padLen] != 0) {
                        ++padLen;
                    }
                    break;
                }
                default: {
                    throw new BadPaddingException("Wrong block type!");
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadPaddingException("Cannot unpad: padding incorrect for PKCS#1 block type " + bt);
        }
        int len = inputLen - inOffset - ++padLen;
        System.arraycopy(input, inOffset + padLen, output, outOffset, len);
        return len;
    }
}

