/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.util;

import java.math.BigInteger;

public final class Util {
    public static final BigInteger BI_ZERO = BigInteger.valueOf(0L);
    public static final BigInteger BI_ONE = BigInteger.valueOf(1L);

    private Util() {
    }

    public static boolean equals(byte[] a, byte[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null ^ b == null) {
            return false;
        }
        int aLen = a.length;
        int bLen = b.length;
        if (aLen != bLen) {
            return false;
        }
        int i = 0;
        while (i < aLen) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] toFixedLenByteArray(BigInteger x, int resultByteLen) {
        int x_off;
        if (x.signum() != 1) {
            throw new IllegalArgumentException("BigInteger not positive.");
        }
        byte[] x_bytes = x.toByteArray();
        int x_len = x_bytes.length;
        if (x_len <= 0) {
            throw new IllegalArgumentException("BigInteger too small.");
        }
        int n = x_off = x_bytes[0] == 0 ? 1 : 0;
        if ((x_len -= x_off) > resultByteLen) {
            throw new IllegalArgumentException("BigInteger too large.");
        }
        byte[] res_bytes = new byte[resultByteLen];
        int res_off = resultByteLen - x_len;
        System.arraycopy(x_bytes, x_off, res_bytes, res_off, x_len);
        return res_bytes;
    }
}

