/*
mnemonics.c

diStorm3 - Powerful disassembler for X86/AMD64
http://ragestorm.net/distorm/
distorm at gmail dot com
Copyright (C) 2010  Gil Dabah

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#include "../include/mnemonics.h"

const _WMnemonic _MNEMONICS[] = {
	{9, "UNDEFINED"},
	{3, "ADD"}, {4, "PUSH"}, {3, "POP"}, {2, "OR"}, {3, "ADC"}, {3, "SBB"}, {3, "AND"},
	{3, "DAA"}, {3, "SUB"}, {3, "DAS"}, {3, "XOR"}, {3, "AAA"}, {3, "CMP"}, {3, "AAS"},
	{3, "INC"}, {3, "DEC"}, {5, "PUSHA"}, {4, "POPA"}, {5, "BOUND"}, {4, "ARPL"},
	{4, "IMUL"}, {3, "INS"}, {4, "OUTS"}, {2, "JO"}, {3, "JNO"}, {2, "JB"}, {3, "JAE"},
	{2, "JZ"}, {3, "JNZ"}, {3, "JBE"}, {2, "JA"}, {2, "JS"}, {3, "JNS"}, {2, "JP"},
	{3, "JNP"}, {2, "JL"}, {3, "JGE"}, {3, "JLE"}, {2, "JG"}, {4, "TEST"}, {4, "XCHG"},
	{3, "MOV"}, {3, "LEA"}, {3, "CBW"}, {4, "CWDE"}, {4, "CDQE"}, {3, "CWD"}, {3, "CDQ"},
	{3, "CQO"}, {8, "CALL FAR"}, {5, "PUSHF"}, {4, "POPF"}, {4, "SAHF"}, {4, "LAHF"},
	{4, "MOVS"}, {4, "CMPS"}, {4, "STOS"}, {4, "LODS"}, {4, "SCAS"}, {3, "RET"},
	{3, "LES"}, {3, "LDS"}, {5, "ENTER"}, {5, "LEAVE"}, {4, "RETF"}, {5, "INT 3"},
	{3, "INT"}, {4, "INTO"}, {4, "IRET"}, {3, "AAM"}, {3, "AAD"}, {4, "SALC"}, {4, "XLAT"},
	{6, "LOOPNZ"}, {5, "LOOPZ"}, {4, "LOOP"}, {4, "JCXZ"}, {5, "JECXZ"}, {5, "JRCXZ"},
	{2, "IN"}, {3, "OUT"}, {4, "CALL"}, {3, "JMP"}, {7, "JMP FAR"}, {4, "INT1"},
	{3, "HLT"}, {3, "CMC"}, {3, "CLC"}, {3, "STC"}, {3, "CLI"}, {3, "STI"}, {3, "CLD"},
	{3, "STD"}, {3, "LAR"}, {3, "LSL"}, {7, "SYSCALL"}, {4, "CLTS"}, {6, "SYSRET"},
	{4, "INVD"}, {6, "WBINVD"}, {3, "UD2"}, {5, "FEMMS"}, {3, "NOP"}, {5, "WRMSR"},
	{5, "RDTSC"}, {5, "RDMSR"}, {5, "RDPMC"}, {8, "SYSENTER"}, {7, "SYSEXIT"},
	{6, "GETSEC"}, {5, "CMOVO"}, {6, "CMOVNO"}, {5, "CMOVB"}, {6, "CMOVAE"}, {5, "CMOVZ"},
	{6, "CMOVNZ"}, {6, "CMOVBE"}, {5, "CMOVA"}, {5, "CMOVS"}, {6, "CMOVNS"}, {5, "CMOVP"},
	{6, "CMOVNP"}, {5, "CMOVL"}, {6, "CMOVGE"}, {6, "CMOVLE"}, {5, "CMOVG"}, {4, "SETO"},
	{5, "SETNO"}, {4, "SETB"}, {5, "SETAE"}, {4, "SETZ"}, {5, "SETNZ"}, {5, "SETBE"},
	{4, "SETA"}, {4, "SETS"}, {5, "SETNS"}, {4, "SETP"}, {5, "SETNP"}, {4, "SETL"},
	{5, "SETGE"}, {5, "SETLE"}, {4, "SETG"}, {5, "CPUID"}, {2, "BT"}, {4, "SHLD"},
	{3, "RSM"}, {3, "BTS"}, {4, "SHRD"}, {7, "CMPXCHG"}, {3, "LSS"}, {3, "BTR"},
	{3, "LFS"}, {3, "LGS"}, {5, "MOVZX"}, {3, "BTC"}, {3, "BSF"}, {5, "MOVSX"},
	{4, "XADD"}, {6, "MOVNTI"}, {5, "BSWAP"}, {4, "SLDT"}, {3, "STR"}, {4, "LLDT"},
	{3, "LTR"}, {4, "VERR"}, {4, "VERW"}, {4, "SGDT"}, {4, "SIDT"}, {4, "LGDT"},
	{4, "LIDT"}, {4, "SMSW"}, {4, "LMSW"}, {6, "INVLPG"}, {6, "VMCALL"}, {8, "VMLAUNCH"},
	{8, "VMRESUME"}, {6, "VMXOFF"}, {7, "MONITOR"}, {5, "MWAIT"}, {6, "XGETBV"},
	{6, "XSETBV"}, {5, "VMRUN"}, {7, "VMMCALL"}, {6, "VMLOAD"}, {6, "VMSAVE"},
	{4, "STGI"}, {4, "CLGI"}, {6, "SKINIT"}, {7, "INVLPGA"}, {6, "SWAPGS"}, {6, "RDTSCP"},
	{8, "PREFETCH"}, {9, "PREFETCHW"}, {5, "PI2FW"}, {5, "PI2FD"}, {5, "PF2IW"},
	{5, "PF2ID"}, {6, "PFNACC"}, {7, "PFPNACC"}, {7, "PFCMPGE"}, {5, "PFMIN"},
	{5, "PFRCP"}, {7, "PFRSQRT"}, {5, "PFSUB"}, {5, "PFADD"}, {7, "PFCMPGT"}, {5, "PFMAX"},
	{8, "PFRCPIT1"}, {8, "PFRSQIT1"}, {6, "PFSUBR"}, {5, "PFACC"}, {7, "PFCMPEQ"},
	{5, "PFMUL"}, {8, "PFRCPIT2"}, {7, "PMULHRW"}, {6, "PSWAPD"}, {7, "PAVGUSB"},
	{6, "MOVUPS"}, {6, "MOVUPD"}, {5, "MOVSS"}, {5, "MOVSD"}, {6, "VMOVSS"}, {6, "VMOVSD"},
	{7, "VMOVUPS"}, {7, "VMOVUPD"}, {7, "MOVHLPS"}, {6, "MOVLPS"}, {6, "MOVLPD"},
	{8, "MOVSLDUP"}, {7, "MOVDDUP"}, {8, "VMOVHLPS"}, {7, "VMOVLPS"}, {7, "VMOVLPD"},
	{9, "VMOVSLDUP"}, {8, "VMOVDDUP"}, {8, "UNPCKLPS"}, {8, "UNPCKLPD"}, {9, "VUNPCKLPS"},
	{9, "VUNPCKLPD"}, {8, "UNPCKHPS"}, {8, "UNPCKHPD"}, {9, "VUNPCKHPS"}, {9, "VUNPCKHPD"},
	{7, "MOVLHPS"}, {6, "MOVHPS"}, {6, "MOVHPD"}, {8, "MOVSHDUP"}, {8, "VMOVLHPS"},
	{7, "VMOVHPS"}, {7, "VMOVHPD"}, {9, "VMOVSHDUP"}, {11, "PREFETCHNTA"}, {10, "PREFETCHT0"},
	{10, "PREFETCHT1"}, {10, "PREFETCHT2"}, {6, "MOVAPS"}, {6, "MOVAPD"}, {7, "VMOVAPS"},
	{7, "VMOVAPD"}, {8, "CVTPI2PS"}, {8, "CVTPI2PD"}, {8, "CVTSI2SS"}, {8, "CVTSI2SD"},
	{9, "VCVTSI2SS"}, {9, "VCVTSI2SD"}, {7, "MOVNTPS"}, {7, "MOVNTPD"}, {7, "MOVNTSS"},
	{7, "MOVNTSD"}, {8, "VMOVNTPS"}, {8, "VMOVNTPD"}, {9, "CVTTPS2PI"}, {9, "CVTTPD2PI"},
	{9, "CVTTSS2SI"}, {9, "CVTTSD2SI"}, {10, "VCVTTSS2SI"}, {10, "VCVTTSD2SI"},
	{8, "CVTPS2PI"}, {8, "CVTPD2PI"}, {8, "CVTSS2SI"}, {8, "CVTSD2SI"}, {9, "VCVTSS2SI"},
	{9, "VCVTSD2SI"}, {7, "UCOMISS"}, {7, "UCOMISD"}, {8, "VUCOMISS"}, {8, "VUCOMISD"},
	{6, "COMISS"}, {6, "COMISD"}, {7, "VCOMISS"}, {7, "VCOMISD"}, {6, "PSHUFB"},
	{7, "VPSHUFB"}, {6, "PHADDW"}, {7, "VPHADDW"}, {6, "PHADDD"}, {7, "VPHADDD"},
	{7, "PHADDSW"}, {8, "VPHADDSW"}, {9, "PMADDUBSW"}, {10, "VPMADDUBSW"}, {6, "PHSUBW"},
	{7, "VPHSUBW"}, {6, "PHSUBD"}, {7, "VPHSUBD"}, {7, "PHSUBSW"}, {8, "VPHSUBSW"},
	{6, "PSIGNB"}, {7, "VPSIGNB"}, {6, "PSIGNW"}, {7, "VPSIGNW"}, {6, "PSIGND"},
	{7, "VPSIGND"}, {8, "PMULHRSW"}, {9, "VPMULHRSW"}, {9, "VPERMILPS"}, {9, "VPERMILPD"},
	{8, "VPTESTPS"}, {8, "VPTESTPD"}, {8, "PBLENDVB"}, {8, "BLENDVPS"}, {8, "BLENDVPD"},
	{5, "PTEST"}, {6, "VPTEST"}, {12, "VBROADCASTSS"}, {12, "VBROADCASTSD"}, {14, "VBROADCASTF128"},
	{5, "PABSB"}, {6, "VPABSB"}, {5, "PABSW"}, {6, "VPABSW"}, {5, "PABSD"}, {6, "VPABSD"},
	{8, "PMOVSXBW"}, {9, "VPMOVSXBW"}, {8, "PMOVSXBD"}, {9, "VPMOVSXBD"}, {8, "PMOVSXBQ"},
	{9, "VPMOVSXBQ"}, {8, "PMOVSXWD"}, {9, "VPMOVSXWD"}, {8, "PMOVSXWQ"}, {9, "VPMOVSXWQ"},
	{8, "PMOVSXDQ"}, {9, "VPMOVSXDQ"}, {6, "PMULDQ"}, {7, "VPMULDQ"}, {7, "PCMPEQQ"},
	{8, "VPCMPEQQ"}, {8, "MOVNTDQA"}, {9, "VMOVNTDQA"}, {8, "PACKUSDW"}, {9, "VPACKUSDW"},
	{10, "VMASKMOVPS"}, {10, "VMASKMOVPD"}, {8, "PMOVZXBW"}, {9, "VPMOVZXBW"},
	{8, "PMOVZXBD"}, {9, "VPMOVZXBD"}, {8, "PMOVZXBQ"}, {9, "VPMOVZXBQ"}, {8, "PMOVZXWD"},
	{9, "VPMOVZXWD"}, {8, "PMOVZXWQ"}, {9, "VPMOVZXWQ"}, {8, "PMOVZXDQ"}, {9, "VPMOVZXDQ"},
	{7, "PCMPGTQ"}, {8, "VPCMPGTQ"}, {6, "PMINSB"}, {7, "VPMINSB"}, {6, "PMINSD"},
	{7, "VPMINSD"}, {6, "PMINUW"}, {7, "VPMINUW"}, {6, "PMINUD"}, {7, "VPMINUD"},
	{6, "PMAXSB"}, {7, "VPMAXSB"}, {6, "PMAXSD"}, {7, "VPMAXSD"}, {6, "PMAXUW"},
	{7, "VPMAXUW"}, {6, "PMAXUD"}, {7, "VPMAXUD"}, {6, "PMULLD"}, {7, "VPMULLD"},
	{10, "PHMINPOSUW"}, {11, "VPHMINPOSUW"}, {6, "INVEPT"}, {7, "INVVPID"}, {14, "VFMADDSUB132PS"},
	{14, "VFMADDSUB132PD"}, {14, "VFMSUBADD132PS"}, {14, "VFMSUBADD132PD"}, {11, "VFMADD132PS"},
	{11, "VFMADD132PD"}, {11, "VFMADD132SS"}, {11, "VFMADD132SD"}, {11, "VFMSUB132PS"},
	{11, "VFMSUB132PD"}, {11, "VFMSUB132SS"}, {11, "VFMSUB132SD"}, {12, "VFNMADD132PS"},
	{12, "VFNMADD132PD"}, {12, "VFNMADD132SS"}, {12, "VFNMADD132SD"}, {12, "VFNMSUB132PS"},
	{12, "VFNMSUB132PD"}, {12, "VFNMSUB132SS"}, {12, "VFNMSUB132SD"}, {14, "VFMADDSUB213PS"},
	{14, "VFMADDSUB213PD"}, {14, "VFMSUBADD213PS"}, {14, "VFMSUBADD213PD"}, {11, "VFMADD213PS"},
	{11, "VFMADD213PD"}, {11, "VFMADD213SS"}, {11, "VFMADD213SD"}, {11, "VFMSUB213PS"},
	{11, "VFMSUB213PD"}, {11, "VFMSUB213SS"}, {11, "VFMSUB213SD"}, {12, "VFNMADD213PS"},
	{12, "VFNMADD213PD"}, {12, "VFNMADD213SS"}, {12, "VFNMADD213SD"}, {12, "VFNMSUB213PS"},
	{12, "VFNMSUB213PD"}, {12, "VFNMSUB213SS"}, {12, "VFNMSUB213SD"}, {14, "VFMADDSUB231PS"},
	{14, "VFMADDSUB231PD"}, {14, "VFMSUBADD231PS"}, {14, "VFMSUBADD231PD"}, {11, "VFMADD231PS"},
	{11, "VFMADD231PD"}, {11, "VFMADD231SS"}, {11, "VFMADD231SD"}, {11, "VFMSUB231PS"},
	{11, "VFMSUB231PD"}, {11, "VFMSUB231SS"}, {11, "VFMSUB231SD"}, {12, "VFNMADD231PS"},
	{12, "VFNMADD231PD"}, {12, "VFNMADD231SS"}, {12, "VFNMADD231SD"}, {12, "VFNMSUB231PS"},
	{12, "VFNMSUB231PD"}, {12, "VFNMSUB231SS"}, {12, "VFNMSUB231SD"}, {6, "AESIMC"},
	{7, "VAESIMC"}, {6, "AESENC"}, {7, "VAESENC"}, {10, "AESENCLAST"}, {11, "VAESENCLAST"},
	{6, "AESDEC"}, {7, "VAESDEC"}, {10, "AESDECLAST"}, {11, "VAESDECLAST"}, {5, "MOVBE"},
	{5, "CRC32"}, {10, "VPERM2F128"}, {7, "ROUNDPS"}, {8, "VROUNDPS"}, {7, "ROUNDPD"},
	{8, "VROUNDPD"}, {7, "ROUNDSS"}, {8, "VROUNDSS"}, {7, "ROUNDSD"}, {8, "VROUNDSD"},
	{7, "BLENDPS"}, {8, "VBLENDPS"}, {7, "BLENDPD"}, {8, "VBLENDPD"}, {7, "PBLENDW"},
	{9, "VPBLENDVW"}, {7, "PALIGNR"}, {8, "VPALIGNR"}, {6, "PEXTRB"}, {7, "VPEXTRB"},
	{6, "PEXTRW"}, {7, "VPEXTRW"}, {6, "PEXTRD"}, {6, "PEXTRQ"}, {7, "VPEXTRD"},
	{9, "EXTRACTPS"}, {10, "VEXTRACTPS"}, {11, "VINSERTF128"}, {12, "VEXTRACTF128"},
	{6, "PINSRB"}, {7, "VPINSRB"}, {8, "INSERTPS"}, {9, "VINSERTPS"}, {6, "PINSRD"},
	{6, "PINSRQ"}, {7, "VPINSRD"}, {7, "VPINSRQ"}, {4, "DPPS"}, {5, "VDPPS"}, {4, "DPPD"},
	{5, "VDPPD"}, {7, "MPSADBW"}, {8, "VMPSADBW"}, {9, "PCLMULQDQ"}, {10, "VPCLMULQDQ"},
	{9, "VBLENDVPS"}, {9, "VBLENDVPD"}, {9, "VPBLENDVB"}, {9, "PCMPESTRM"}, {10, "VPCMPESTRM"},
	{9, "PCMPESTRI"}, {9, "VCMPESTRI"}, {9, "PCMPISTRM"}, {10, "VPCMPISTRM"},
	{9, "PCMPISTRI"}, {10, "VPCMPISTRI"}, {15, "AESKEYGENASSIST"}, {16, "VAESKEYGENASSIST"},
	{8, "MOVMSKPS"}, {8, "MOVMSKPD"}, {9, "VMOVMSKPS"}, {9, "VMOVMSKPD"}, {6, "SQRTPS"},
	{6, "SQRTPD"}, {6, "SQRTSS"}, {6, "SQRTSD"}, {7, "VSQRTSS"}, {7, "VSQRTSD"},
	{7, "VSQRTPS"}, {7, "VSQRTPD"}, {7, "RSQRTPS"}, {7, "RSQRTSS"}, {8, "VRSQRTSS"},
	{8, "VRSQRTPS"}, {5, "RCPPS"}, {5, "RCPSS"}, {6, "VRCPSS"}, {6, "VRCPPS"},
	{5, "ANDPS"}, {5, "ANDPD"}, {6, "VANDPS"}, {6, "VANDPD"}, {6, "ANDNPS"}, {6, "ANDNPD"},
	{7, "VANDNPS"}, {7, "VANDNPD"}, {4, "ORPS"}, {4, "ORPD"}, {5, "VORPS"}, {5, "VORPD"},
	{5, "XORPS"}, {5, "XORPD"}, {6, "VXORPS"}, {6, "VXORPD"}, {5, "ADDPS"}, {5, "ADDPD"},
	{5, "ADDSS"}, {5, "ADDSD"}, {6, "VADDPS"}, {6, "VADDPD"}, {6, "VADDSS"}, {6, "VADDSD"},
	{5, "MULPS"}, {5, "MULPD"}, {5, "MULSS"}, {5, "MULSD"}, {6, "VMULPS"}, {6, "VMULPD"},
	{6, "VMULSS"}, {6, "VMULSD"}, {8, "CVTPS2PD"}, {8, "CVTPD2PS"}, {8, "CVTSS2SD"},
	{8, "CVTSD2SS"}, {9, "VCVTSS2SD"}, {9, "VCVTSD2SS"}, {9, "VCVTPS2PD"}, {9, "VCVTPD2PS"},
	{8, "CVTDQ2PS"}, {8, "CVTPS2DQ"}, {9, "CVTTPS2DQ"}, {9, "VCVTDQ2PS"}, {9, "VCVTPS2DQ"},
	{10, "VCVTTPS2DQ"}, {5, "SUBPS"}, {5, "SUBPD"}, {5, "SUBSS"}, {5, "SUBSD"},
	{6, "VSUBPS"}, {6, "VSUBPD"}, {6, "VSUBSS"}, {6, "VSUBSD"}, {5, "MINPS"}, {5, "MINPD"},
	{5, "MINSS"}, {5, "MINSD"}, {6, "VMINPS"}, {6, "VMINPD"}, {6, "VMINSS"}, {6, "VMINSD"},
	{5, "DIVPS"}, {5, "DIVPD"}, {5, "DIVSS"}, {5, "DIVSD"}, {6, "VDIVPS"}, {6, "VDIVPD"},
	{6, "VDIVSS"}, {6, "VDIVSD"}, {5, "MAXPS"}, {5, "MAXPD"}, {5, "MAXSS"}, {5, "MAXSD"},
	{6, "VMAXPS"}, {6, "VMAXPD"}, {6, "VMAXSS"}, {6, "VMAXSD"}, {9, "PUNPCKLBW"},
	{10, "VPUNPCKLBW"}, {9, "PUNPCKLWD"}, {10, "VPUNPCKLWD"}, {9, "PUNPCKLDQ"},
	{10, "VPUNPCKLDQ"}, {8, "PACKSSWB"}, {9, "VPACKSSWB"}, {7, "PCMPGTB"}, {8, "VPCMPGTB"},
	{7, "PCMPGTW"}, {8, "VPCMPGTW"}, {7, "PCMPGTD"}, {8, "VPCMPGTD"}, {8, "PACKUSWB"},
	{9, "VPACKUSWB"}, {9, "PUNPCKHBW"}, {10, "VPUNPCKHBW"}, {9, "PUNPCKHWD"},
	{10, "VPUNPCKHWD"}, {9, "PUNPCKHDQ"}, {10, "VPUNPCKHDQ"}, {8, "PACKSSDW"},
	{9, "VPACKSSDW"}, {10, "PUNPCKLQDQ"}, {11, "VPUNPCKLQDQ"}, {10, "PUNPCKHQDQ"},
	{11, "VPUNPCKHQDQ"}, {4, "MOVD"}, {4, "MOVQ"}, {5, "VMOVD"}, {5, "VMOVQ"},
	{6, "MOVDQA"}, {6, "MOVDQU"}, {7, "VMOVDQA"}, {7, "VMOVDQU"}, {6, "PSHUFW"},
	{6, "PSHUFD"}, {7, "PSHUFHW"}, {7, "PSHUFLW"}, {7, "VPSHUFD"}, {8, "VPSHUFHW"},
	{8, "VPSHUFLW"}, {5, "PSRLW"}, {6, "VPSRLW"}, {5, "PSRAW"}, {6, "VPSRAW"},
	{5, "PSLLW"}, {6, "VPSLLW"}, {5, "PSRLD"}, {6, "VPSRLD"}, {5, "PSRAD"}, {6, "VPSRAD"},
	{5, "PSLLD"}, {6, "VPSLLD"}, {5, "PSRLQ"}, {6, "VPSRLQ"}, {6, "PSRLDQ"}, {7, "VPSRLDQ"},
	{5, "PSLLQ"}, {6, "VPSLLQ"}, {6, "PSLLDQ"}, {7, "VPSLLDQ"}, {7, "PCMPEQB"},
	{8, "VPCMPEQB"}, {7, "PCMPEQW"}, {8, "VPCMPEQW"}, {7, "PCMPEQD"}, {8, "VPCMPEQD"},
	{4, "EMMS"}, {10, "VZEROUPPER"}, {8, "VZEROALL"}, {6, "VMREAD"}, {5, "EXTRQ"},
	{7, "INSERTQ"}, {7, "VMWRITE"}, {6, "HADDPD"}, {6, "HADDPS"}, {7, "VHADDPD"},
	{7, "VHADDPS"}, {6, "HSUBPD"}, {6, "HSUBPS"}, {7, "VHSUBPD"}, {7, "VHSUBPS"},
	{6, "FXSAVE"}, {7, "FXRSTOR"}, {4, "XAVE"}, {6, "LFENCE"}, {6, "XRSTOR"}, {6, "MFENCE"},
	{6, "SFENCE"}, {7, "CLFLUSH"}, {7, "LDMXCSR"}, {8, "VLDMXCSR"}, {7, "STMXCSR"},
	{8, "VSTMXCSR"}, {6, "POPCNT"}, {3, "BSR"}, {5, "LZCNT"}, {7, "CMPEQPS"}, {7, "CMPLTPS"},
	{7, "CMPLEPS"}, {10, "CMPUNORDPS"}, {8, "CMPNEQPS"}, {8, "CMPNLTPS"}, {8, "CMPNLEPS"},
	{8, "CMPORDPS"}, {7, "CMPEQPD"}, {7, "CMPLTPD"}, {7, "CMPLEPD"}, {10, "CMPUNORDPD"},
	{8, "CMPNEQPD"}, {8, "CMPNLTPD"}, {8, "CMPNLEPD"}, {8, "CMPORDPD"}, {7, "CMPEQSS"},
	{7, "CMPLTSS"}, {7, "CMPLESS"}, {10, "CMPUNORDSS"}, {8, "CMPNEQSS"}, {8, "CMPNLTSS"},
	{8, "CMPNLESS"}, {8, "CMPORDSS"}, {7, "CMPEQSD"}, {7, "CMPLTSD"}, {7, "CMPLESD"},
	{10, "CMPUNORDSD"}, {8, "CMPNEQSD"}, {8, "CMPNLTSD"}, {8, "CMPNLESD"}, {8, "CMPORDSD"},
	{8, "VCMPEQPS"}, {8, "VCMPLTPS"}, {8, "VCMPLEPS"}, {11, "VCMPUNORDPS"}, {9, "VCMPNEQPS"},
	{9, "VCMPNLTPS"}, {9, "VCMPNLEPS"}, {9, "VCMPORDPS"}, {8, "VCMPEQPD"}, {8, "VCMPLTPD"},
	{8, "VCMPLEPD"}, {11, "VCMPUNORDPD"}, {9, "VCMPNEQPD"}, {9, "VCMPNLTPD"},
	{9, "VCMPNLEPD"}, {9, "VCMPORDPD"}, {8, "VCMPEQSS"}, {8, "VCMPLTSS"}, {8, "VCMPLESS"},
	{11, "VCMPUNORDSS"}, {9, "VCMPNEQSS"}, {9, "VCMPNLTSS"}, {9, "VCMPNLESS"},
	{9, "VCMPORDSS"}, {8, "VCMPEQSD"}, {8, "VCMPLTSD"}, {8, "VCMPLESD"}, {11, "VCMPUNORDSD"},
	{9, "VCMPNEQSD"}, {9, "VCMPNLTSD"}, {9, "VCMPNLESD"}, {9, "VCMPORDSD"}, {6, "PINSRW"},
	{7, "VPINSRW"}, {6, "SHUFPS"}, {6, "SHUFPD"}, {7, "VSHUFPS"}, {7, "VSHUFPD"},
	{9, "CMPXCHG8B"}, {10, "CMPXCHG16B"}, {7, "VMPTRST"}, {7, "VMPTRLD"}, {7, "VMCLEAR"},
	{5, "VMXON"}, {8, "ADDSUBPD"}, {8, "ADDSUBPS"}, {9, "VADDSUBPD"}, {9, "VADDSUBPS"},
	{5, "PADDQ"}, {6, "VPADDQ"}, {6, "PMULLW"}, {7, "VPMULLW"}, {7, "MOVQ2DQ"},
	{7, "MOVDQ2Q"}, {8, "PMOVMSKB"}, {9, "VPMOVMSKB"}, {7, "PSUBUSB"}, {8, "VPSUBUSB"},
	{7, "PSUBUSW"}, {8, "VPSUBUSW"}, {6, "PMINUB"}, {7, "VPMINUB"}, {4, "PAND"},
	{5, "VPAND"}, {7, "PADDUSB"}, {8, "VPADDUSW"}, {7, "PADDUSW"}, {6, "PMAXUB"},
	{7, "VPMAXUB"}, {5, "PANDN"}, {6, "VPANDN"}, {5, "PAVGB"}, {6, "VPAVGB"}, {5, "PAVGW"},
	{6, "VPAVGW"}, {7, "PMULHUW"}, {8, "VPMULHUW"}, {6, "PMULHW"}, {7, "VPMULHW"},
	{9, "CVTTPD2DQ"}, {8, "CVTDQ2PD"}, {8, "CVTPD2DQ"}, {10, "VCVTTPD2DQ"}, {9, "VCVTDQ2PD"},
	{9, "VCVTPD2DQ"}, {6, "MOVNTQ"}, {7, "MOVNTDQ"}, {8, "VMOVNTDQ"}, {6, "PSUBSB"},
	{7, "VPSUBSB"}, {6, "PSUBSW"}, {7, "VPSUBSW"}, {6, "PMINSW"}, {7, "VPMINSW"},
	{3, "POR"}, {4, "VPOR"}, {6, "PADDSB"}, {7, "VPADDSB"}, {6, "PADDSW"}, {7, "VPADDSW"},
	{6, "PMAXSW"}, {7, "VPMAXSW"}, {4, "PXOR"}, {5, "VPXOR"}, {5, "LDDQU"}, {6, "VLDDQU"},
	{7, "PMULUDQ"}, {8, "VPMULUDQ"}, {7, "PMADDWD"}, {8, "VPMADDWD"}, {6, "PSADBW"},
	{7, "VPSADBW"}, {8, "MASKMOVQ"}, {10, "MASKMOVDQU"}, {11, "VMASKMOVDQU"},
	{5, "PSUBB"}, {6, "VPSUBB"}, {5, "PSUBW"}, {6, "VPSUBW"}, {5, "PSUBD"}, {6, "VPSUBD"},
	{5, "PSUBQ"}, {6, "VPSUBQ"}, {5, "PADDB"}, {6, "VPADDB"}, {5, "PADDW"}, {6, "VPADDW"},
	{5, "PADDD"}, {6, "VPADDD"}, {3, "ROL"}, {3, "ROR"}, {3, "RCL"}, {3, "RCR"},
	{3, "SHL"}, {3, "SHR"}, {3, "SAL"}, {3, "SAR"}, {4, "FADD"}, {4, "FMUL"}, {4, "FCOM"},
	{5, "FCOMP"}, {4, "FSUB"}, {5, "FSUBR"}, {4, "FDIV"}, {5, "FDIVR"}, {3, "FLD"},
	{3, "FST"}, {4, "FSTP"}, {6, "FLDENV"}, {5, "FLDCW"}, {4, "FXCH"}, {4, "FNOP"},
	{4, "FCHS"}, {4, "FABS"}, {4, "FTST"}, {4, "FXAM"}, {4, "FLD1"}, {6, "FLDL2T"},
	{6, "FLDL2E"}, {5, "FLDPI"}, {6, "FLDLG2"}, {6, "FLDLN2"}, {4, "FLDZ"}, {5, "F2XM1"},
	{5, "FYL2X"}, {5, "FPTAN"}, {6, "FPATAN"}, {7, "FXTRACT"}, {6, "FPREM1"}, {7, "FDECSTP"},
	{7, "FINCSTP"}, {5, "FPREM"}, {7, "FYL2XP1"}, {5, "FSQRT"}, {7, "FSINCOS"},
	{7, "FRNDINT"}, {6, "FSCALE"}, {4, "FSIN"}, {4, "FCOS"}, {7, "FNSTENV"}, {6, "FSTENV"},
	{6, "FNSTCW"}, {5, "FSTCW"}, {5, "FIADD"}, {5, "FIMUL"}, {5, "FICOM"}, {6, "FICOMP"},
	{5, "FISUB"}, {6, "FISUBR"}, {5, "FIDIV"}, {6, "FIDIVR"}, {6, "FCMOVB"}, {6, "FCMOVE"},
	{7, "FCMOVBE"}, {6, "FCMOVU"}, {7, "FUCOMPP"}, {4, "FILD"}, {6, "FISTTP"},
	{4, "FIST"}, {5, "FISTP"}, {7, "FCMOVNB"}, {7, "FCMOVNE"}, {8, "FCMOVNBE"},
	{7, "FCMOVNU"}, {4, "FENI"}, {6, "FEDISI"}, {6, "FSETPM"}, {6, "FUCOMI"}, {5, "FCOMI"},
	{6, "FNCLEX"}, {5, "FCLEX"}, {6, "FNINIT"}, {5, "FINIT"}, {6, "FRSTOR"}, {5, "FFREE"},
	{5, "FUCOM"}, {6, "FUCOMP"}, {6, "FNSAVE"}, {5, "FSAVE"}, {6, "FNSTSW"}, {5, "FSTSW"},
	{5, "FADDP"}, {5, "FMULP"}, {6, "FCOMPP"}, {6, "FSUBRP"}, {5, "FSUBP"}, {6, "FDIVRP"},
	{5, "FDIVP"}, {4, "FBLD"}, {5, "FBSTP"}, {7, "FUCOMIP"}, {6, "FCOMIP"}, {3, "NOT"},
	{3, "NEG"}, {3, "MUL"}, {3, "DIV"}, {4, "IDIV"}, {4, "WAIT"}, {6, "MOVSXD"},
	{5, "PAUSE"}
};

const _WRegister _REGISTERS[] = {
	{3, "RAX"}, {3, "RCX"}, {3, "RDX"}, {3, "RBX"}, {3, "RSP"}, {3, "RBP"}, {3, "RSI"}, {3, "RDI"}, {2, "R8"}, {2, "R9"}, {3, "R10"}, {3, "R11"}, {3, "R12"}, {3, "R13"}, {3, "R14"}, {3, "R15"},
	{3, "EAX"}, {3, "ECX"}, {3, "EDX"}, {3, "EBX"}, {3, "ESP"}, {3, "EBP"}, {3, "ESI"}, {3, "EDI"}, {3, "R8D"}, {3, "R9D"}, {4, "R10D"}, {4, "R11D"}, {4, "R12D"}, {4, "R13D"}, {4, "R14D"}, {4, "R15D"},
	{2, "AX"}, {2, "CX"}, {2, "DX"}, {2, "BX"}, {2, "SP"}, {2, "BP"}, {2, "SI"}, {2, "DI"}, {3, "R8W"}, {3, "R9W"}, {4, "R10W"}, {4, "R11W"}, {4, "R12W"}, {4, "R13W"}, {4, "R14W"}, {4, "R15W"},
	{2, "AL"}, {2, "CL"}, {2, "DL"}, {2, "BL"}, {2, "AH"}, {2, "CH"}, {2, "DH"}, {2, "BH"}, {3, "R8B"}, {3, "R9B"}, {4, "R10B"}, {4, "R11B"}, {4, "R12B"}, {4, "R13B"}, {4, "R14B"}, {4, "R15B"},
	{3, "SPL"}, {3, "BPL"}, {3, "SIL"}, {3, "DIL"},
	{2, "ES"}, {2, "CS"}, {2, "SS"}, {2, "DS"}, {2, "FS"}, {2, "GS"},
	{3, "RIP"},
	{3, "ST0"}, {3, "ST1"}, {3, "ST2"}, {3, "ST3"}, {3, "ST4"}, {3, "ST5"}, {3, "ST6"}, {3, "ST7"},
	{3, "MM0"}, {3, "MM1"}, {3, "MM2"}, {3, "MM3"}, {3, "MM4"}, {3, "MM5"}, {3, "MM6"}, {3, "MM7"},
	{4, "XMM0"}, {4, "XMM1"}, {4, "XMM2"}, {4, "XMM3"}, {4, "XMM4"}, {4, "XMM5"}, {4, "XMM6"}, {4, "XMM7"}, {4, "XMM8"}, {4, "XMM9"}, {5, "XMM10"}, {5, "XMM11"}, {5, "XMM12"}, {5, "XMM13"}, {5, "XMM14"}, {5, "XMM15"},
	{4, "YMM0"}, {4, "YMM1"}, {4, "YMM2"}, {4, "YMM3"}, {4, "YMM4"}, {4, "YMM5"}, {4, "YMM6"}, {4, "YMM7"}, {4, "YMM8"}, {4, "YMM9"}, {5, "YMM10"}, {5, "YMM11"}, {5, "YMM12"}, {5, "YMM13"}, {5, "YMM14"}, {5, "YMM15"},
	{3, "CR0"}, {0, ""}, {3, "CR2"}, {3, "CR3"}, {3, "CR4"}, {0, ""}, {0, ""}, {0, ""}, {3, "CR8"},
	{3, "DR0"}, {3, "DR1"}, {3, "DR2"}, {3, "DR3"}, {0, ""}, {0, ""}, {3, "DR6"}, {3, "DR7"}
};
