/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/


/**	@file	bifconf.c	dkbif configuration lister.
*/

#include "dk.h"

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif

/**	Text to list supported libraries.
*/
static char str_libs[] = {
"LIBRARIES:"
#if DK_HAVE_PNG_H
" -lpng"
#endif
#if DK_HAVE_JPEGLIB_H
" -ljpeg"
#endif
#if DK_HAVE_PNM_H || DK_HAVE_NETPBM_PNM_H
" -lnetpbm"
#endif
#if DK_HAVE_TIFF_H
" -ltiff"
#endif
"\n"
};


/**	Text contained define macros.
*/
static char str_defines[] = {
"CPPFLAGS:"
#if DK_HAVE_PNG_H
" -DHAVE_PNG_H=1 -DDK_HAVE_PNG_H=1"
#endif
#if DK_HAVE_JPEGLIB_H
" -DHAVE_JPEGLIB_H=1 -DDK_HAVE_JPEGLIB_H=1"
#endif
#if DK_HAVE_PNM_H
" -DHAVE_PNM_H=1 -DDK_HAVE_PNM_H=1"
#endif
#if DK_HAVE_NETPBM_PNM_H
" -DHAVE_NETPBM_PNM_H=1 -DDK_HAVE_NETPBM_PNM_H=1"
#endif
#if DK_HAVE_TIFF_H
" -DHAVE_TIFF_H=1 -DDK_HAVE_TIFF_H=1"
#endif
#if DK_HAVE_LZW
" -DHAVE_LZW=1 -DDK_HAVE_LZW=1"
#else
" -DHAVE_LZW=0 -DDK_HAVE_LZW=0"
#endif
"\n"
};


/**	The bifconf main() function.
	@param	argc	Number of command line arguments
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  fputs(str_defines, stdout);
  fputs(str_libs, stdout);
  exit(0); return 0;
}

