/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	dk.h
	Main include file for dklibs configuration.

	This file includes other files (dkconfig.h, dkproto.h and dktypes.h)
	needed by the dklibs library set.
*/

/**	@mainpage	The dktools project.
 	In May/June 2010 some other projects (dklibs, bmeps, fig2vect,
	fchksum, fsnmp, genau, hostsadm, jlayout, tcptool and yanolc)
	were merged into dktools. Most of the projects use modules
	from the dklibs library set (the former dklibs project).

	The dklibs library set consists of the following libraries:
	- libdkport 
	- libdkc
	- libdknet
	- libdklatsup
	- libdkappr
	- libdksdbi
	- libdkbif
	- libdktrace.

	The lidbkport libarary provides functions and data types for
	portable programming.

	The libdkc library contains modules for various purposes,
	i.e. sorted storage of objects in containers, internationalization
	and logging.

	The libdknet library contains modules for portable client side
	TCP/IP networking (portable between Windows and UNIX/Linux).

	The libdklatsup library contains functions to generate LaTeX
	output (i.e. conversion of characters to LaTeX sequences).

	The libdkappr library contains modules to access random number
	generators.

	The libdksdbi library contains modules to access NDBM, GDBM
	and BerkeleyDB databases using the libraries supplied by the
	database vendors via a simple unique interface.

	The libdkbif library contains modules to read some bitmap image
	file formats using specialized libraries (i.e. libpng...) via a
	simple unique interface.

	The libdktrace library can be linked to projects containing *.c
	files generated by tracecc to produce debug output.
*/

#ifndef DK_INC

/** Make sure to include this file only once. */
#define DK_INC 1

#include <dkconfig.h>
#include <dkproto.h>
#include <dktypes.h>
#include <dkdircfg.h>

#endif

