/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dkstt.c	String table module.
*/



#include "dk.h"
#include "dkmem.h"
#include "dkstream.h"



/**	Inside the dkstt module.
*/
#define DK_STT_C 1

#include "dkstt.h"




#line 59 "dkstt.ctr"




/**	Abbreviation for use with sizeof operator.
*/
typedef char *CHARPTR;



/**	Initialize string table structure.
	@param	s	String table structure.
*/
static
void
dkstt_init DK_P1(dk_stt_t *, s)
{
  s->vers_major = 0;
  s->vers_minor = 0;
  s->elems      = 0;
  s->keys       = NULL;
  s->values     = NULL;
}



void
dkstt_close DK_P1(dk_stt_t *, s)
{
  dk_uword u;
  char *cptr, **cpptr;
  
  if(s) {
    if(s->keys) {
      cpptr = s->keys;
      u = s->elems;
      while(u--) {
	cptr = *cpptr;
	if(cptr) { dk_delete(cptr); }
	*(cpptr++) = NULL;
      }
      cpptr = s->keys;
      dk_delete(cpptr);
    }
    if(s->values) {
      cpptr = s->values;
      u = s->elems;
      while(u--) {
	cptr = *cpptr;
	if(cptr) { dk_delete(cptr); }
	*(cpptr++) = NULL;
      }
      cpptr = s->values;
      dk_delete(cpptr);
    }
    s->keys = NULL;
    s->values = NULL;
    s->vers_major = 0; s->vers_minor = 0; s->elems = 0;
    dk_delete(s);
  } 
}



/**	File header of *stt file.
*/
static char file_type_identifier[] = { "STRT-2" };



dk_stt_t *
dkstt_open DK_P1(dk_stream_t *, strm)
{
  dk_stt_t *back = NULL;
  char buffer[7], **cp1, **cp2;
  dk_uword uw, co;
  int ok;
  
  if(strm) {
    back = dk_new(dk_stt_t,1);
    if(back) {
      ok = 1;
      dkstt_init(back);
      if(dkstream_read(strm,buffer,7) == 7) {
        if(strcmp(buffer, file_type_identifier) == 0) {
	  if(dkstream_rb_uword(strm, &uw)) {
	    back->vers_major = uw;
	    if(dkstream_rb_uword(strm, &uw)) {
	      back->vers_minor = uw;
	      if(dkstream_rb_uword(strm, &uw)) {
		back->elems = uw;
		if(dkstream_rb_uword(strm, &uw)) {
		  co = uw;
		  uw = back->elems;
		  if(uw) {
                    cp1 = dk_new(CHARPTR,uw);
		    cp2 = dk_new(CHARPTR,uw);
		    if(cp1 && cp2) {
		      back->keys = cp1;
		      back->values = cp2;
		      while(uw--) {
			*(cp1++) = NULL;
			*(cp2++) = NULL;
		      }
		      cp1 = back->keys;
		      cp2 = back->values;
		      uw = back->elems;
		      while(uw-- && ok) {
			*cp1 = dkstream_rb_string(strm);
			if(!(*cp1)) { ok = 0; }
			cp1++;
		      }
		      if(ok) {
		      uw = back->elems;
		      while(uw-- && ok) {
			*cp2 = dkstream_rb_string(strm);
			if(!(*cp2)) { ok = 0; }
			cp2++;
		      }
		      }
		    } else {
		      if(cp1) { dk_delete(cp1) ; }
		      if(cp2) { dk_delete(cp2) ; }
		      ok = 0;
		    }
		  } else {
		    ok = 0;
		  }
		} else {
		  ok = 0;
		}
	      } else {
		ok = 0;
	      }
	    } else {
	      ok = 0;
	    }
	  } else {
	    ok = 0;
	  }
	} else {
	  ok = 0;
	}
      } else {
	ok = 0;
      }
      if(!ok) {
	dkstt_close(back);
	back = NULL;
      }
    }
  } 
  return back;
}



char *
dkstt_find DK_P3(dk_stt_t *,s,char *,key,char *,def)
{
  char *back = NULL;
  char **kptr, **vptr;
  dk_uword a, m, b;
  int res;
  
  if(s && key) {
    if((s->elems) && (s->keys) && (s->values)) {
      kptr = s->keys; vptr = s->values;
      a = 0; b = s->elems; b--;
      while((!back) && (b > (a + 1))) {
	m = (a + b) / 2;
	if(kptr[m]) {
	  res = strcmp(kptr[m],key);
	  if(res == 0) {
	    back = vptr[m];
	    if(!back) { goto error_label; }
	  } else {
	    if(res < 0) {
	      a = m;
	    } else {
	      b = m;
	    }
	  }
	} else {
	  goto error_label;
	}
      }
      if(!back) {
	if(kptr[a]) {
	  if(strcmp(kptr[a],key) == 0) {
	    back = vptr[a];
	  }
	}
      }
      if(!back) {
	if(kptr[b]) {
	  if(strcmp(kptr[b],key) == 0) {
	    back = vptr[b];
	  }
	}
      }
    }
  }
error_label:
  
  if(!back) {
    back = def;
  }
  return back;
}


