/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file dkstt.h String tables.
	This modules provides functions to deal with string tables.
*/

#ifndef DK_STT_INCLUDED
#define DK_STT_INCLUDED 1

#include <dk.h>
#include <dktypes.h>

#if defined(EXTERN)
#undef EXTERN
#endif
#ifndef DK_STT_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif

#if defined(__cplusplus)
extern "C" {
#endif



/**	Read string table from stream.
	@param	st	Stream to read string table from.
	@return	Pointer to new string table on success, NULL on error.
	On success the function returns a pointer to a string table
	structure in dynamically allocated memory, use dkstt_close()
	to release the memory.
*/
EXTERN dk_stt_t *
dkstt_open DK_PR((dk_stream_t *st));



/**	Close string table release memory.
	@param	s	String table to close.
*/
EXTERN void
dkstt_close DK_PR((dk_stt_t *s));



/**	Retrieve string table entry.
	The function returns a pointer to the found string
	(in memory managed by the string table structure) or \a d.
	@param	s	String table.
	@param	k	Entry name to search for.
	@param	d	Result to return if the string is not found.
	@return	Pointer to string or \a d.
*/
EXTERN char *
dkstt_find DK_PR((dk_stt_t *s, char *k, char *d));



#if defined(__cplusplus)
}
#endif

#endif
/* DK_STT_INCLUDED */

