/*
jlayout - A Java code generator for GUI layout
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	jlo.c	The jlo module of the jlayout program.
*/



/**	Inside the jlo module.
*/
#define JLO_C	1

#include "jl.h"




#line 54 "jlo.ctr"




/**	The list of known classes.
*/
static char *known_classes[] = {
  "existing",		/*  1 */
  "JFrame",		/*  2 */
  "JDialog",		/*  3 */
  "JPanel",		/*  4 */
  "JApplet",		/*  5 */
  "JButton",		/*  6 */
  "JCheckBox",		/*  7 */
  "JRadioButton",	/*  8 */
  "JCheckBoxMenuItem",	/*  9 */
  "JRadioButtonMenuItem",	/*  10 */
  "JToggleButton",	/* 11 */
  "JColorChooser",	/* 12 */
  "JComboBox",		/* 13 */
  "JOptionPane",	/* 14 */
  "JEditorPane",	/* 15 */
  "JTextPane",		/* 16 */
  "JFileChooser",	/* 17 */
  "JFormattedTextField",	/* 18 */
  "JInternalFrame",	/* 19 */
  "JDesktopPane",	/* 20 */
  "JLayeredPane",	/* 21 */
  "JLabel",		/* 22 */
  "JList",		/* 23 */
  "JMenuBar",		/* 24 */
  "JMenu",		/* 25 */
  "JMenuItem",		/* 26 */
  "JPasswordField",	/* 27 */
  "JProgressBar",	/* 28 */
  "JScrollPane",	/* 29 */
  "JSeparator",		/* 30 */
  "JSlider",		/* 31 */
  "JSpinner",		/* 32 */
  "JSplitPane",		/* 33 */
  "JTabbedPane",	/* 34 */
  "JTable",		/* 35 */
  "JTextArea",		/* 36 */
  "JTextField",		/* 37 */
  "JToolBar",		/* 38 */
  "JComponent",		/* 39 */
  "JTree",		/* 40 */
  "JPopupMenu",		/* 41 */
  NULL
};

/**	Abbreviation for use with sizeof.
*/
typedef char *CPTR;

/**	Number of entries in \a known_classes.
*/
static size_t sz_known_classes = sizeof(known_classes)/sizeof(CPTR);



/**	Initialize a new JLO.
	@param	o	Jlayout object.
*/
static
void
init_empty DK_P1(JLO *,o)
{
  o->on = NULL;
  o->oc = NULL;
  o->ocn = CLASS_NOT_SPECIFIED;
  o->obj_no = 0UL;
  o->border = NULL;
  o->c_border = NULL;
  o->fill = o->c_fill = FILL_NOT_SPECIFIED;
  o->anchor = o->c_anchor = ANCHOR_NOT_SPECIFIED;
  o->l_creation = 0UL;
  o->layout = LAYOUT_NOT_SPECIFIED;
  o->rows = 0L; o->columns = 0L; o->last_row_used = 0L; o->last_col_used = 0L;
  o->constructor = NULL;
  o->action_cmd = NULL;
  o->text = NULL;
  o->border_text = NULL;
  o->icon_file = NULL;
  o->l_st = NULL; o->l_it = NULL; o->li_st = NULL; o->li_it = NULL;
  o->n_listeners = 0UL;
  o->tf_width = NULL;
  o->c_st = NULL; o->c_it = NULL; o->n_c = 0UL;
  o->card_add_text = NULL;
  o->current_x = 0L; o->current_y = 0L;
  o->current_w = 1L; o->current_h = 1L;
  o->pos_x = 0L; o->pos_y = 0L; o->pos_w = 0L; o->pos_h = 0L;
  o->cor_x = o->cor_y = o->cor_w = o->cor_h = 0L;
  o->cor_mx = o->cor_my = 0L;
  o->obj_lvl = 0UL;
  o->border_type = BORDER_NOT_SPECIFIED;
  o->bo_top = o->bo_left = o->bo_right = o->bo_bottom = -1;
  o->f2 = 0UL;
  o->max_x = o->max_y = 0L;
  o->menubar = NULL;
  o->distance_x = NULL; o->distance_y = NULL;
  o->weightx = o->weighty = -1.0;
  o->s_min_x = o->s_min_y = o->s_pref_x = o->s_pref_y = o->s_min_x = o->s_max_y
  = -1L;
  o->tt_text = NULL;
  o->acd_text = NULL;
  o->h_align = HALIGN_NOT_SPECIFIED;
  o->v_align = VALIGN_NOT_SPECIFIED;
  o->h_textpos = HTEXTPOS_NOT_SPECIFIED;
  o->v_textpos = VTEXTPOS_NOT_SPECIFIED;
  o->title = NULL;
  o->def_close = CLOSE_OPERATION_NOT_SPECIFIED;
  o->enab = ENABLED_NOT_SPECIFIED;
  o->font = NULL;
  o->foreground = NULL;
  o->background = NULL;
  o->font_changes = 0x00;
  o->weightl = o->weightr = o->weightt = o->weightb = 0.5;
}



void
jlo_delete DK_P1(JLO *,o)
{
  char *x;
  JLISTENER *jl; JCN *jcn;
  
  if(o) {
    if(o->background) {
      x = o->background; dk_delete(x);
    } o->background = NULL;
    if(o->foreground) {
      x = o->foreground; dk_delete(x);
    } o->foreground = NULL;
    if(o->font) {
      x = o->font; dk_delete(x);
    } o->font = NULL;
    if(o->li_st) {
      if(o->li_it) {
        dksto_it_close(o->li_it);
      }
      dksto_close(o->li_st);
    } o->li_st = NULL; o->li_it = NULL;
    if(o->l_st) {
      if(o->l_it) {
        dksto_it_reset(o->l_it);
	while((jl = (JLISTENER *)dksto_it_next(o->l_it)) != NULL) {
	  jlo_listener_delete(jl);
	}
        dksto_it_close(o->l_it);
      }
      dksto_close(o->l_st);
    } o->l_st = NULL; o->l_it = NULL;
    if(o->c_st) {
      if(o->c_it) {
        dksto_it_reset(o->c_it);
	while((jcn = (JCN *)dksto_it_next(o->c_it)) != NULL) {
	  
	  jlread_cn_delete(jcn);
	}
        dksto_it_close(o->c_it);
      }
      dksto_close(o->c_st);
    } o->c_st = NULL; o->c_it = NULL;
    o->n_c = 0UL;
    if(o->on) {	
      x = o->on; dk_delete(x);
    } o->on = NULL;
    if(o->oc) {	
      x = o->oc; dk_delete(x);
    } o->oc = NULL;	
    o->obj_no = 0UL;
    if(o->border) {	
      x = o->border; dk_delete(x);
    } o->border = NULL;
    if(o->c_border) {	
      x = o->c_border; dk_delete(x);
    } o->c_border = NULL;
    if(o->constructor) {	
      x = o->constructor; dk_delete(x);
    } o->constructor = NULL;
    if(o->action_cmd) {		
      x = o->action_cmd; dk_delete(x);
    } o->action_cmd = NULL;
    if(o->text) {		
      x = o->text; dk_delete(x);
    } o->text = NULL;
    if(o->icon_file) {		
      x = o->icon_file; dk_delete(x);
    } o->icon_file = NULL;
    if(o->border_text) {	
      x = o->border_text; dk_delete(x);
    } o->border_text = NULL;
    if(o->tf_width) {		
      x = o->tf_width; dk_delete(x);
    } o->tf_width = NULL;
    if(o->card_add_text) {	
      x = o->card_add_text; dk_delete(x);
    } o->card_add_text = NULL;
    if(o->distance_x) {
      dkbf_close(o->distance_x);
    } o->distance_x = NULL;
    if(o->distance_y) {
      dkbf_close(o->distance_y);
    } o->distance_y = NULL;
    if(o->tt_text) {
      x = o->tt_text; dk_delete(x);
    } o->tt_text = NULL;
    if(o->acd_text) {
      x = o->acd_text; dk_delete(x);
    } o->acd_text = NULL;
    if(o->title) {
      x = o->title; dk_delete(x);
    } o->title = NULL;
    
    
    
    
    
    o->fill = o->anchor = o->c_fill = o->c_anchor = 0;
    o->ocn = 0; o->border_type = 0;
    o->pos_x = o->pos_y = o->pos_w = o->pos_h = 0L;
    o->cor_x = o->cor_y = o->cor_w = o->cor_h = 0L;
    o->cor_mx = o->cor_my = 0L;
    o->current_x = o->current_y = o->current_w = o->current_h = 0L;
    o->obj_lvl = 0UL;
    o->bo_top = o->bo_left = o->bo_right = o->bo_bottom = 0;
    o->f2 = 0UL;
    o->max_x = o->max_y = 0L;
    o->menubar = NULL;
    
    
    
    
    o->weightx = o->weighty = 0.0;
    o->s_min_x = o->s_min_y = o->s_pref_x =
    o->s_pref_y = o->s_min_x = o->s_max_y
    = 0L;
    o->h_align = o->v_align = 0;
    o->h_textpos = o->v_textpos = 0;
    o->def_close = 0;
    o->enab = 0;
    dk_delete(o);
  }
  
}



JLO *
jlo_new DK_P1(char *,n)
{
  JLO *back = NULL;
  
  if(n) {
    back = dk_new(JLO,1);
    if(back) {
      init_empty(back);
      back->on = dkstr_dup(n);
      if(!(back->on)) {
        jlo_delete(back); back = NULL;
      }
    }
  } else {
    back = dk_new(JLO,1);
    if(back) {
      init_empty(back);
    }
  }
  
  return back;
}



int
jlo_set_classname DK_P2(JLO *,o, char *,cn)
{
  int back = 0; char *x;
  
  if((o) && (cn)) {
    if(o->oc) {
      x = o->oc; dk_delete(x); o->oc = NULL;
    } o->ocn = CLASS_NOT_SPECIFIED;
    o->ocn = dkstr_array_index(known_classes, cn, 1);
    if(o->ocn >= 0) {
      o->ocn += 1; back = 1;
      switch(o->ocn) {
        case CLASS_JFRAME:
	case CLASS_JDIALOG:
	case CLASS_JAPPLET:
	{
	  o->f2 |= F2_USE_CONTENT_PANE;
	} break;
      }
    } else {
      o->oc = dkstr_dup(cn);
      if(o->oc) {
        back = 1;
	o->ocn = CLASS_USER_DEFINED;
      }
    }
  }
  
  return back;
}



char *
jlo_get_classname DK_P1(JLO *,o)
{
  size_t sz;
  char *back = NULL;
  
  if(o) {
    switch(o->ocn) {
      case CLASS_NOT_SPECIFIED: {
      } break;
      case CLASS_USER_DEFINED: {
        back = o->oc;
      } break;
      default: {
        if(o->ocn > 0) {
	  sz = (size_t)(o->ocn - 1);
          if(sz < sz_known_classes) {
	    back = known_classes[sz];
	  }
	}
      } break;
    }
  }
  
  return back;
}



void
jsg_delete DK_P1(JSG *,j)
{
  char *x;
  
  if(j) {
    if(j->n) {	
      x = j->n; dk_delete(x);
    } j->n = NULL;
    if(j->s) {
      if(j->i) {
        dksto_it_close(j->i);
      }
      dksto_close(j->s);
    } j->s = NULL; j->i = NULL;
    dk_delete(j);
  } 
}



JSG *
jsg_new DK_P1(char *,n)
{
  JSG *back = NULL; int ok = 0;
  
  if(n) {
    back = dk_new(JSG,1);
    if(back) {
      back->n = NULL; back->s = NULL; back->i = NULL; ok = 0;
      back->n = dkstr_dup(n);
      if(back->n) {
        back->s = dksto_open(0);
	if(back->s) {
	  dksto_set_comp(
	    back->s, jlread_compare_objects_by_name, CR_COMPARE_OBJECTS
	  );
	  back->i = dksto_it_open(back->s);
	  if(back->i) {
	    ok = 1;
	  }
	}
      }
      if(!ok) {
        jsg_delete(back); back = NULL;
      }
    }
  }
  
  return back;
}



void
jlo_listener_delete DK_P1(JLISTENER *,jl)
{
  char *x;
  
  if(jl) {
    jl->tp = 0;
    jl->number = 0UL;
    if(jl->t) {
      x = jl->t; dk_delete(x);
    } jl->t = NULL;
    dk_delete(jl);
  } 
}



JLISTENER *
jlo_listener_new DK_P3(int,tp, char *,t, unsigned long,n)
{
  JLISTENER *back = NULL;
  
  if(t) {
  back = dk_new(JLISTENER,1);
  if(back) {
    back->tp = tp; back->number = n;
    back->t = dkstr_dup(t);
    if(!(back->t)) {
      jlo_listener_delete(back); back = NULL;
    }
  }
  } 
  return back;
}





