#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"


#include "dk.h"
#include "dkmem.h"
#include "dksf.h"
#include "dkstr.h"
#include "dkapp.h"
#include "dkstream.h"

static char default_etc_dir[] = { "/etc" };
static char default_gnam[] = { "perlx" };

static char str_file[] = { "p$lain" };
static char str_gzip[] = { "g$zip" };
static char str_bzip2[] = { "b$zip2" };
static char *array[] = { str_file, str_gzip, str_bzip2, NULL};

MODULE = DKrause::Application	PACKAGE = DKrause::Application	PREFIX = a_


PROTOTYPES: ENABLE

DKrause::Application
a_new(an,gn,scd,silent,filter)
		char *an;
		char *gn;
		char *scd;
		int   silent;
		int   filter;
	PREINIT:
		dk_app_t *back = NULL;
		char *myargv[2];
		char *etcdir = NULL;
		char *gnam = NULL;
	CODE:
		myargv[0] = an;
		myargv[1] = NULL;
		if(scd) etcdir = scd;
		else etcdir = default_etc_dir;
		if(gn) gnam = gn;
		else gnam = default_gnam;
		back = dkapp_open_ext1(1, myargv, gnam, etcdir, silent, filter);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



void
a_DESTROY(a)
		DKrause::Application a;
	CODE:
		dkapp_close(a);



int
a_log(a,p,m)
		DKrause::Application a;
		int p;
		char *m;
	PREINIT:
		char *msg[2];
	CODE:
		msg[0] = m; msg[1] = NULL;
		RETVAL = dkapp_log_msg(a, p, msg, 1);
	OUTPUT:
		RETVAL


char *
a_getPreference(a,k,ex=0)
		DKrause::Application a;
		char *k;
		int  ex;
	PREINIT:
		char buffer[1024];
	CODE:
		if(k) {
		  if(dkapp_get_pref(a, k, buffer, sizeof(buffer), ex)) {
		    RETVAL = buffer;
		  } else {
		    XSRETURN_UNDEF;
		  }
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


void
a_setPreference(a,k,v)
		DKrause::Application a;
		char *k;
		char *v;
	CODE:
		if((k) && (v)) {
		  (void)dkapp_set_pref(a, k, v);
		}



char *
a_transformString(a,s);
		DKrause::Application a;
		char *s;
	PREINIT:
		char buffer[4096];
	CODE:
		if(dkapp_transform_string(a, buffer, sizeof(buffer), s)) {
		  RETVAL = buffer;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_transformStringOrFilename(a,s,fn=1)
		DKrause::Application a;
		char *s;
		int   fn;
	PREINIT:
		char b[4096];
	CODE:
		if(dkapp_transform_string_ext1(a,b,sizeof(b),s,fn)) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_findConfigurationFile(a,n)
		DKrause::Application a;
		char *n;
	PREINIT:
		char b[4096];
	CODE:
		if(dkapp_find_cfg(a, n, b, sizeof(b))) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_findDataFile(a,n)
		DKrause::Application a;
		char *n;
	PREINIT:
		char b[4096];
	CODE:
		if(dkapp_find_file(a, n, b, sizeof(b))) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_findString(a,t,k,d="")
		DKrause::Application a;
		char *t;
		char *k;
		char *d;
	PREINIT:
		char *back = NULL;
	CODE:
		back = dkapp_find_string(a, t, k, d);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


DKrause::Stream
a_readDataFile(a, fn)
		DKrause::Application a;
		char *fn;
	PREINIT:
		dk_stream_wrapper_t *back = NULL;
		dk_stream_t *str = NULL;
	CODE:
		str = dkapp_read_file(a, fn);
		if(str) {
		  back = dk_new(dk_stream_wrapper_t,1);
		  if(back) {
		    back->s = str;
		    back->flags = DK_STREAM_FLAGS_STATE_USABLE;
		  } else {
		    dkstream_close(str); str = NULL;
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



DKrause::Stream
a_readConfigurationFile(a, fn)
		DKrause::Application a;
		char *fn;
	PREINIT:
		DKrause__Stream back = NULL;
		dk_stream_t *str = NULL;
	CODE:
		str = dkapp_read_cfg(a, fn);
		if(str) {
		  back = dk_new(dk_stream_wrapper_t,1);
		  if(back) {
		    back->s = str;
		    back->flags = DK_STREAM_FLAGS_STATE_USABLE;
		  } else {
		    dkstream_close(str); str = NULL;
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


DKrause::Stream
a_writeFile(a,n)
		DKrause::Application a;
		char *n;
	PREINIT:
		dk_stream_wrapper_t *back = NULL;
		dk_stream_t *str = NULL;
	CODE:
		str = dkapp_write_file(a, n);
		if(str) {
		  back = dk_new(dk_stream_wrapper_t,1);
		  if(back) {
		    back->s = str;
		    back->flags = DK_STREAM_FLAGS_STATE_USABLE;
		  } else {
		    dkstream_close(str); str = NULL;
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


char *
a_tempFileName(a)
		DKrause::Application a;
	PREINIT:
		char b[4096];
	CODE:
		if(dkapp_tmpnam(a, b, sizeof(b))) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


void
a_unconfigure(a)
		DKrause::Application a;
	CODE:
		dkapp_unconfigure(a);



DKrause::Stream
a_openFile(a,n,m,t="plain")
		DKrause::Application a;
		char *n;
		char *m;
		char *t;
	PREINIT:
		dk_stream_wrapper_t *back = NULL;
		dk_stream_t *str = NULL;
		int ft = 0;
	CODE:
		ft = dkstr_array_abbr(array, t, '$', 0);
		if(ft > -1) {
		  switch(ft) {
		    case 2: {	/* bzip2 */
		      str = dkapp_stream_openbz2(a,n,m);
		    } break;
		    case 1: {	/* gzip */
		      str = dkapp_stream_opengz(a,n,m);
		    } break;
		    default: {	/* file */
		      str = dkapp_stream_openfile(a,n,m);
		    } break;
		  }
		} else {
		  /* ERROR: unknown file type */
		}
		if(str) {
		  back = dk_new(dk_stream_wrapper_t,1);
		  if(back) {
		    back->s = str;
		    back->flags = DK_STREAM_FLAGS_STATE_USABLE;
		  } else {
		    dkstream_close(str); str = NULL;
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_getApplicationName(a)
		DKrause::Application a;
	CODE:
		RETVAL = dkapp_get_appname(a);
	OUTPUT:
		RETVAL



void
a_setSilent(a,f)
		DKrause::Application a;
		int f;
	CODE:
		dkapp_set_silent(a, f);



void
a_setFilter(a,f)
		DKrause::Application a;
		int f;
	CODE:
		dkapp_set_nostdio(a, f);



void
a_setGroupName(a,n)
		DKrause::Application a;
		char *n;
	CODE:
		(void)dkapp_set_groupname(a,n);



int
a_getMinimalLogLevel(a)
		DKrause::Application a;
	CODE:
		RETVAL = dkapp_get_min_loglevel(a);
	OUTPUT:
		RETVAL



void
a_setSourceFileName(a,n)
		DKrause::Application a;
		char *n;
	CODE:
		dkapp_set_source_filename(a,n);



void
a_setSourceLineNumber(a,n)
		DKrause::Application a;
		unsigned long n;
	CODE:
		dkapp_set_source_lineno(a,n);



char *
a_getSourceFileName(a)
		DKrause::Application a;
	PREINIT:
		char *back = NULL;
	CODE:
		back = dkapp_get_source_filename(a);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



unsigned long
a_getSourceLineNumber(a)
		DKrause::Application a;
	CODE:
		RETVAL = dkapp_get_source_lineno(a);
	OUTPUT:
		RETVAL



int
a_getPreferenceBoolean(a,k)
		DKrause::Application a;
		char *k;
	CODE:
		RETVAL = dkapp_get_bool_pref(a, k);
	OUTPUT:
		RETVAL



unsigned long
a_getPreferenceUnsignedLong(a,k)
		DKrause::Application a;
		char *k;
	CODE:
		RETVAL = dkapp_get_ul_pref(a, k);
	OUTPUT:
		RETVAL


char *
a_getPreferenceString(a,k)
		DKrause::Application a;
		char *k;
	PREINIT:
		char *back = NULL;
	CODE:
		back = dkapp_get_str_pref(a, k);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL


void
a_setKeepTemporaryFiles(a,l)
		DKrause::Application a;
		int l;
	CODE:
		dkapp_set_keep_temp(a,l);



long
a_getMaxPathLength(a)
		DKrause::Application a;
	CODE:
		RETVAL = dksf_get_maxpathlen();
	OUTPUT:
		RETVAL



long
a_getMaxFiles(a)
		DKrause::Application a;
	CODE:
		RETVAL = dksf_get_maxfiles();
	OUTPUT:
		RETVAL



char *
a_getcwd(a)
		DKrause::Application a;
	PREINIT:
		char *back = NULL;
		long mpl = 0L;
	CODE:
		mpl = dksf_get_maxpathlen();
		if(mpl <= 0L) { mpl = 1024; }
		back = dk_new(char,mpl);
		if(back) {
		  if(dksf_getcwd(back,mpl)) {
		    RETVAL = back;
		  } else {
		    XSRETURN_UNDEF;
		  }
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
	CLEANUP:
		if(back) { dk_delete(back); }



char *
a_getExecutableFileName(a,p)
		DKrause::Application a;
		char *p;
	PREINIT:
		char *back = NULL;
		char *cd = NULL;
		long mpl = 0UL;
	CODE:
		mpl = dksf_get_maxpathlen();
		if(mpl <= 0L) { mpl = 1024L; }
		back = dk_new(char,(size_t)mpl);
		cd = dk_new(char,(size_t)mpl);
		if((back) && (cd)) {
		  if(dksf_getcwd(cd,mpl)) {
		    if(dksf_get_executable(back,(size_t)mpl,cd,p,1)) {
		      RETVAL = back;
		    } else {
		      XSRETURN_UNDEF;
		    }
		  } else {
		    XSRETURN_UNDEF;
		  }
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
	CLEANUP:
		if(back) { dk_delete(back); }
		if(cd) { dk_delete(cd); }



char *
a_combinePaths(a,s,t)
		DKrause::Application a;
		char *s;
		char *t;
	PREINIT:
		char *b = NULL;
		size_t sz = 0;
	CODE:
		sz = strlen(s) + strlen(t) + 1;
		b = dk_new(char,sz);
		if(b) {
		  if(dksf_path_combine(b,sz,s,t)) {
		    RETVAL = b;
		  } else {
		    XSRETURN_UNDEF;
		  }
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
	CLEANUP:
		if(b) { dk_delete(b); }



int
a_isAbsolutePath(a,d)
		DKrause::Application a;
		char *d;
	CODE:
		RETVAL = dksf_is_abs_path(d);
	OUTPUT:
		RETVAL



char *
a_getFileNameSuffix(a,s)
		DKrause::Application a;
		char *s;
	PREINIT:
		char *b = NULL;
	CODE:
		b = dksf_get_file_type_dot(s);
		if(b) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
a_getLastFileName(a,s)
		DKrause::Application a;
		char *s;
	PREINIT:
		char *b = NULL;
	CODE:
		b = dksf_get_last_filename(s);
		if(b) {
		  RETVAL = b;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



void
a_correctFileName(a,s)
		DKrause::Application a;
		char *s;
	CODE:
		(void)dksf_correct_fnsep(s);



void
a_removeDirectory(a,s)
		DKrause::Application a;
		char *s;
	CODE:
		(void)dksf_remove_directory(s);



void
a_removeFile(a,s)
		DKrause::Application a;
		char *s;
	CODE:
		(void)dksf_remove_file(s);



DKrause::Stream
a_getLogStream(a)
		DKrause::Application a;
	PREINIT:
		dk_stream_wrapper_t *back = NULL;
		dk_stream_t *str = NULL;
		FILE *f = NULL;
	CODE:
		f = (a->l).f.t;
		if(f) {
		  str = dkstream_for_file(f);
		  if(str) {
		    back = dk_new(dk_stream_wrapper_t,1);
		    if(back) {
		      back->s = str;
		      back->flags = DK_STREAM_FLAGS_STATE_USABLE;
		    } else {
		      dkstream_close(str); str = NULL;
		    }
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
