/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dklic.c	Version number and license information.
*/



#include "dk.h"

/**	Inside the dklic module.
*/
#define DK_LIC_C 1

#include "dklic.h"



#if DK_HAVE_STRING_H
#include <string.h>
#endif

#include "dktools-version.h"



/**	Text to report the version and the used compression libraries
	and mechanisms.
*/
char *dklic_text[] = {
(char *)"dklibs       Portability layer and general purpose library " VERSNUMB ".",
(char *)"             http://dktools.sourceforge.net/",
#if REPORT_LZW_CONDITIONS
#if DK_HAVE_LZW
(char *)"             LZW compression support: enabled",
(char *)"             NOTE: Unisys U.S. LZW patent No. 4,558,302 expired on",
(char *)"             June 20, 2003, the counterpart patents in some other countries",
(char *)"             expired too.",
(char *)"             Please consult with your own legal counsel regarding your",
(char *)"             particular situation.",
(char *)"             Do not use LZW compression if LZW compression is protected",
(char *)"             by patent(s) in your country unless you obtained a license.",
#else
(char *)"             LZW compression support: disabled",
#endif
#endif
#if DK_HAVE_ZLIB_H
(char *)"zlib         General compression library.",
(char *)"             http://www.gzip.org/zlib/",
#endif
#ifdef DK_HAVE_BZLIB_H
(char *)"libbz2       Library for compressing/decompressing data in the bzip2 format.",
(char *)"             http://www.bzip.org/",
#endif
  NULL
};



char **
dklic_get DK_P0()
{
  return ((char **)dklic_text);
}

