
#include "decutf8.h"




#line 6 "decutf8.ctr"




#define INITIAL_BUFFER_SIZE	256


void
decutf8_delete DK_P1(dk_utf8_decode_t *,dp)
{
  char *x;
  
  if(dp) {
    if(dp->buffer) {
      x = dp->buffer;
      dk_delete(x);
    }
    dp->buffer = NULL;	
    dp->bufsz = 0;
    dp->f_error = 0x00;
    dk_delete(dp);
  } 
}



dk_utf8_decode_t *
decutf8_new DK_P0()
{
  dk_utf8_decode_t *back = NULL;
  
  back = dk_new(dk_utf8_decode_t,1);
  if(back) {
    back->bufsz = INITIAL_BUFFER_SIZE;
    back->f_error = 0x00;
    back->buffer = dk_new(char,INITIAL_BUFFER_SIZE);
    if(!(back->buffer)) {
      decutf8_delete(back);
      back = NULL;
    }
  } 
  return back;
}



int
decutf8_get_error DK_P1(dk_utf8_decode_t *,dp)
{
  int back = 0;
  
  if(dp) {
    if(dp->f_error) { back = 1; }
  } 
  return back;
}



void
decutr8_reset_error DK_P1(dk_utf8_decode_t *,dp)
{
  if(dp) {
    dp->f_error = 0x00;
  } 
}



char *
decutf8_decode DK_P2(dk_utf8_decode_t *,dp, char *,s)
{
  char *back = NULL;	/* Function result. */
  char *nb = NULL;	/* New buffer if necessary. */
  char *x = NULL;	/* Used to delete old buffer. */
  size_t	ns = 0;	/* Buffer size needed. */
  size_t	ni = 0;	/* Next index. */
  size_t	sl = 0;	/* String length of src. */
  size_t	us = 0;	/* Bytes used in current conversion. */
  size_t	ul = 0;	/* Length of decoded string. */
  int		ee = 0;	/* Encoding error. */
  int		f_cc = 0;
  dk_udword	uw = 0UL;
  unsigned char	uc = 0x00;
  char		c = 0x00;
  
  if(dp) {
  if(dp->buffer) {
    back = dp->buffer;
    *back = '\0';
    if(s) {
      ns = ni = us = ul = 0; ee = 0; f_cc = 1;
      sl = strlen(s);
      while((f_cc) && (ni < sl)) {	
        if(dkenc_utf82uc(&uw, (dk_ubyte *)(&(s[ni])),(sl-ni),&us)) {
	  ul++;
	  if((ni + us) > ni) {
	    ni += us;
	    if(ni >= sl) {
	      f_cc = 0;
	    }
	  } else {
	    f_cc = 0; ee = 1;
	  }
	} else {
	  f_cc = 0; ee = 1;
	}
      }
      if(ul) {	
        back = NULL;
        f_cc = 1;
        ul++;
	if(ul > dp->bufsz) {	
	  f_cc = 0;
	  nb = dk_new(char,ul);
	  if(nb) {
	    x = dp->buffer; dk_delete(x);
	    dp->buffer = nb; dp->bufsz = ul;
	    f_cc = 1;		
	  }
	}
	if(f_cc) {
	  ni = us = ns = ul = 0;
	  while((f_cc) && (ni < sl)) {
	    if(dkenc_utf82uc(&uw, (dk_ubyte *)(&(s[ni])),(sl-ni),&us)) {
	      if(uw < 256UL) {
	        uc = (unsigned char)uw;
		c = (char)uc;
	      } else {
	        c = '.';
	      }
	      if(ul < dp->bufsz) {
	        (dp->buffer)[ul] = c;
	      }
	      ul++;
	      if((ni + us) > ni) {
	        ni += us;
		if(ni >= sl) {
		  f_cc = 0;
		}
	      } else {
	        f_cc = 0; ee = 1;
	      }
	    } else {
	      f_cc = 0; ee = 1;
	    }
	  }
	  if(ul < dp->bufsz) {
	    (dp->buffer)[ul] = '\0';
	    back = dp->buffer;
	  } else {
	    (dp->buffer)[dp->bufsz - 1] = '\0';
	  }
	}
      }
    }
  }
  if(ee) { dp->f_error = 0x01; }
  }
  if(ee) {
    back = NULL;
  } 
  return back;
}



#if TEST_DECUTF8

int main(int argc, char *argv[]) {
  dk_utf8_decode_t	*dec = NULL;
  char buffer[1024], *ptr;
  
#line 178 "decutf8.ctr"

  
  dec = decutf8_new();
  if(dec) {		
    while(fgets(buffer, sizeof(buffer), stdin)) {
      ptr = decutf8_decode(dec, buffer);
      if(ptr) {		
        printf("%s", ptr);
      } else {		
      }
    }
    if(decutf8_get_error(dec)) {	
    }
    decutf8_delete(dec); dec = NULL;
  } else {		
  }
  
  
#line 195 "decutf8.ctr"

}

#endif

