#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include "dkfigw.h"
#include "dkstr.h"

MODULE = DKrause::FigWriter	PACKAGE = DKrause::FigWriter	PREFIX = fw_	


PROTOTYPES:	ENABLE



DKrause::FigWriter
fw_newInches(width, height)
		double width;
		double height;
	PREINIT:
		dk_fig_writer_t	*back = NULL;
	CODE:
		back = dkfigw_new();
		if(back) {
			dkfigw_set_image_size(back,FIG_WH_INCHES,width,height);
			dkfigw_set_suggested_arrow_settings(back);
			dkfigw_set_verbose(back, 1);
			RETVAL = back;
		} else {
			XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



DKrause::FigWriter
fw_newCm(width, height)
		double width;
		double height;
	PREINIT:
		dk_fig_writer_t	*back = NULL;
	CODE:
		back = dkfigw_new();
		if(back) {
			dkfigw_set_image_size(back, FIG_WH_CM, width, height);
			dkfigw_set_suggested_arrow_settings(back);
			dkfigw_set_verbose(back, 1);
			RETVAL = back;
		} else {
			XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



void
fw_DESTROY(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_delete(f);


int
fw_rectangle(f,x0,y0,x1,y1)
		DKrause::FigWriter f;
		double x0;
		double y0;
		double x1;
		double y1;
	CODE:
		RETVAL = 0;
		if(dkfigw_rectangle(f,x0,y0,x1,y1) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_arcBox(f,x0,y0,x1,y1,r)
		DKrause::FigWriter f;
		double x0;
		double y0;
		double x1;
		double y1;
		double r;
	CODE:
		RETVAL = 0;
		if(dkfigw_arc_box(f,x0,y0,x1,y1,r) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



int
fw_image(f,x0,y0,x1,y1,n)
		DKrause::FigWriter f;
		double x0;
		double y0;
		double x1;
		double y1;
		char *n;
	CODE:
		RETVAL = 0;
		if(dkfigw_image(f,x0,y0,x1,y1,n) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



int
fw_polygon(f)
		DKrause::FigWriter f;
	CODE:
		RETVAL = 0;
		if(dkfigw_polygon(f) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_polyline(f)
		DKrause::FigWriter f;
	CODE:
		RETVAL = 1;
		if(dkfigw_polyline(f) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



int
fw_point(f,x,y)
		DKrause::FigWriter f;
		double x;
		double y;
	CODE:
		RETVAL = 0;
		if(dkfigw_point(f,x,y) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_splineOpen(f)
		DKrause::FigWriter f;
	CODE:
		RETVAL = 0;
		if(dkfigw_open_spline(f) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



int
fw_splineClosed(f)
		DKrause::FigWriter f;
	CODE:
		RETVAL = 0;
		if(dkfigw_closed_spline(f) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_splinePoint(f,x,y,s)
		DKrause::FigWriter f;
		double x;
		double y;
		double s;
	CODE:
		RETVAL = 0;
		if(dkfigw_spline_point(f,x,y,s) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL





int
fw_arcOpen(f,x,y,r,a0,a1)
		DKrause::FigWriter f;
		double x;
		double y;
		double r;
		double a0;
		double a1;
	CODE:
		RETVAL = 0;
		if(dkfigw_open_arc(f,x,y,r,a0,a1) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_arcClosed(f,x,y,r,a0,a1)
		DKrause::FigWriter f;
		double x;
		double y;
		double r;
		double a0;
		double a1;
	CODE:
		RETVAL = 0;
		if(dkfigw_closed_arc(f,x,y,r,a0,a1) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_circle(f,x,y,r)
		DKrause::FigWriter f;
		double x;
		double y;
		double r;
	CODE:
		RETVAL = 0;
		if(dkfigw_circle(f,x,y,r) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_ellipse(f,x,y,rx,ry,ro)
		DKrause::FigWriter f;
		double x;
		double y;
		double rx;
		double ry;
		double ro;
	CODE:
		RETVAL = 0;
		if(dkfigw_ellipse(f,x,y,rx,ry,ro) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL




int
fw_text(f,x,y,t,a)
		DKrause::FigWriter f;
		double x;
		double y;
		char *t;
		double a;
	CODE:
		RETVAL = 0;
		if(dkfigw_text(f,x,y,t,a) > 0UL) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



void
fw_setTextAlignLeft(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_text_align(f, FIG_SUB_TEXT_LEFT);



void
fw_setTextAlignCentered(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_text_align(f, FIG_SUB_TEXT_CENTER);



void
fw_setTextAlignRight(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_text_align(f, FIG_SUB_TEXT_RIGHT);



void
fw_setTextFlagRigid(f,i)
		DKrause::FigWriter f;
		int i;
	CODE:
		dkfigw_set_text_rigid(f,i);




void
fw_setTextFlagSpecial(f,i);
		DKrause::FigWriter f;
		int i;
	CODE:
		dkfigw_set_text_special(f,i);



void
fw_setTextFontPs(f,n)
		DKrause::FigWriter f;
		int n;
	CODE:
		dkfigw_set_text_psfont(f, (unsigned char)n);



void
fw_setTextFontPsByName(f,n)
		DKrause::FigWriter f;
		char *n;
	CODE:
		dkfigw_set_text_psfont_by_name(f,n);


void
fw_setTextFontLatex(f,n)
		DKrause::FigWriter f;
		int n;
	CODE:
		dkfigw_set_text_latexfont(f, (unsigned char)n);



void
fw_setTextSize(f,s)
		DKrause::FigWriter f;
		double s;
	CODE:
		dkfigw_set_text_size(f,s);


void
fw_setLayer(f,l)
		DKrause::FigWriter f;
		unsigned short l;
	CODE:
		dkfigw_set_layer(f,l);




int
fw_layerUp(f)
		DKrause::FigWriter f;
	CODE:
		RETVAL = 0;
		if(dkfigw_layer_up(f)) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL



void
fw_setPenColor(f,c)
		DKrause::FigWriter f;
		short c;
	CODE:
		dkfigw_set_pen_color(f,c);



void
fw_setPenColorByName(f,c)
		DKrause::FigWriter f;
		char *c;
	CODE:
		dkfigw_set_pen_color_by_name(f, c);


void
fw_setFillColor(f,c)
		DKrause::FigWriter f;
		short c;
	CODE:
		dkfigw_set_fill_color(f,c);



void
fw_setFillColorByName(f,c)
		DKrause::FigWriter f;
		char *c;
	CODE:
		dkfigw_set_fill_color_by_name(f, c);

void
fw_setTransparentColor(f,c)
		DKrause::FigWriter f;
		short c;
	CODE:
		dkfigw_set_transparent_color(f,c);


int
fw_defineColor(f,r,g,b)
		DKrause::FigWriter f;
		int r;
		int g;
		int b;
	CODE:
		RETVAL = dkfigw_define_color(f,r,g,b);
	OUTPUT:
		RETVAL


void
fw_setFillNone(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, FIG_FILL_NONE);


void
fw_setFillBlack(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, FIG_FILL_BLACK);



void
fw_setFillSaturation(f,s)
		DKrause::FigWriter f;
		int s;
	PREINIT:
		int x;
	CODE:
		x = s / 5;
		if(x < 0) x = 0;
		if(x > 40) x = 40;
		dkfigw_set_fill_style(f, (unsigned char)x);




void
fw_setFillLeftDiagonal30(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)41);



void
fw_setFillRightDiagonal30(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)42);



void
fw_setFillCrosshatch30(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)43);



void
fw_setFillLeftDiagonal45(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)44);



void
fw_setFillRightDiagonal45(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)45);



void
fw_setFillCrosshatch45(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)46);



void
fw_setFillHorizontalBricks(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)47);



void
fw_setFillVerticalBricks(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)48);



void
fw_setFillHorizontalLines(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)49);



void
fw_setFillVerticalLines(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)50);



void
fw_setFillCrosshatch(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)51);



void
fw_setFillHorizontalShinglesRight(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)52);



void
fw_setFillHorizontalShinglesLeft(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)53);



void
fw_setFillVerticalShinglesA(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)54);



void
fw_setFillVerticalShinglesB(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)55);



void
fw_setFillFishScales(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)56);



void
fw_setFillSmallFishScales(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)57);



void
fw_setFillCircles(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)58);



void
fw_setFillHexagons(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)59);



void
fw_setFillOctagons(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)60);



void
fw_setFillHorizontalTireTreads(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)61);



void
fw_setFillVerticalTireTreads(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_fill_style(f, (unsigned char)62);



void
fw_setLineStyleSolid(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_SOLID);



void
fw_setLineStyleDashed(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_DASHED);



void
fw_setLineStyleDotted(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_DOTTED);



void
fw_setLineStyleDashDotted(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_DASH_DOTTED);



void
fw_setLineStyleDashDoubleDotted(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_DASH_DOUBLE_DOTTED);



void
fw_setLineStyleDashTripleDotted(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_style(f, FIG_LS_DASH_TRIPLE_DOTTED);


void
fw_setLineWidth(f,l)
		DKrause::FigWriter f;
		short l;
	CODE:
		dkfigw_set_line_width(f,l);


void
fw_setAngleDegree(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_angle_degree(f, 1);



void
fw_setAngleRadians(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_angle_degree(f, 0);




void
fw_setLineJoinMitered(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_join(f, FIG_LJ_MITER);


void
fw_setLineJoinRounded(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_join(f, FIG_LJ_ROUND);



void
fw_setLineJoinBeveled(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_join(f, FIG_LJ_BEVEL);




void
fw_setLineCapButted(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_cap(f, FIG_CS_BUTT);




void
fw_setLineCapRounded(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_cap(f, FIG_CS_ROUND);




void
fw_setLineCapProjecting(f)
		DKrause::FigWriter f;
	CODE:
		dkfigw_set_line_cap(f, FIG_CS_PROJECTING);



void
fw_setArrowheadForwardStick(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).fwa.sha = FIG_AS_STICK;


void
fw_setArrowheadForwardTriangle(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).fwa.sha = FIG_AS_TRIANGLE;


void
fw_setArrowheadForwardIndented(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).fwa.sha = FIG_AS_CLOSED_INDENTED;


void
fw_setArrowheadForwardPointed(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).fwa.sha = FIG_AS_CLOSED_POINTED;


void
fw_setArrowheadForwardFilled(f,i)
		DKrause::FigWriter f;
		int i;
	CODE:
		(f->sty).fwa.fil = (i ? 0x01 : 0x00);



void
fw_setArrowheadForwardWidthHeight(f,w,h)
		DKrause::FigWriter f;
		double w;
		double h;
	CODE:
		(f->sty).fwa.wid = w;
		(f->sty).fwa.hei = h;



void
fw_setArrowheadBackwardStick(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).bwa.sha = FIG_AS_STICK;


void
fw_setArrowheadBackwardTriangle(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).bwa.sha = FIG_AS_TRIANGLE;


void
fw_setArrowheadBackwardIndented(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).bwa.sha = FIG_AS_CLOSED_INDENTED;


void
fw_setArrowheadBackwardPointed(f)
		DKrause::FigWriter f;
	CODE:
		(f->sty).bwa.sha = FIG_AS_CLOSED_POINTED;


void
fw_setArrowheadBackwardFilled(f,i)
		DKrause::FigWriter f;
		int i;
	CODE:
		(f->sty).bwa.fil = (i ? 0x01 : 0x00);



void
fw_setArrowheadBackwardWidthHeight(f,w,h)
		DKrause::FigWriter f;
		double w;
		double h;
	CODE:
		(f->sty).bwa.wid = w;
		(f->sty).bwa.hei = h;


void
fw_setArrowheadDirections(f,i)
		DKrause::FigWriter f;
		int i;
	PREINIT:
		unsigned char c;
	CODE:
		c = 0x00;
		if(i & 1) c = c | 0x01;
		if(i & 2) c = c | 0x02;
		dkfigw_set_arrowheads(f,c);



void
fw_setUtf8(f,i)
		DKrause::FigWriter f;
		int i;
	CODE:
		dkfigw_set_utf8(f,i);



void
fw_setVerbose(f,i)
		DKrause::FigWriter f;
		int i;
	CODE:
		dkfigw_set_verbose(f,i);



int
fw_writeFile(f,n)
		DKrause::FigWriter f;
		char *n;
	CODE:
		RETVAL = 0;
		if(dkfigw_file(n, f)) {
			RETVAL = 1;
		}
	OUTPUT:
		RETVAL


int
fw_writeStream(f,s)
		DKrause::FigWriter f;
		DKrause::Stream s;
	PREINIT:
	CODE:
		RETVAL = 0;
		if(s) {
			if(s->s) {
				if(dkfigw_write(s->s, f)) {
					RETVAL = 1;
				}
			}
		}
	OUTPUT:
		RETVAL


