#! /bin/sh

# This script creates the distribution on the vendor's PC.



V='2.2.0'
C="DK tools and libraries $V"
rm -fr /home/krause/SW-DEV/projects/dktools-doc/doc/doxydoc

XV=`cat version.txt`
if [ "x$XV" != "x" ]
then
V="$XV"
fi

perl corver.pl $V

cd 
cd /home/krause/SW-DEV/projects/dktools

./create_perl_links.sh

echo Cleaning up share directory
cd /home/krause/SW-DEV/projects/dktools/share
find . -name '*.stt' -exec rm {} \;

echo Running tracecc
cd /home/krause/SW-DEV/projects/dktools
tracecc -r -l --/log/stderr/level=progress /home/krause/SW-DEV/projects/dktools
perl -w build_dkconf_c.pl

echo Creating man pages
cd pod
cd pod1
for i in *.pod
do
  echo pod1/$i
  j=`echo $i | sed -e 's/\.pod/.1/g'`
  pod2man --section="1" --release="$V" --center="$C" $i ../../man/man1/$j
done
cd ..
cd pod3
for i in *.pod
do
  echo pod3/$i
  j=`echo $i | sed -e 's/\.pod/.3/g'`
  pod2man --section="3" --release="$V" --center="$C" $i ../../man/man3/$j
done
cd ..
cd ..

echo Running autoconf
autoconf

echo Running doxygen
doxygen > ../doxygen.out 2>&1



cat - > dktools-version.h <<EOF

/**	@file	dktools-version.h	Project version number.
 */

#ifndef VERSNUMB
/**	Project version number.
*/
#define VERSNUMB "$V"
#endif

EOF
