/*
Copyright (c) 2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/


/** @file uachrs.c	The uachrs program. */



/**	Inside the uachrs module.
*/
#define UACHRS_C	1

#include "useraudi.h"




#line 51 "uachrs.ctr"




/**	Create response.
	This function reads lines for user name, challenge type,
	challenge data and password and write a response to the
	challenge.
*/
static
void
create_one_response DK_P0() {
  char un[USERAUD_LINESIZE];		/* User name. */
  char ct[USERAUD_LINESIZE];		/* Challenge type. */
  char ch[USERAUD_LINESIZE];		/* Challenge data. */
  char pw[USERAUD_LINESIZE];		/* Password. */
  char ol[USERAUD_LINESIZE];		/* Output line. */
  char *p1, *p2, *p3, *p4;
  
  p1 = p2 = p3 = p4 = NULL;
  if(fgets(un, sizeof(un), stdin)) {
    if(fgets(ct, sizeof(ct), stdin)) {
      if(fgets(ch, sizeof(ch), stdin)) {
        if(fgets(pw, sizeof(pw), stdin)) {
	  p1 = dkstr_start(un, NULL);
	  p2 = dkstr_start(ct, NULL);
	  p3 = dkstr_start(ch, NULL);
	  p4 = dkstr_start(pw, NULL);
	}
      }
    }
  } 
  if((p1) && (p2) && (p3) && (p4)) {
    dkstr_chomp(p1, NULL);
    dkstr_chomp(p2, NULL);
    dkstr_chomp(p3, NULL);
    dkstr_chomp(p4, NULL);
    if(uatcs_apply_challenge(NULL, ct, ch, pw, ol, sizeof(ol), 1)) {
      printf("%s\n", ol);
    }
  } 
}



/**	Supported algorithms.
*/
static char algorithms[] = {
"crypt"
#if DK_HAVE_OPENSSL_SHA_H && DK_HAVE_SHA512
",sha-512"
#endif
#if DK_HAVE_OPENSSL_SHA_H && DK_HAVE_SHA384
",sha-384"
#endif
#if DK_HAVE_OPENSSL_SHA_H && DK_HAVE_SHA256
",sha-256"
#endif
#if DK_HAVE_OPENSSL_SHA_H && DK_HAVE_SHA224
",sha-224"
#endif
#if DK_HAVE_OPENSSL_RIPEMD_H
",ripemd-160"
#endif
#if DK_HAVE_OPENSSL_SHA_H
",sha-1"
#endif
#if DK_HAVE_OPENSSL_MD5_H
",md5"
#endif
};


/**	Print the supported hashing algorithms.
*/
static
void
show_algorithms DK_P0() {
  printf("%s\n", algorithms);
}


/**	The well-known main function.
	@param	argc	Number of command line arguments
	@param	argv	Command line arguments array.
	@return	0 on success, any other value on error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  int what = 0;
  
#line 145 "uachrs.ctr"

  
  if(argc > 1) {
    if(strcmp(argv[1], "-a") == 0) {
      what = 1;
    }
  }
  switch(what) {
    case 1: {	/* Show algorithms. */
      show_algorithms();
    } break;
    default: {
      create_one_response();
    } break;
  } 
  
#line 160 "uachrs.ctr"

  exit(0); return 0;
}


