/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	yalcmsg.c	The yalcmsg module used by klpr and others.
*/



#include <dk.h>
#include <dktypes.h>
#include <dkapp.h>
#include <dkstt.h>
#include <dklogc.h>


/**	Inside the yalcmsg module.
*/
#define DK_YALCMSG_C 1

#include <yalcmsg.h>



/**	Message texts, filled by the string finder.
*/
static char *messages[101];



/**	String finder data.
*/
static dk_string_finder_t msg_find[] = {
  { "/e/001", &(messages[0]), "Configuration incomplete!" }, 
  { "/e/002", &(messages[1]), "Failed to complete request data!" },
  { "/e/003", &(messages[2]), "Server type information needed!" },
  { "/e/004", &(messages[3]), "Operation allowed on BSD/LPRng print servers only!" },
  { "/e/005", &(messages[4]), "Failed to obtain temporary file name!" },
  { "/e/006", &(messages[5]), "Failed to obtain directory for temporary files!" },
  { "/e/007", &(messages[6]), "No data to print!" },
  { "/e/008", &(messages[7]), "File name \"" },
  { "/e/009", &(messages[8]), "\" is too long!" },
  { "/e/010", &(messages[9]), "Failed to open filename expander for \"" },
  { "/e/011", &(messages[10]), "\"!" },
  { "/e/012", &(messages[11]), "Failed to read from file \"" },
  { "/e/013", &(messages[12]), "\"!" },
  { "/e/014", &(messages[13]), "Failed to write to file \"" },
  { "/e/015", &(messages[14]), "\"!" },
  { "/e/016", &(messages[15]), "Queue name \"" },
  { "/e/017", &(messages[16]), "\" is too long!" },
  { "/e/018", &(messages[17]), "No print data file!" },
  { "/e/019", &(messages[18]), "No control file!" },
  { "/e/020", &(messages[19]), "Failed to configure local network device!" },
  { "/e/021", &(messages[20]), "Failed to find host \"" },
  { "/e/022", &(messages[21]), "\"!" },
  { "/e/023", &(messages[22]), "Failed to connect to host \"" },
  { "/e/024", &(messages[23]), "\"!" },
  { "/e/025", &(messages[24]), "Send error!" },
  { "/e/026", &(messages[25]), "Receive error!" },
  { "/e/027", &(messages[26]), "Server does not accept jobs!" },
  { "/e/028", &(messages[27]), "Failed to obtain job id!" },
  { "/e/029", &(messages[28]), "Missing lpc command!" },
  { "/e/030", &(messages[29]), "Lpc command allowed for LPRng printers only!" },
  { "/e/031", &(messages[30]), "stat(" },
  { "/e/032", &(messages[31]), ") failed!" },
  { "/p/001", &(messages[32]), "Going to complete request data." },
  { "/p/002", &(messages[33]), "Request data completed." },
  { "/e/033", &(messages[34]), "Unknown lpc sub-command!" },
  { "/p/003", &(messages[35]), "Configuring local NIC." },
  { "/p/004", &(messages[36]), "Local NIC configured." },
  { "/p/005", &(messages[37]), "Looking up host \"" },
  { "/p/006", &(messages[38]), "\"." },
  { "/p/007", &(messages[39]), "Host \"" },
  { "/p/008", &(messages[40]), "\" found." },
  { "/p/009", &(messages[41]), "Connecting to \"" },
  { "/p/010", &(messages[42]), "\"." },
  { "/p/011", &(messages[43]), "Connected to \"" },
  { "/p/012", &(messages[44]), "\"." },
  { "/p/013", &(messages[45]), "Reading " },
  { "/p/014", &(messages[46]), " bytes from file \"" },
  { "/p/015", &(messages[47]), "\"." },
  { "/p/016", &(messages[48]), "" },
  { "/p/017", &(messages[49]), " bytes were read from \"" },
  { "/p/018", &(messages[50]), "\"." },
  { "/p/020", &(messages[51]), " bytes will be sent." },
  { "/p/021", &(messages[52]), " bytes were sent." },
  { "/p/022", &(messages[53]), " bytes will be received." },
  { "/p/023", &(messages[54]), " bytes were received." },
  { "/p/024", &(messages[55]), "Closing connection." },
  { "/p/025", &(messages[56]), "Connection closed." },
  { "/p/026", &(messages[57]), "Printing file \"" },
  { "/p/027", &(messages[58]), "\"." },
  { "/p/028", &(messages[59]), "File \"" },
  { "/p/029", &(messages[60]), "\" printed." },
  { "/e/034", &(messages[61]), "No sleep() function on this system!" },
  { "/e/035", &(messages[62]), "Wrong type \"" },
  { "/e/036", &(messages[63]), "\" (" },
  { "/e/037", &(messages[64]), ")!" },
  { "/e/038", &(messages[65]), "Wrong configuration keyword \"" },
  { "/e/039", &(messages[66]), "\" (" },
  { "/e/040", &(messages[67]), ")!" },
  { "/e/041", &(messages[68]), "Missing configuration keyword (" },
  { "/e/042", &(messages[69]), ")!" },
  { "/e/043", &(messages[70]), "Missing configuration value (" },
  { "/e/044", &(messages[71]), ")!" },
  { "/e/045", &(messages[72]), "No variable yet (" },
  { "/e/046", &(messages[73]), ")!" },
  { "/e/047", &(messages[74]), "No such SNMP type \"" },
  { "/e/048", &(messages[75]), "\"!" },
  { "/e/049", &(messages[76]), "Error while creating request PDU!" },
  { "/e/050", &(messages[77]), "Bad OID string \"" },
  { "/e/051", &(messages[78]), "\"!" },
  { "/e/052", &(messages[79]), "Error in SNMP response!" },
  { "/e/053", &(messages[80]), "No SNMP response!" },
  { "/p/030", &(messages[81]), "Reading configuration (start)" },
  { "/p/031", &(messages[82]), "Reading configuration (finished)" },
  { "/p/032", &(messages[83]), "Reading config section (start)" },
  { "/p/033", &(messages[84]), "Reading config section (finished)" },
  { "/p/034", &(messages[85]), "Starting SNMP request." },
  { "/p/035", &(messages[86]), "Finished SNMP request." },
  { "/e/054", &(messages[87]), "Failed to open SNMP session!" },
  { "/e/055", &(messages[88]), "Failed to open configuration file!" },
  { "/e/056", &(messages[89]), "No host specified for SNMP query!" },
  { "/e/057", &(messages[90]), "No SNMP device type specified!" },
  { "/e/058", &(messages[91]), "Failed to find host name!" },
  { "/e/059", &(messages[92]), "Host name \"" },
  { "/e/060", &(messages[93]), "\" too long!" },
  { "/e/061", &(messages[94]), "Failed to find user name!" },
  { "/e/062", &(messages[95]), "User name \"" },
  { "/e/063", &(messages[96]), "\" too long!" },
  { "/e/064", &(messages[97]), "Failed to open registry key \"HKLM\\" },
  { "/e/065", &(messages[98]), "\"!" },
  { "/e/066", &(messages[99]), "Failed to save current job id to registry!" },
  { "/e/067", &(messages[100]), "Failed to create SNMP request PDU!" },
  { NULL, NULL, NULL }
};



/**	Application.
*/
static dk_app_t *app = NULL;



/**	Flag: Module is configured.
*/
static int is_configured = 0;



void
ym_init DK_P1(dk_app_t *, a)
{
  if(a) app = a;
  if(app && (!is_configured)) {
    dkapp_find_multi(app, msg_find, "yanolc");
    is_configured = 1;
  }
}

void
yme_incomplete_configuration DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[0]), 1);
  }
}

void
ymp_going_to_complete_request DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[32]), 1);
  }
}

void
ymp_request_completed DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[33]), 1);
  }
}

void
yme_failed_to_complete_request DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[1]), 1);
  }
}

void yme_requires_type_rjlb DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[2]), 1);
  }
}

void
yme_requires_type_lb DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[3]), 1);
  }
}

void
yme_could_not_find_temp_filename DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[4]), 1);
  }
}

void
yme_could_not_find_temp_directory DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[5]), 1);
}

void
yme_no_data_to_print DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[6]), 1);
  }
}

void
yme_file_name_too_long DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[7];
    logmsg[1] = n;
    logmsg[2] = messages[8];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_failed_to_open_filename_expander  DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[9];
    logmsg[1] = n;
    logmsg[2] = messages[10];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_failed_to_write_to_file DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[13];
    logmsg[1] = n;
    logmsg[2] = messages[14];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_failed_to_read_from_file DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[11];
    logmsg[1] = n;
    logmsg[2] = messages[12];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_queue_name_too_long DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[15];
    logmsg[1] = n;
    logmsg[2] = messages[16];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_illegal_file_length DK_P2(dk_long_long_unsigned_t, d, dk_long_long_unsigned_t, c)
{
  if(is_configured) {
    if(!d) {
      dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[17]), 1);
    }
    if(!c) {
      dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[18]), 1);
    }
  }
}

void
yme_failed_to_find_local_network_address DK_P0()
{
  if(is_configured) {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[19]), 1);
  }
}

void
yme_failed_to_find_remote_host DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[20];
    logmsg[1] = n;
    logmsg[2] = messages[21];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_failed_to_establish_connection DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[22];
    logmsg[1] = n;
    logmsg[2] = messages[23];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
yme_error_while_sending DK_P0()
{
  if(is_configured) {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[24]), 1);
  }
}

void
yme_error_while_receiving DK_P0()
{
  if(is_configured) {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[25]), 1);
  }
}

void
yme_server_does_not_accept_jobs DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[26]), 1);
  }
}

void
yme_failed_to_find_job_number DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[27]), 1);
  }
}

void
yme_missing_command_in_lpc DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[28]), 1);
  }
}

void
yme_unknown_command_in_lpc DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[34]), 1);
  }
}

void
yme_lpc_for_lprng_only DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[29]), 1);
  }
}

void
yme_stat_failed_for_file DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[30];
    logmsg[1] = n;
    logmsg[2] = messages[31];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void
ymp_configure_local_nic DK_P0()
{
  if(is_configured) {
  dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, &(messages[35]), 1);
  }
}

void
ymp_local_nic_configured DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, &(messages[36]), 1);
  }
}

void
ymp_lookup_remote DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[37];
    logmsg[1] = n;
    logmsg[2] = messages[38];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 3);
  }
}

void
ymp_looked_up_remote  DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[39];
    logmsg[1] = n;
    logmsg[2] = messages[40];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 3);
  }
}

void
ymp_connect DK_P1(char *, n)
{
 char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[41];
    logmsg[1] = n;
    logmsg[2] = messages[42];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 3);
  }
}

void
ymp_connected DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[43];
    logmsg[1] = n;
    logmsg[2] = messages[44];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 3);
  }
}

void
ymp_try_read DK_P2(char *, n, unsigned long, num)
{
  char buffer[16], *logmsg[5];
  if(is_configured && n) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = messages[45];
    logmsg[1] = buffer;
    logmsg[2] = messages[46];
    logmsg[3] = n;
    logmsg[4] = messages[47];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 5);
  }
}

void ymp_have_read DK_P2(char *, n, unsigned long, num)
{
  char buffer[16], *logmsg[5];
  if(is_configured) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = messages[48];
    logmsg[1] = buffer;
    logmsg[2] = messages[49];
    logmsg[3] = n;
    logmsg[4] = messages[50];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 5);
  }
}

void ymp_try_send DK_P1(unsigned long, num)
{
  char buffer[16], *logmsg[2];
  if(is_configured) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = buffer;
    logmsg[1] = messages[51];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 2);
  }
}

void ymp_have_send DK_P1(unsigned long, num)
{
  char buffer[16], *logmsg[2];
  if(is_configured) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = buffer;
    logmsg[1] = messages[52];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 2);
  }
}

void ymp_try_receive DK_P1(unsigned long, num)
{
  char buffer[16], *logmsg[2];
  if(is_configured) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = buffer;
    logmsg[1] = messages[53];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 2);
  }
}

void ymp_have_received DK_P1(unsigned long, num)
{
  char buffer[16], *logmsg[2];
  if(is_configured) {
    sprintf(buffer, "%lu", num);
    logmsg[0] = buffer;
    logmsg[1] = messages[54];
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, logmsg, 2);
  }
}

void ymp_close_conn DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, &(messages[55]), 1);
  }
}

void ymp_have_closed_conn DK_P0()
{
  if(is_configured) {
    dkapp_log_msg(app, DK_LOG_LEVEL_DEBUG, &(messages[56]), 1);
  }
}

void ymp_print_one DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[57];
    logmsg[1] = n;
    logmsg[2] = messages[58];
    dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, logmsg, 3);
  }
}

void
yme_no_sleep DK_P0()
{
   dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[61]), 1);
}

void ymp_printed_one DK_P1(char *, n)
{
  char *logmsg[3];
  if(is_configured && n) {
    logmsg[0] = messages[59];
    logmsg[1] = n;
    logmsg[2] = messages[60];
    dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, logmsg, 3);
  }
}

void yme_snmp_bad_type DK_P2(char *,tn, unsigned long, ln)
{
  char buffer[32], *logmsg[5];
  if(tn) {
  sprintf(buffer, "%lu", ln);
  logmsg[0] = messages[62];
  logmsg[1] = tn;
  logmsg[2] = messages[63];
  logmsg[3] = buffer;
  logmsg[4] = messages[64];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 5);
  }
}

void yme_snmp_bad_conf DK_P2(char *,tn, unsigned long, ln)
{
  char buffer[32], *logmsg[5];
  if(tn) {
  sprintf(buffer, "%lu", ln);
  logmsg[0] = messages[65];
  logmsg[1] = tn;
  logmsg[2] = messages[66];
  logmsg[3] = buffer;
  logmsg[4] = messages[67];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 5);
  }
}

void yme_snmp_missing_key DK_P1(unsigned long,ln)
{
  char buffer[32], *logmsg[3];
  sprintf(buffer, "%lu", ln);
  logmsg[0] = messages[68];
  logmsg[1] = buffer;
  logmsg[2] = messages[69];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
}

void yme_snmp_missing_val DK_P1(unsigned long,ln)
{
  char buffer[32], *logmsg[3];
  sprintf(buffer, "%lu", ln);
  logmsg[0] = messages[70];
  logmsg[1] = buffer;
  logmsg[2] = messages[71];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
}

void yme_snmp_no_var DK_P1(unsigned long,ln)
{
  char buffer[32], *logmsg[3];
  sprintf(buffer, "%lu", ln);
  logmsg[0] = messages[72];
  logmsg[1] = buffer;
  logmsg[2] = messages[73];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
}

void yme_snmp_type_not_found DK_P1(char *,tn)
{
  char *logmsg[3];
  if(tn) {
  logmsg[0] = messages[74];
  logmsg[1] = tn;
  logmsg[2] = messages[75];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void yme_snmp_bad_oid_string DK_P1(char *,tn)
{
  char *logmsg[3];
  if(tn) {
  logmsg[0] = messages[77];
  logmsg[1] = tn;
  logmsg[2] = messages[78];
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, logmsg, 3);
  }
}

void yme_snmp_request_pdu DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[76]), 1);
}

void yme_snmp_response_packet DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[79]), 1);
}

void yme_snmp_no_response DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[80]), 1);
}

void ymp_snmp_start_config_file DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[81]), 1);
}

void ymp_snmp_end_config_file DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[82]), 1);
}

void ymp_snmp_start_config_section DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[83]), 1);
}

void ymp_snmp_end_config_section DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[84]), 1);
}

void ymp_snmp_start_request DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[85]), 1);
}

void ymp_snmp_end_request DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_PROGRESS, &(messages[86]), 1);
}

void yme_snmp_failed_to_open_session DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[87]), 1);
}

void yme_snmp_failed_to_open_configuration DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[88]), 1);
}

void yme_snmp_no_host DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[89]), 1);
}

void yme_snmp_no_type DK_P0()
{
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[90]), 1);
}

void yme_err_no_hostname DK_P0() {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[91]), 1); 
}

void yme_err_hostname_too_long DK_P1(char *,hn) {
  char *msg[3];
  if(hn) {
    msg[0] = messages[92];
    msg[1] = hn;
    msg[2] = messages[93];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, msg, 3);
  }
}

void yme_err_no_user_name DK_P0() {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[94]), 1);
}

void yme_err_username_too_long DK_P1(char *,hn) {
  char *msg[3];
  if(hn) {
    msg[0] = messages[95];
    msg[1] = hn;
    msg[2] = messages[96];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, msg, 3);
  }
}

void yme_err_save_jobid DK_P0() {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[99]), 1);
}

void yme_err_open_jobid_regkey DK_P1(char *,hn) {
  char *msg[3];
  if(hn) {
    msg[0] = messages[97];
    msg[1] = hn;
    msg[2] = messages[98];
    dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, msg, 3);
  }
}

void yme_err_snmp_request_pdu DK_P0() {
  dkapp_log_msg(app, DK_LOG_LEVEL_ERROR, &(messages[100]), 1);
}


