#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"


#include "dk.h"
#include "dksf.h"
#include "dksfc.h"
#include "dkmem.h"
#include "dkstr.h"
#include "dkstream.h"
#include "dkof.h"

static char str_file[] = { "p$lain" };
static char str_gzip[] = { "g$zip" };
static char str_bzip2[] = { "b$zip2" };
static char *array[] = { str_file, str_gzip, str_bzip2, NULL};
static char str_none[] = { "n$one" };
static char str_buffered[] = { "b$uffered" };
static char str_ascii85[] = { "ascii8$5" };
static char str_asciihex[] = { "asciih$ex" };
static char str_flate[] = { "f$late" };
static char str_run_length[] = { "r$un-length" };
static char str_lzw[] = { "lzw" };
static char *a2[] = {
	str_none,	str_buffered,	str_ascii85,
	str_asciihex,	str_flate,	str_run_length,
	str_lzw,
	NULL
};
static char nl[] = { "\n" };
static char crnl[] = { "\r\n" };

static
dk_stream_wrapper_t *
new_for_file(FILE *f)
{
  dk_stream_wrapper_t *back = NULL;
  back = dk_new(dk_stream_wrapper_t,1);
  if(back) {
    back->s = dkstream_for_file(f);
    if(back) {
      back->flags = DK_STREAM_FLAGS_STATE_USABLE;
    } else {
      dk_delete(back); back = NULL;
    }
  }
  return back;
}


MODULE = DKrause::Stream	PACKAGE = DKrause::Stream	PREFIX = s_


PROTOTYPES: ENABLE


DKrause::Stream
s_new(f,m,t="plain")
		char *f;
		char *m;
		char *t;
	PREINIT:
		dk_stream_wrapper_t *back = NULL;
		dk_stream_t *s = NULL;
		int file_type = 0;
		int reason = 0;
	CODE:
		RETVAL = NULL;
		if(f) {
		  if(m) {
		    if(t) {
		      file_type = dkstr_array_abbr(array, t, '$', 0);
		      if(file_type > -1) {
		        switch(file_type) {
			  case 2: {
			    s = dkstream_openbz2(f,m,0,&reason);
			  } break;
			  case 1: {
			    s = dkstream_opengz(f,m,0,&reason);
			  } break;
			  default: {
			    s = dkstream_openfile(f,m,0,&reason);
			  } break;
			}
			if(s) {
			  back = dk_new(dk_stream_wrapper_t,1);
			  if(back) {
			    back->s = s;
			    back->flags = DK_STREAM_FLAGS_STATE_USABLE;
			  } else {
			    dkstream_close(s); s = NULL;
			  }
			} else {
			  if(reason) {
			    if(reason & DK_SF_SEC_OWNER) {
			      /* ERROR: Symlink owner not target owner */
			    }
			    if(reason & DK_SF_SEC_WO) {
			      /* ERROR: Symlink in world writable dir */
			    }
			    if(reason & DK_SF_SEC_WG) {
			      /* ERROR: Symlink in group writable dir */
			    }
			    if(reason & DK_SF_SEC_DIR) {
			      /* ERROR: File name is a directory */
			    }
			  } else {
			    /* ERROR: Failed to open file */
			  }
			}
		      } else {
		        /* ERROR: Unknown compression type */
		      }
		    } else {
		      /* ERROR: No compression type */
		    }
		  } else {
		    /* ERROR: No open mode */
		  }
		} else {
		  /* ERROR: No file name */
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



DKrause::Stream
s_newStdout()
	PREINIT:
		dk_stream_wrapper_t *back;
	CODE:
		RETVAL = NULL;
		back = new_for_file(stdout);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



DKrause::Stream
s_newStderr()
	PREINIT:
		dk_stream_wrapper_t *back;
	CODE:
		RETVAL = NULL;
		back = new_for_file(stderr);
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



void
s_close(s)
		DKrause::Stream s;
	CODE:
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
		        dkstream_close(s->s);
		      } break;
		    }
		  }
		  s->s = NULL;
		  s->flags = DK_STREAM_FLAGS_STATE_CLOSED;
		}



void
s_DESTROY(s)
		DKrause::Stream s;
	CODE:
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
		        dkstream_close(s->s);
		      } break;
		    }
		  }
		  s->s = NULL;
		  s->flags = DK_STREAM_FLAGS_STATE_CLOSED;
		  dk_delete(s);
		}



int
s_puts(s,str)
		DKrause::Stream s;
		char *str;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_puts(s->s, str);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_putsDouble(s,d)
		DKrause::Stream s;
		double d;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_puts_double(s->s, d);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_putsLong(s,l)
		DKrause::Stream s;
		long l;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_puts_long(s->s, l);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_putsUnsignedLong(s,u)
		DKrause::Stream s;
		unsigned long u;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_puts_ul(s->s, u);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



char *
s_gets(s,sz=1024)
		DKrause::Stream s;
		size_t sz;
	PREINIT:
		char mybuffer[1024];
		char *back = NULL;
		char *bufptr = NULL;
	CODE:
		RETVAL = NULL;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
		        if(sz > sizeof(mybuffer)) {
		          bufptr = dk_new(char,sz);
		          if(bufptr) {
		            back=dkstream_gets(s->s, bufptr, sz);
		          } else {
		            back=dkstream_gets(
			      s->s, mybuffer, sizeof(mybuffer)
			    );
		          }
		        } else {
		          back=dkstream_gets(s->s, mybuffer, sizeof(mybuffer));
		        }
		      } break;
		    }
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
	CLEANUP:
		if(bufptr) {
		  dk_delete(bufptr);
		}




int
s_wbByte(s,w)
		DKrause::Stream s;
		unsigned char w;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_write(s->s, (char *)(&w), 1);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_wbWord(s,w)
		DKrause::Stream s;
		I16 w;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_wb_word(s->s, w);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_wbUword(s,u)
		DKrause::Stream s;
		U16 u;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_wb_uword(s->s, u);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_wbDword(s,dw)
		DKrause::Stream s;
		I32 dw;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_wb_dword(s->s, dw);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_wbUdword(s,ud)
		DKrause::Stream s;
		U32 ud;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_wb_udword(s->s, ud);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_wbString(s,str)
		DKrause::Stream s;
		char *str;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_wb_string(s->s, str);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



unsigned char
s_rbByte(s)
		DKrause::Stream s;
	PREINIT:
		unsigned char c;
		int ok = 0;
	CODE:
		RETVAL = 0x00;
		if(s) {
		}
		  if(s) {
		    if(s->s) {
		      switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		        case DK_STREAM_FLAGS_STATE_USABLE: {
			  ok = dkstream_read(s->s, (char *)(&c), 1);
			}
		      }
		    }
		  }
		if(ok) {
		  RETVAL = c;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



int
s_rbWord(s)
		DKrause::Stream s;
	PREINIT:
		dk_word i = 0;
		int ok = 0;
	CODE:
		RETVAL = 0;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			ok = dkstream_rb_word(s->s, &i);
		      } break;
		    }
		  }
		}
		if(ok) {
		  RETVAL = i;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL




unsigned int
s_rbUword(s)
		DKrause::Stream s;
	PREINIT:
		dk_uword w = 0;
		int ok = 0;
	CODE:
		RETVAL = 0U;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			ok = dkstream_rb_uword(s->s, &w);
		      } break;
		    }
		  }
		}
		if(ok) {
		  RETVAL = w;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



long
s_rbDword(s)
		DKrause::Stream s;
	PREINIT:
		dk_dword dw = 0;
		int ok = 0;
	CODE:
		RETVAL = 0L;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			ok = dkstream_rb_dword(s->s, &dw);
		      } break;
		    }
		  }
		}
		if(ok) {
		  RETVAL = dw;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



unsigned long
s_rbUdword(s)
		DKrause::Stream s;
	PREINIT:
		dk_udword ud = 0;
		int ok = 0;
	CODE:
		RETVAL = 0UL;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			ok = dkstream_rb_udword(s->s, &ud);
		      } break;
		    }
		  }
		}
		if(ok) {
		  RETVAL = ud;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



char *
s_rbString(s)
		DKrause::Stream s;
	PREINIT:
		char *back = NULL;
	CODE:
		RETVAL = NULL;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			back = dkstream_rb_string(s->s);
		      } break;
		    }
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}

	OUTPUT:
		RETVAL



unsigned long
s_getBytesWritten(s)
		DKrause::Stream s;
	CODE:
		RETVAL = 0UL;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			RETVAL = dkstream_get_bytes_written(s->s);
		      } break;
		    }
		  }
		}
	OUTPUT:
		RETVAL



DKrause::Stream
s_filter(s, ...)
		DKrause::Stream s;
	PREINIT:
		dk_stream_wrapper_t	*back = NULL;
		dk_stream_t		*newstream;
		size_t number_of_filters = 0;
		int f = 0;
		int error_found = 0;
		char *ptr;
		STRLEN lptr;
		int i;
	CODE:
		RETVAL = NULL;
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
	for(i = 1; i < items; i++) {
	  ptr = (char *)SvPV(ST(i), lptr);
	  if(ptr) {
	    if(lptr > 0) {
	      if(ptr[lptr] == '\0') {
	        f = dkstr_array_abbr(a2, ptr, '$', 0);
		if((f > -1) && (f != 6)) {
		  number_of_filters++;
		} else { error_found = 1; }
	      } else {
	        error_found = 1;
	      }
	    } else { error_found = 1; }
	  } else { error_found = 1; }
	}
	if(error_found == 0) {
	  newstream = dkof_open(s->s, number_of_filters);
	  if(newstream) {
	    for(i = 1; i < items; i++) {
	      ptr = (char *)SvPV(ST(i), lptr);
	      f = dkstr_array_abbr(a2, ptr, '$', 0);
	      switch(f) {
	        case 0: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_NONE)) {
		    error_found = 1;
		  }
		} break;
		case 1: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_BUFFERED)) {
		    error_found = 1;
		  }
		} break;
		case 2: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_ASCII85)) {
		    error_found = 1;
		  }
		} break;
		case 3: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_ASCIIHEX)) {
		    error_found = 1;
		  }
		} break;
		case 4: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_FLATE)) {
		    error_found = 1;
		  }
		} break;
		case 5: {
		  if(!dkof_set(newstream, (i-1), DK_OF_TYPE_PSRL)) {
		    error_found = 1;
		  }
		} break;
	      }
	    }
	    if(error_found) {
	      dkof_close(newstream); newstream = NULL;
	    }
	    if(newstream) {
	      back = dk_new(dk_stream_wrapper_t,1);
	      if(back) {
	        back->s = newstream;
		back->flags = DK_STREAM_FLAGS_STATE_USABLE
		            | DK_STREAM_FLAGS_FILTER;
	      } else {
	        dkof_close(newstream); newstream = NULL;
	      }
	    }
	  }
	}
		      } break;
		    }
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



int
s_startChunk(s)
		DKrause::Stream	s;
	CODE:
		RETVAL = 0;
		if(s) {
		  if((s->flags) & DK_STREAM_FLAGS_FILTER) {
		    if(s->s) {
		      switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		        case DK_STREAM_FLAGS_STATE_USABLE: {
			  RETVAL = dkof_start_chunk(s->s);
			} break;
		      }
		    }
		  }
		}
	OUTPUT:
		RETVAL



int
s_endChunk(s)
		DKrause::Stream	s;
	CODE:
		RETVAL = 0;
		if(s) {
		  if((s->flags) & DK_STREAM_FLAGS_FILTER) {
		    if(s->s) {
		      switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		        case DK_STREAM_FLAGS_STATE_USABLE: {
			  RETVAL = dkof_end_chunk(s->s);
			} break;
		      }
		    }
		  }
		}
	OUTPUT:
		RETVAL



void
s_setCrNl(s,v)
		DKrause::Stream s;
		int v;
	CODE:
		if(s) {
		  if((s->flags) & DK_STREAM_FLAGS_FILTER) {
		    if(s->s) {
		      switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		        case DK_STREAM_FLAGS_STATE_USABLE: {
			  dkof_set_crnl(s->s, v);
			} break;
		      }
		    }
		  }
		}



void
s_setFinalizing(s,v)
		DKrause::Stream s;
		int v;
	CODE:
		if(s) {
		  if((s->flags) & DK_STREAM_FLAGS_FILTER) {
		    if(s->s) {
		      switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		        case DK_STREAM_FLAGS_STATE_USABLE: {
			  dkof_set_finalizing(s->s, v);
			} break;
		      }
		    }
		  }
		}



void
s_nl(s)
		DKrause::Stream s;
	CODE:
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			dkstream_puts(s->s, nl);
		      } break;
		    }
		  }
		}



void
s_crnl(s)
		DKrause::Stream s;
	CODE:
		if(s) {
		  if(s->s) {
		    switch((s->flags) & DK_STREAM_FLAGS_STATE_MASK) {
		      case DK_STREAM_FLAGS_STATE_USABLE: {
			dkstream_puts(s->s, crnl);
		      } break;
		    }
		  }
		}
