/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	b2str.c
	Log message strings used by bmeps.
*/



/** Inside the b2str.c module. */
#define B2STR_C		1
#include "bmepsi.h"




#line 52 "b2str.ctr"




/**	Log messages used by bmeps.
*/
char *bmeps_str[] = {
/*   0 */ "Current configuration",
/*   1 */ "Output language definition:",
/*   2 */ "Run conversion only if necessary:",
/*   3 */ "on",
/*   4 */ "off",
/*   5 */ "Output driver:",
/*   6 */ "PS level:",
/*   7 */ "PDF level:",
/*   8 */ "Color output:",
/*   9 */ "Encodings:",
/*  10 */ "Separated data streams for R/G/B:",
/*  11 */ "Use alpha channel to mix against a background:",
/*  12 */ "Ignore background color information from file:",
/*  13 */ "Convert alpha channel data into an image mask:",
/*  14 */ "Image mask trigger level [0.0...1.0]:",
/*  15 */ "Use resolution information from file:",
/*  16 */ "Use showpage operator:",
/*  17 */ "Use dictionary for definitions:",
/*  18 */ "Use vmreclaim operator:",
/*  19 */ "Use dictionary for image operator:",
/*  20 */ "Transfer alpha channel to PDF output:",
/*  21 */ "Paper size:",
/*  22 */ "Image interpolation:",
/*  23 */ "Draft mode:",
/*  24 */ "Detailed settings",
/*  25 */ "Default background for mixing:",
/*  26 */ "",
/*  27 */ "PANIC: ",
/*  28 */ "FATAL ERROR: ",
/*  29 */ "ERROR: ",
/*  30 */ "Warning: ",
/*  31 */ "",
/*  32 */ "Not enough memory (RAM/swap space)!",
/*  33 */ "No input file type specified!",
/*  34 */ "Failed to read temporary file \"",
/*  35 */ "\"!",
/*  36 */ "Failed to read input file \"",
/*  37 */ "\"!",
/*  38 */ "Failed to write output file \"",
/*  39 */ "\"!",
/*  40 */ "Failed to create file name expander!",
/*  41 */ "Failed to obtain unique file name for input file \"",
/*  42 */ "\"!",
/*  43 */ "Failed to obtain unique file name for output file \"",
/*  44 */ "\"!",
/*  45 */ "Input file name \"",
/*  46 */ "\" is too long (summary of directory and file name)!",
/*  47 */ "Output file name \"",
/*  48 */ "\" is too long (summary of directory and file name)!",
/*  49 */ "Multiple output language definitions!",
/*  50 */ "Option \"",
/*  51 */ "\" unknown!",
/*  52 */ "Too many file names!",
/*  53 */ "Write error in file transfer!",
/*  54 */ "Failed to open directory \"",
/*  55 */ "\"!",
/*  56 */ "Failed to get name of directory entry!",
/*  57 */ "Failed to read image header from file \"",
/*  58 */ "\"!",
/*  59 */ "Failed to create output stream!",
/*  60 */ "Failed to read image data from file \"",
/*  61 */ "\"!",
/*  62 */ "Failed to read file \"",
/*  63 */ "\"!",
/*  64 */ "Failed to obtain file size for \"",
/*  65 */ "\"!",
/*  66 */ "Failed to write temporary file \"",
/*  67 */ "\"!",
/*  68 */ "Failed to start encoded/compressed output!",
/*  69 */ "Failed to finish encoded/compressed output!",
/*  70 */ "Failed to set up encoding/compression!",
/*  71 */ "Frame not found!",
/*  72 */ "Mathematical problem, failed to calculate draft dimensions!",
/*  73 */ "Syntax error near \"",
/*  74 */ "\"!",
/*  75 */ "Configuration \"",
/*  76 */ "\" not found!",
/*  77 */ "No language specified, using default \"ps2\".",
/*  78 */ "LZW compression is not available!",
/*  79 */ "Writing output file \"",
/*  80 */ "\".",
/*  81 */ "Neither configuration name nor output file name specified!",
/*  82 */ "Missing configuration name, output file name does not have a suffix!",
/*  83 */ "No configuration found for file name suffix \"",
/*  84 */ "\"!",
/*  85 */ "Configuration \"",
/*  86 */ "\" is used.",
/*  87 */ "Home directory name \"",
/*  88 */ "\" too long!",
/*  89 */ "Home directory not found!",
/*  90 */ "Unknown configuration entry \"",
/*  91 */ "\" ignored.",
/*  92 */ "File \"",
/*  93 */ "\" exists.\nThis file hides the configuration file \"",
/*  94 */ "\".",
/*  95 */ "At least one alpha channel was converted to PDF.",
/*  96 */ "Suppress information about transferred alpha channel(s):",
/*  97 */ "Processing file \"",
/*  98 */ "\".",
/*  99 */ "Illegal predictor: \"",
/* 100 */ "\"!\n\tAllowed values:\n\t",
/* 101 */
"\"none\", \"tiff\", \"png-sub\", \"png-up\", \"png-average\", \"png-paeth\"."
};

/** Number of log messages in the array.
*/
static size_t sz_bmeps_str = sizeof(bmeps_str)/sizeof(PCHAR);



/**	Retrieve one string.
	@param	s	String number.
	@return	Valid pointer on success, NULL on error.
*/
char *
bmeps_str_get DK_P1(size_t,s)
{
  char *back = NULL;
  if(s < sz_bmeps_str) {
    back = bmeps_str[s];
  }
  return back;
}



/**	Return pointer to array of strings used by bmeps.
	@return	Array pointer.
*/
char **
bmeps_str_base DK_P0()
{
  return bmeps_str;
}



/**	Get maximum string index.
	@return	Maximum index.
*/
size_t
bmeps_get_num DK_P0()
{
  
  return sz_bmeps_str;
}



