
/* USAGE INSTRUCTIONS
 *
 * 1. Add the contents of this file to mib.c at the top level
 *    (outside of any function) before the function
 *    char *netsnmp_get_mib_directory(void)
 * 2. In netsnmp_get_mib_directory() replace the line
 *
 *       dir = getenv("MIBDIRS");
 *
 *    by the new text:
 *
 *       dir = getenv("MIBDIRS");
 *       if(dir == NULL) {
 *	   dir = try_getting_from_registry();
 *	 }
 *
 */




static char mibdir_buffer[512];

/*
 * function : try_getting_from_registry
 *
 *            - This function returns a string of the directories
 *              from which the MIB modules will be searched or
 *              loaded.
 *              This directory is searched for in the registry keys
 *              HKCU\Software\Net-Snmp and HKLM\Software\Net-Snmp
 *              the value name is MibDirs
 */

static char duk[] = { "SOFTWARE\\Net-Snmp" };
static char valname[] = { "MibDirs" };

char *
try_getting_from_registry(void)
{
  char *back = NULL, *ptr;
  HKEY   rk;
  LONG   res;
  DWORD  tp;
  size_t sz;
  if(!back) {
    sz = sizeof(mibdir_buffer) - 1; tp = REG_SZ;
    res = RegOpenKeyExA(HKEY_CURRENT_USER,duk,0UL,KEY_QUERY_VALUE,&rk);
    if(res == ERROR_SUCCESS) {
      res = RegQueryValueExA(rk,valname,NULL,&tp,mibdir_buffer,&sz);
      if(res == ERROR_SUCCESS) {
        if(tp == REG_SZ) {
	  back = mibdir_buffer;
	  mibdir_buffer[sizeof(mibdir_buffer)-1] = '\0';
	  if(sz < sizeof(mibdir_buffer)) {
	    mibdir_buffer[sz] = '\0';
	  }
	}
      }
      RegCloseKey(rk);
    }
  }
  if(!back) {
    sz = sizeof(mibdir_buffer) - 1; tp = REG_SZ;
    res = RegOpenKeyExA(HKEY_LOCAL_MACHINE,duk,0UL,KEY_QUERY_VALUE,&rk);
    if(res == ERROR_SUCCESS) {
      res = RegQueryValueExA(rk,valname,NULL,&tp,mibdir_buffer,&sz);
      if(res == ERROR_SUCCESS) {
        if(tp == REG_SZ) {
	  back = mibdir_buffer;
	  mibdir_buffer[sizeof(mibdir_buffer)-1] = '\0';
	  if(sz < sizeof(mibdir_buffer)) {
	    mibdir_buffer[sz] = '\0';
	  }
	}
      }
      RegCloseKey(rk);
    }
  }
  if(back) {
    ptr = back;
    while(*ptr) {
      if(*ptr == '\\') { *ptr = '/'; }
      ptr++;
    }
  }
  return back;
}

