/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	dkproto.h
	Define DK_Px macros.

	Define DK_Px macros to use either prototypes or
	K+R style function declarations.

	The DK_HAVE_PROTOTYPES constant is used to choose prototypes
	or K+R style declarations.
*/

#ifndef DKPROTO_INC

/** Make sure to include the file only once. */
#define DKPROTO_INC 1

#ifndef DKCONFIG_INC
#include <dkconfig.h>
#endif

#if DK_HAVE_PROTOTYPES

/** Prototype for functions in headers. */
#define DK_PR(arg)	arg

/** Prototype for functions using no arguments. */
#define DK_P0()		(void)

/** Prototype for functions using 1 argument. */
#define DK_P1(a,b)	(a b)

/** Prototype for functions using 2 arguments. */
#define DK_P2(a,b,c,d)	(a b, c d)

/** Prototype for functions using 3 arguments. */
#define DK_P3(a,b,c,d,e,f) (a b, c d, e f)

/** Prototype for functions using 4 arguments. */
#define DK_P4(a,b,c,d,e,f,g,h) (a b, c d, e f, g h)

/** Prototype for functions using 5 arguments. */
#define DK_P5(a,b,c,d,e,f,g,h,i,j) (a b, c d, e f, g h, i j)

/** Prototype for functions using 6 arguments. */
#define DK_P6(a,b,c,d,e,f,g,h,i,j,k,l) (a b, c d, e f, g h, i j, k l)

/** Prototype for functions using 7 arguments. */
#define DK_P7(a,b,c,d,e,f,g,h,i,j,k,l,m,n) (a b, c d, e f, g h, i j, k l, m n)

/** Prototype for functions using 8 arguments. */
#define DK_P8(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) (a b, c d, e f, g h, i j, k l, m n, o p)

/** Prototype for functions using 9 arguments. */
#define DK_P9(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) (a b, c d, e f, g h, i j, k l, m n, o p, q r)

/** Prototype for functions using 10 arguments. */
#define DK_P10(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) (a b, c d, e f, g h, i j, k l, m n, o p, q r, s t)

/** Prototype for functions using 11 arguments. */
#define DK_P11(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v) (a b, c d, e f, g h, i j, k l, m n, o p, q r, s t, u v)

/** Prototype for functions using 12 arguments. */
#define DK_P12(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x) (a b, c d, e f, g h, i j, k l, m n, o p, q r, s t, u v, w x)

/** Prototype for functions using 13 arguments. */
#define DK_P13(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z) (a b, c d, e f, g h, i j, k l, m n, o p, q r, s t, u v, w x, y z)
#else
#define DK_PR(arg)	()
#define DK_P0()		()
#define DK_P1(a,b)	(b) a b;
#define DK_P2(a,b,c,d)	(b,d) a b; c d;
#define DK_P3(a,b,c,d,e,f) (b,d,f) a b; c d; e f;
#define DK_P4(a,b,c,d,e,f,g,h) (b,d,f,h) a b; c d; e f; g h;
#define DK_P5(a,b,c,d,e,f,g,h,i,j) (b,d,f,h,j) a b; c d; e f; g h; i j;
#define DK_P6(a,b,c,d,e,f,g,h,i,j,k,l) (b,d,f,h,j,l) a b; c d; e f; g h; i j; k l;
#define DK_P7(a,b,c,d,e,f,g,h,i,j,k,l,m,n) (b,d,f,h,j,l) a b; c d; e f; g h; i j; k l; m n;
#define DK_P8(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) (b,d,f,h,j,l,n,p) a b; c d; e f; g h; i j; k l; m n; o p;
#define DK_P9(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) (b,d,f,h,j,l,n,p,r) a b; c d; e f; g h; i j; k l; m n; o p; q r;
#define DK_P10(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) (b,d,f,h,j,l,n,p,r,t) a b; c d; e f; g h; i j; k l; m n; o p; q r; s t;
#define DK_P11(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v) (b,d,f,h,j,l,n,p,r,t,v) a b; c d; e f; g h; i j; k l; m n; o p; q r; s t; u v;
#define DK_P12(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x) (b,d,f,h,j,l,n,p,r,t,v,x) a b; c d; e f; g h; i j; k l; m n; o p; q r; s t; u v; w x;
#define DK_P13(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z) (b,d,f,h,j,l,n,p,r,t,v,x,z) a b; c d; e f; g h; i j; k l; m n; o p; q r; s t; u v; w x; y z;
#endif

#if DK_HAVE_PROTOTYPES
#define DK_EXT /* nix */
#else
#define DK_EXT extern
#endif

#endif

