/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file dkrandc.h Constants for allowed PRNG types
	and error codes.
*/
#ifndef DKRANDC_INC
#define DKRANDC_INC	1

/** Seeding from file is allowed. */
#define DK_RAND_ALLOW_SEED_FILE		1

/** No PRNG type found (yet). */
#define DK_RAND_TYPE_NONE		0

/** PRNG: OpenSSL. */
#define DK_RAND_TYPE_OPENSSL		2

/** PRNG: state(). */
#define DK_RAND_TYPE_STATE		4

/** PRNG: rand48(). */
#define DK_RAND_TYPE_RAND48		8

/** PRNG: rand(). */
#define DK_RAND_TYPE_SIMPLE		16

/** Number of seed bytes to save for OpenSSL PRNG. */
#define DK_RAND_OSSL_PRNG_SEED_BYTES	1024

/** All PRNG types. */
#define DK_RAND_TYPE_ALL (\
DK_RAND_TYPE_OPENSSL \
| DK_RAND_TYPE_STATE \
| DK_RAND_TYPE_RAND48 \
| DK_RAND_TYPE_SIMPLE \
)

/** PRNGs to use for cryptographic purposes. */
#define DK_RAND_TYPE_CRYPTO	(DK_RAND_TYPE_OPENSSL)

/** Information: No error occured. */
#define DK_RAND_ERR_NONE			0x00000000UL

/** ERROR: No usable PRNG found. */
#define DK_RAND_ERR_NO_PRNG			0x00000001UL

/** ERROR: Only predictable PRNGs available. */
#define DK_RAND_ERR_UNSECURE_PRNG		0x00000002UL

/** ERROR: No seed source found. */
#define DK_RAND_ERR_NO_SEED			0x00000004UL

/** ERROR: Invalid arguments. */
#define DK_RAND_ERR_INVALID_ARGS		0x00000008UL

/** ERROR: No support for OpenSSL. */
#define DK_RAND_ERR_OPENSSL_NOT_SUPPORTED	0x00000010UL

/** ERROR: Not enough memory. */
#define DK_RAND_ERR_NO_MEMORY			0x00000020UL

#endif

