/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file dksfc.h
	Constants for the dksf module.
*/

#ifndef DK_SFC_INC

/** Make sure to include the file only once. */
#define DK_SFC_INC 1

/** File type: Regular file. */
#define	DK_FT_REG 1

/** File type: Directory. */
#define DK_FT_DIR 2

/** File type: FIFO. */
#define DK_FT_FIFO 3

/** File type: Character device. */
#define DK_FT_CHR 4

/** File type: Block device. */
#define DK_FT_BLK 5

/** File type: Socket. */
#define DK_FT_SOCKET 6

/** File type: File type is unknown. */
#define DK_FT_OTHER 7

/** File type: file is a symbolic link. */
#define DK_FT_SYMLINK 16

/** Permissions: set user ID. */
#define DK_PERM_SUID      04000

/** Permissions: set group ID. */
#define DK_PERM_SGID      02000

/** Permissions: sticky bit (keep in memory after execution). */
#define DK_PERM_VTX       01000

/** Permissions: owner can read. */
#define DK_PERM_U_READ    00400

/** Permissions: owner can write. */
#define DK_PERM_U_WRITE   00200

/** Permissions: owner can execute. */
#define DK_PERM_U_EXECUTE 00100

/** Permissions: group can read. */
#define DK_PERM_G_READ    00040

/** Permissions: group can write. */
#define DK_PERM_G_WRITE   00020

/** Permissions: group can execute. */
#define DK_PERM_G_EXECUTE 00010

/** Permissions: others can read. */
#define DK_PERM_O_READ	  00004

/** Permissions: others can write. */
#define DK_PERM_O_WRITE	  00002

/** Permissions: others can execute. */
#define DK_PERM_O_EXECUTE 00001

/** Permissions to create a file accessable by owner only. */
#define DK_PERM_CREATE_PROTECTED 0700

/** Default permissions when creating a new directory. */
#define DK_PERM_CREATE_DIR  00755

/** Default permissions when creating a new file. */
#define DK_PERM_CREATE_FILE 00700

#endif

