/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	dksignal.c	Signal handling module.
*/



#include "dk.h"
#include "dktypes.h"
#define DK_SIGNAL_C
#include "dksignal.h"

#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_STDDEF_H
#include <stddef.h>
#endif
#if DK_HAVE_SIGNAL_H
#include <signal.h>
#endif



dk_signal_disp_t
dksignal_set DK_P2(int, signo, dk_signal_disp_t, disp)
{
  dk_signal_disp_t back = NULL;
#if DK_HAVE_SIGACTION
  struct sigaction act, oact;
  back = (dk_signal_disp_t)SIG_ERR;
  act.sa_handler =
#ifdef __cplusplus
  (dk_extc_signal_disp_t)disp;
#else
  disp;
#endif
  sigemptyset(&act.sa_mask);
  act.sa_flags = 0;
#if !DK_NO_SIGNAL_RESTART_ALARM
  if(signo == SIGALRM) {
#ifdef SA_INTERRUPT
  act.sa_flags |= SA_INTERRUPT;
#else
#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART;
#endif
#endif
  }
#endif
  if(sigaction(signo, &act, &oact) < 0) {
    back = (dk_signal_disp_t)SIG_ERR;
  } else {
    back = (dk_signal_disp_t)oact.sa_handler;
  }
#else
#if DK_HAVE_SIGSET
  back = (dk_signal_disp_t)sigset(signo,disp);
#else
#if DK_HAVE_SIGNAL
  back = (dk_signal_disp_t)signal(signo,disp);
#endif
#endif
#endif
  return back;
}



int
dksignal_available DK_P0()
{
#if DK_HAVE_SIGACTION
  return DK_SIGNAL_SIGACTION;
#else
#if DK_HAVE_SIGSET
  return DK_SIGNAL_SIGSET;
#else
#if DK_HAVE_SIGNAL
  return DK_SIGNAL_SIGNAL;
#else
  return DK_SIGNAL_NONE;
#endif
#endif
#endif
}


