/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	filtmsql.h	Include file for filtmsql.
*/

#ifndef FILTMSQL_H_INCLUDED
#define FILTMSQL_H_INCLUDED 1


#include <stdio.h>

#include <dk.h>

#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if DK_HAVE_UNISTD_H
#include <unistd.h>
#endif
#if DK_HAVE_PROCESS_H
#include <process.h>
#endif


#include <dkmem.h>
#include <dkstr.h>
#include <dksf.h>
#include <dklogc.h>
#include <dkapp.h>


/**	Filter job.
*/
typedef struct {
  dk_app_t	*a;	/**< Application structure. */
  int		cmd;	/**< Command to execute, FILTMSQL_CMD_xxx. */
  int		exval;	/**< Exit status code. */
  char		*ifn1;	/**< Input file name from argv. */
  char		*ofn1;	/**< Output file name. */
  char		*ifn2;	/**< Input file name after expansion. */
  char		*ofn2;	/**< Output file name. */
  char		*ib;	/**< Input buffer. */
  char		*ob;	/**< Output buffer. */
  size_t	sz_ib;	/**< Size of input buffer. */
  size_t	sz_ob;	/**< Size of output buffer. */
  size_t	us_ob;	/**< Used bytes in output buffer. */
  FILE		*inf;	/**< Input file. */
  FILE		*outf;	/**< Output file. */
  char		**msg;	/**< Message texts. */
} FJ;

/**	Command: Run normally. */
#define FILTMSQL_CMD_NORMAL	0

/**	Command: Show version only. */
#define FILTMSQL_CMD_VERSION	1

/**	Command: Show help text. */
#define FILTMSQL_CMD_HELP	2

#endif

