package hatext;

sub new
{
  my $class = shift;
  my $self = {
    'de'	=>	0
  };
  if($#_ > -1) {
    my $lang = shift;
    if($lang =~ /^\s*[Dd][Ee]([Uu]([Tt]([Ss]([Cc][Hh]?)?)?)?)?/o) {
      $self->{'de'} = 1;
    }
  }
  bless($self, $class);
  return $self;
}

my @stringsen = (
"Hosts",			#  0
"Netgroups",			#  1
"Overview",			#  2
"System user:",			#  3
"unknown",			#  4
"Purpose:",			#  5
"Location:",			#  6
"Inventory no.:",		#  7
"Serial no.:",			#  8
"Host ID:",			#  9
"Network",			# 10
"IP address:",			# 11
"MAC address:",			# 12
"Network patch:",		# 13
"DHCP class:",			# 14
"DHCP group:",			# 15
"Expiration date:",		# 16
"DNS domain:",			# 17
"Netgroups",			# 18
"Parent groups",		# 19
"Subgroups (member groups)",	# 20
"Member hosts",			# 21
"Other hosts",			# 22
"Sorted by user and computer",	# 23
"Sorted by date",		# 24
"Available licenses",		# 25
"Available",			# 26
"The licenses listed were already bought but not yet assigned\n" .
"to a user or computer.\n",	# 27
"Assignement to computer unknown",	# 28
"Not assigned to a computer",		# 29
"Sorted by manufacturer and product",	# 30
"Manufacturer/Product",			# 31
"Used on other users computers",	# 32
"\nis the owner of the licenses listed in this section, but the software" .
"using these licenses is installed on other user's computers.",	# 33
"Other computers",			# 34
"Alias:",				# 35
);

my @stringsde = (
"Hosts",			#  0
"Netgroups",			#  1
"bersicht",			#  2
"Systemverantwortlicher:",	#  3
"nicht bekannt",		#  4
"Verwendungszweck:",		#  5
"Ort:",				#  6
"Inventarnummer:",		#  7
"Seriennummer:",		#  8
"Host-ID:",			#  9
"Netzwerk",			# 10
"IP-Adresse:",			# 11
"MAC-Adresse:",			# 12
"Datendose:",			# 13
"DHCP-Klasse:",			# 14
"DHCP-Gruppe:",			# 15
"Ablaufdatum:",			# 16
"DNS-Domne:",			# 17
"Netzgruppen",			# 18
"bergeordnete Gruppen",	# 19
"Untergruppen (Mitglieder-Gruppen)",	# 20
"Mitglieder-Hosts",		# 21
"Sonstige Hosts",		# 22
"Sortiert nach Nutzer und PC",	# 23
"In Reihenfolge des Erwerbs",	# 24
"Lizenzbestand (noch verfgbar)",	#25
"Bestand",			# 26
"Die hier aufgefhrten Lizenzen wurden bereits erworben,\n" .
"aber noch keinem Nutzer bzw. PC zur Nutzung zugewiesen.\n",	# 27
"Zuordnung zu Computer nicht bekannt",				# 28
"Keinem PC zugeordnet",						# 29
"Sortiert nach Hersteller und Produkt",				# 30
"Hersteller/Produkt",						# 31
"Auf PCs anderer Nutzer installiert",				# 32
"\nist Inhaber der hier aufgefhrten Lizenzen, hat diese jedoch\n" .
"anderen Nutzern zur Verfgung gestellt.",			# 33
"Weitere Computer",						# 34
"Alias:",							# 35
);

my @lpreen = (
"\\documentclass[12pt,a4paper,titlepage]{article}",
"\\usepackage{lscape}",
"\\usepackage{ifpdf}",
"\\usepackage[latin1]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{array}",
"\\usepackage{enumerate}",
"\\usepackage{longtable}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\usepackage{makeidx}",
"\\makeindex",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"  pdftex,",
"  a4paper=true,",
"  pdftitle={The Network Documentation},",
"  pdfsubject={network documentation},",
"  pdfauthor={The Network Administrator},",
"  pdfcreator={http://dktools.sourceforge.net/hostsadm.html},",
"  colorlinks=true,",
"  linkcolor=black,",
"  pdfpagemode=UseNone,",
"  pdfstartview={XYZ 0 835 1.25},",
"  bookmarksnumbered",
"]{hyperref}",
"\\else",
"\\usepackage[",
"  dvips,",
"  colorlinks=true,",
"  linkcolor=black",
"]{hyperref}",
"\\fi",
"\\parindent0cm",
"\\author{The Network Administrator}",
"\\title{The Network Documentation}",
"\\setcounter{secnumdepth}{1}",
"\\begin{document}",
"\% \\ifpdf\\pdfbookmark[2]{\\contentsname}{toc}\\fi",
"\\maketitle",
"\\cleardoublepage",
"\% \\ifpdf\\pdfbookmark[1]{\\contentsname}{tocanc}\\fi",
"\\tableofcontents",
"\\cleardoublepage"
);

my @lprede = (
"\\documentclass[12pt,a4paper,titlepage]{scrartcl}",
"\\usepackage{ngerman}",
"\\usepackage{lscape}",
"\\usepackage{ifpdf}",
"\\usepackage[latin1]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{array}",
"\\usepackage{enumerate}",
"\\usepackage{longtable}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\usepackage{makeidx}",
"\\makeindex",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"  pdftex,",
"  a4paper=true,",
"  pdftitle={Netzwerk-Dokumentation},",
"  pdfsubject={Netzwerk-Dokumentation},",
"  pdfauthor={Netzwerk-Administrator},",
"  pdfcreator={http://dktools.sourceforge.net/hostsadm.html},",
"  colorlinks=true,",
"  linkcolor=black,",
"  pdfpagemode=UseNone,",
"  pdfstartview={XYZ 0 835 1.25},",
"  bookmarksnumbered",
"]{hyperref}",
"\\else",
"\\usepackage[",
"  dvips,",
"  colorlinks=true,",
"  linkcolor=black",
"]{hyperref}",
"\\fi",
"\\parindent0cm",
"\\author{Netzwerk-Administrator}",
"\\title{Netzwerk-Dokumentation}",
"\\setcounter{secnumdepth}{1}",
"\\renewcommand*{\\sectfont}{\\bfseries}",
"\\begin{document}",
"\% \\ifpdf\\pdfbookmark[2]{\\contentsname}{toc}\\fi",
"\\maketitle",
"\\cleardoublepage",
"\% \\ifpdf\\pdfbookmark[1]{\\contentsname}{tocanc}\\fi",
"\\tableofcontents",
"\\cleardoublepage"
);

my @lpr2en = (
"\\documentclass[12pt,a4paper,titlepage]{article}",
"\\usepackage{lscape}",
"\\usepackage{ifpdf}",
"\\usepackage[latin1]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{array}",
"\\usepackage{enumerate}",
"\\usepackage{longtable}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"  pdftex,",
"  a4paper=true,",
"  pdftitle={License usage report},",
"  pdfsubject={license usage},",
"  pdfauthor={The Software Administrator},",
"  pdfcreator={http://dktools.sourceforge.net/hostsadm.html},",
"  colorlinks=true,",
"  linkcolor=black,",
"  pdfpagemode=UseNone,",
"  pdfstartview={XYZ 0 835 1.25},",
"  bookmarksnumbered",
"]{hyperref}",
"\\else",
"\\usepackage[",
"  dvips,",
"  colorlinks=true,",
"  linkcolor=black",
"]{hyperref}",
"\\fi",
"\\parindent0cm",
"\\author{The Software Administrator}",
"\\title{License usage report}",
"\\setcounter{secnumdepth}{1}",
"\\begin{document}",
"\% \\ifpdf\\pdfbookmark[2]{\\contentsname}{toc}\\fi",
"\\maketitle",
"\\cleardoublepage",
"\% \\ifpdf\\pdfbookmark[1]{\\contentsname}{tocanc}\\fi",
"\\tableofcontents",
"\\cleardoublepage"
);

my @lpr2de = (
"\\documentclass[12pt,a4paper,titlepage]{scrartcl}",
"\\usepackage{ngerman}",
"\\usepackage{lscape}",
"\\usepackage{ifpdf}",
"\\usepackage[latin1]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{array}",
"\\usepackage{enumerate}",
"\\usepackage{longtable}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"  pdftex,",
"  a4paper=true,",
"  pdftitle={Lizenz-Nutzung},",
"  pdfsubject={Lizenz-Nutzung},",
"  pdfauthor={Software-Administrator},",
"  pdfcreator={http://dktools.sourceforge.net/hostsadm.html},",
"  colorlinks=true,",
"  linkcolor=black,",
"  pdfpagemode=UseNone,",
"  pdfstartview={XYZ 0 835 1.25},",
"  bookmarksnumbered",
"]{hyperref}",
"\\else",
"\\usepackage[",
"  dvips,",
"  colorlinks=true,",
"  linkcolor=black",
"]{hyperref}",
"\\fi",
"\\parindent0cm",
"\\author{Software-Administrator}",
"\\title{Lizenz-Nutzung}",
"\\setcounter{secnumdepth}{1}",
"\\renewcommand*{\\sectfont}{\\bfseries}",
"\\begin{document}",
"\% \\ifpdf\\pdfbookmark[2]{\\contentsname}{toc}\\fi",
"\\maketitle",
"\\cleardoublepage",
"\% \\ifpdf\\pdfbookmark[1]{\\contentsname}{tocanc}\\fi",
"\\tableofcontents",
"\\cleardoublepage"
);

my @lpost = (
"\\printindex",
"\\end{document}"
);

my @lpost2 = (
"\\end{document}"
);

sub get
{
  my $self = shift;
  my $back = "";
  if($#_ > -1) {
    my $number = shift;
    if($self->{'de'}) {
      $back = $stringsde[$number];
    } else {
      $back = $stringsen[$number];
    }
  }
  return $back;
}

sub get_latex_preamble
{
  my $self = shift;
  my $back = \@lpreen;
  if($self->{'de'}) {
    $back = \@lprede;
  }
  return $back;
}

sub get_latex_preamble_2
{
  my $self = shift;
  my $back = \@lpr2en;
  if($self->{'de'}) {
    $back = \@lpr2de;
  }
  return $back;
}

sub get_latex_postamble
{
  my $self = shift;
  my $back = \@lpost;
  return $back;
}

sub get_latex_postamble2
{
  my $self = shift;
  my $back = \@lpost2;
  return $back;
}

1;
