/*
jlayout - A Java code generator for GUI layout
Copyright (c) 2007-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	jlmsg.c	The jlmsg module of the jlayout program.
*/



/**	Inside the jlmsg module.
*/
#define JLMSG_C	1

#include "jl.h"




#line 54 "jlmsg.ctr"




/**	Key/value pairs to construct the msg array of the JLJ.
*/
static
dk_key_value_t kv[] = {
{
  "/m/00",
  "Too many file names specified!"
},
{
  "/m/01",
  "At least one file name is needed!"
},
{
  "/m/02",
  "Missing object name!"
},
{
  "/m/03",
  "Missing class name for object \""
},
{
  "/m/04",
  "\"!"
},
{
  "/m/05",
  "Missing object and class name!"
},
{
  "/m/06",
  "Redefinition of \""
},
{
  "/m/07",
  "\"!"
},
{
  "/m/08",
  "Object \""
},
{
  "/m/09",
  "\" defined before used! Attribute interitance broken."
},
{
  "/m/10",
  "Object \""
},
{
  "/m/11",
  "\" used several times! Each object can have one parent object only."
},
{
  "/m/12",
  "Processing aborted."
},
{
  "/m/13",
  "Unknown attribute!"
},
{
  "/m/14",
  "Circular dependencies between objects!"
},
{
  "/m/15",
  "Internal error in levelizing!"
},
{
  "/m/16",
  "Not enough memory (RAM/swap space)!"
},
{
  "/m/17",
  "Too many objects!"
},
{
  "/m/18",
  "Input file name pattern must match one file!"
},
{
  "/m/19",
  "Failed to create a file name expander!"
},
{
  "/m/20",
  "Output file name pattern must match one file!"
},
{
  "/m/21",
  "Illegal fill style!"
},
{
  "/m/22",
  "Illegal anchor value!"
},
{
  "/m/23",
  "Syntax error: Key empty!"
},
{
  "/m/24",
  "Syntax error: Line must be a key/value pair!"
},
{
  "/m/25",
  "Syntax error: Empty default line!"
},
{
  "/m/26",
  "Syntax error: Unknown control instruction!"
},
{
  "/m/27",
  "Syntax error: Empty control instruction!"
},
{
  "/m/28",
  "Syntax error: Missing object name!"
},
{
  "/m/29",
  "Syntax error: No closing square bracket!"
},
{
  "/m/30",
  "Syntax error: Empty text!"
},
{
  "/m/31",
  "Syntax error: Empty listener specification!"
},
{
  "/m/32",
  "Syntax error: Insufficient object placement information!"
},
{
  "/m/33",
  "Additional information was ignored."
},
{
  "/m/34",
  "Syntax error: Illegal layout value!"
},
{
  "/m/35",
  "Syntax error: Number exptected!"
},
{
  "/m/36",
  "GroupLayout is not supported!"
},
{
  "/m/37",
  "SpringLayout is not supported!"
},
{
  "/m/38",
  "New value overrides previous setting."
},
{
  "/m/39",
  "Syntax error: Missing button group name!"
},
{
  "/m/40",
  "Syntax error: Boolean expected!"
},
{
  "/m/41",
  "Syntax error: Unknown border sub type!"
},
{
  "/m/42",
  "Syntax error: Color specification missing!"
},
{
  "/m/43",
  "Syntax error: Either icon:... or color:... expected!"
},
{
  "/m/44",
  "Syntax error: Too few arguments!"
},
{
  "/m/45",
  "Syntax error: Missing title specification!"
},
{
  "/m/46",
  "Syntax error: Illegal border  type!"
},
{
  "/m/47",
  "Syntax error: Border type already specified!"
},
{
  "/m/48",
  "Syntax error: Missing group name!"
},
{
  "/m/49",
  "Syntax error: Missing text for titled border!"
},
{
  "/m/50",
  "Syntax error: Empty value!"
},
{
  "/m/51",
  "Failed to read input file!"
},
{
  "/m/52",
  "Failed to write output file!"
},
{
  "/m/53",
  "Empty option line!"
},
{
  "/m/54",
  "Too many rows or columns!"
},
{
  "/m/55",
  "Syntax error: Boolean value expected!"
},
{
  "/m/56",
  "Syntax error: Numeric value expected!"
},
{
  "/m/57",
  "Syntax error: Unknown alignment!"
},
{
  "/m/58",
  "Failed to read Java file \""
},
{
  "/m/59",
  "\"!"
},
{
  "/m/60",
  "Syntax error: Unknown text position!"
},
};
/**	Number of elements in \a kv. */
static size_t kv_size = DK_KEY_VALUE_ARRAY_SIZE(kv) ;



/**	Empty string.
*/
static char str_empty[] = { "" };


/**	Program name as printed in messages.
*/
static char str_jlayout[] = { "jlayout:" };



/**	Return the pointer to the \a kv array.
	@return	Pointer to \a kv array.
*/
dk_key_value_t *
jlmsg_msg DK_P0()
{
  return kv;
}



/**	Get the size of the key/value array \a kv.
	@return	Size of \a kv (Number of entries).
*/
size_t
jlmsg_size DK_P0()
{
  return kv_size;
}



/**	Create a log message consisting of one piece of text.
	@param	j	Jlayout job.
	@param	l	Log level.
	@param	msgno	Index of message in localized texts array.
*/
void
jlmsg_log1 DK_P3(JLJ *,j, int,l, size_t,msgno)
{
  char *msg[2];
  
  if(j) {	
    msg[0] = (j->msg)[msgno];
    
    if(j->a) {	
      if((j->errfilename) && (j->errlineno)) {
        dkapp_set_source_lineno(j->a, j->errlineno);
	dkapp_set_source_filename(j->a, j->errfilename);
      } else {
        dkapp_set_source_lineno(j->a, 0UL);
	dkapp_set_source_filename(j->a, NULL);
      }
      dkapp_log_msg(j->a, l, msg, 1);
    } else {	
      if(!((j->run_silently) & 1)) {	
        fprintf(stderr, str_jlayout);
	if((j->errfilename) && (j->errlineno)) {
	  fprintf(stderr, "%s:%lu:",
	    j->errfilename, j->errlineno
	  );
	}
	fprintf(stderr, " %s\n", (j->msg)[msgno]);
	fflush(stderr);
      } else {				
      }
    }
  } else {	
  } 
}



/**	Create a log message consisting of a name surrounded by two
	pieces of text.
	@param	j	Jlayout job.
	@param	l	log level.
	@param	msg1	Index of first message part in text array.
	@param	fn	Second message part.
	@param	msg2	Index of third message part in text array.
*/
void
jlmsg_log3 DK_P5(JLJ *,j, int,l, size_t,msg1, char *,fn, size_t,msg2)
{
  char *msg[3];
  if(j) {
    msg[0] = (j->msg)[msg1];
    msg[1] = (fn ? fn : str_empty);
    msg[2] = (j->msg)[msg2];
    if(j->a) {
      if((j->errfilename) && (j->errlineno)) {
        dkapp_set_source_lineno(j->a, j->errlineno);
	dkapp_set_source_filename(j->a, j->errfilename);
      } else {
        dkapp_set_source_lineno(j->a, 0UL);
	dkapp_set_source_filename(j->a, NULL);
      }
      dkapp_log_msg(j->a, l, msg, 3);
    } else {
      if(!((j->run_silently) & 1)) {
        fprintf(stderr, str_jlayout);
	if((j->errfilename) && (j->errlineno)) {
	  fprintf(
	    stderr, "%s:%lu:",
	    j->errfilename, j->errlineno
	  );
	}
        fprintf(
	  stderr,
	  " %s%s%s\n", msg[0], msg[1], msg[2]
	); fflush(stderr);
      }
    }
  }
}



/**	Error message: Not enough memory.
	@param	j	Jlayout job.
*/
void
jlmsg_error_memory DK_P1(JLJ *,j)
{
  jlmsg_log1(j, DK_LOG_LEVEL_ERROR, 16);
}

