/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  other contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	rshdown.h	Definitions for the rshdown program.
*/


#ifndef RSHDOWN_H_INCLUDED
#define RSHDOWN_H_INCLUDED 1

#ifdef UNICODE
#undef UNICODE
#endif
#ifdef _UNICODE
#undef _UNICODE
#endif
#ifdef MBCS
#undef MBCS
#endif
#ifdef _MBCS
#undef MBCS
#endif

/**	We must use wide characters for system programs. */
#define UNICODE		1

/**	We must use wide characters for system programs. */
#define _UNICODE	1

/**	Maximum number of attempts to stop service. */
#define RSHDOWN_MAX_ATTEMPTS_TO_STOP	10

/**	Sleep time between attempts to receive UDP packet. */
#define RSHDOWN_STOP_SLEEP_TIME		1000

/**	Wait time for shutdown. */
#define RSHDOWN_STOP_WAIT_HINT		1500

/**	Buffer size to read configuration. */
#define RSHDOWN_BUFFER_SIZE		256

/**	Data buffer size. */
#define RSHDOWN_DATA_BUFFER_SIZE	2048

/**	Calculate size of a variable.
*/
#define SIZEOF(v,t) (sizeof(v)/sizeof(t))


#endif

