/*
Copyright (c) 2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include "dk.h"

#if DK_HAVE_STRING_H
#include <string.h>
#endif

#include "dksdbi.h"


#line 46 "sdbitest.ctr"



typedef struct {
  char *k;
  char *v;
} KV;

KV kv[] = {
  { "test1",	"Erwin Unsinn" },
  { "test2",	"Joachim Unfug" },
  { "test1",	"Noch mehr Unsinn" },
  { NULL, NULL },
};

static char buffer[1024];

static int
traversal_fct DK_P5(void *,d, void *,ke, size_t,kl, void *,va, size_t,vl)
{
  int back = 0;
  size_t i;
  char *k = NULL;
  char *v = NULL;
  k = ke; v = va;
  if((k) && (kl)) {
    printf("Traversal: \"");
    for(i = 0; i < kl; i++) printf("%c", k[i]);
    printf("\"=\"");
    if((v) && (vl)) {
      for(i = 0; i < vl; i++) printf("%c", v[i]);
    }
    printf("\"\n");
  }
  return back;
}

void main(void)
{
  dk_sdbi_t p;
  KV *kvptr;
  size_t l1, l2;
  
#line 88 "sdbitest.ctr"

  p = dksdbi_open("gdbm:/tmp/example", DK_SDBI_TYPE_AUTO, DK_SDBI_MODE_RDWR, 0600, 512);
  if(p) {
    /* store binary */
    kvptr = kv;
    while(kvptr->k) {
      l1 = 1 + strlen(kvptr->k);
      l2 = 1 + strlen(kvptr->v);
      if(dksdbi_store(p, kvptr->k, l1, kvptr->v, l2, 0)) {
        printf("STORE %s=%s OK\n", kvptr->k, kvptr->v);
      } else {
        printf("STORE %s=%s FAILED\n", kvptr->k, kvptr->v);
      }
      kvptr++;
    }
    /* fetch binary */
    kvptr = kv;
    while(kvptr->k) {
      l1 = 1 + strlen(kvptr->k);
      l2 = sizeof(buffer);
      if(dksdbi_fetch(p, kvptr->k, l1, buffer, &l2)) {
        if(l2 < sizeof(buffer)) {
	  buffer[l2] = '\0';
	  printf("FETCH %s=%s OK\n", kvptr->k, buffer);
	} else {
	  buffer[sizeof(buffer)-1] = '\0';
	  printf("FETCH %s=%s TRUNCATED\n", kvptr->k, buffer);
	}
      } else {
        printf("FETCH %s FAILED\n", kvptr->k);
      }
      kvptr++;
    }
    /* store strings */
    kvptr = kv;
    while(kvptr->k) {
      if(dksdbi_string_store(p, kvptr->k, kvptr->v, 0)) {
        printf("PUT %s=%s OK\n", kvptr->k, kvptr->v);
      } else {
        printf("PUT %s=%s ERROR\n", kvptr->k, kvptr->v);
      }
      kvptr++;
    }
    /* fetch strings */
    kvptr = kv;
    while(kvptr->k) {
      if(dksdbi_string_fetch(p, kvptr->k, buffer, sizeof(buffer))) {
        printf("GET %s=%s OK\n", kvptr->k, buffer);
      } else {
        printf("GET %s failed\n", kvptr->k);
      }
      kvptr++;
    }
    /* traverse database */
    dksdbi_traverse(p, NULL, traversal_fct);
    dksdbi_close(p);
  } else {
    printf("ERROR: Failed to create SDBI\n");
  }
  
#line 147 "sdbitest.ctr"

}


