#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include "dk.h"
#include "dkmem.h"
#include "dktypes.h"
#include "dkle.h"

#define DEFAULT_BUFFER_SIZE	256

MODULE = DKrause::LaTeXEncoder	PACKAGE = DKrause::LaTeXEncoder	PREFIX = le_


PROTOTYPES: ENABLE

DKrause::LaTeXEncoder
le_new(d)
		char *d;
	PREINIT:
		dk_le_t		*le	= NULL;
		dk_le_wrapper_t	*back	= NULL;
	CODE:
		back = dk_new(dk_le_wrapper_t,1);
		if(back) {
		  back->l = dkle_open(d);
		  if(back->l) {
		    back->flags = 0;
		  } else {
		    dk_delete(back); back = NULL;
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL



void
le_DESTROY(l)
		DKrause::LaTeXEncoder l;
	PREINIT:
		dk_le_t *le;
	CODE:
		if(l) {
		  le = l->l;
		  if(le) {
		    dkle_close(le);
		  }
		  l->l = NULL;
		  dk_delete(l);
		}



void
le_setUtf8(l,b)
		DKrause::LaTeXEncoder	l;
		int			b;
	CODE:
		if(b) {
		  l->flags |= DK_LE_FLAGS_UTF8;
		} else {
		  l->flags &= (~(DK_LE_FLAGS_UTF8));
		}



char *
le_convert(l,s)
		DKrause::LaTeXEncoder	l;
		char			*s;
	PREINIT:
		char *back = NULL;
		char *buffer = NULL;
		char mybu[DEFAULT_BUFFER_SIZE];
		size_t s1;
	CODE:
		if((l->flags) & DK_LE_FLAGS_UTF8) {
		  s1 = 1 + dkle_length_utf8_to_latex(l->l, s);
		  if(s1 > 1) {
		    if(s1 > sizeof(mybu)) {
		      buffer = dk_new(char,s1);
		      if(buffer) {
		        if(dkle_put_utf8_to_latex(l->l,buffer,s1,s)) {
		          back = buffer;
		        }
		      }
		    } else {
		      if(dkle_put_utf8_to_latex(l->l,mybu,sizeof(mybu),s)) {
		        back = mybu;
		      }
		    }
		  }
		} else {
		  s1 = 1 + dkle_length_plain_to_latex(l->l, s);
		  if(s1 > 1) {
		    if(s1 > sizeof(mybu)) {
		      buffer = dk_new(char,s1);
		      if(buffer) {
		        if(dkle_put_plain_to_latex(l->l,buffer,s1,s)) {
		          back = buffer;
		        }
		      }
		    } else {
		      if(dkle_put_plain_to_latex(l->l,mybu,sizeof(mybu),s)) {
		        back = mybu;
		      }
		    }
		  }
		}
		if(back) {
		  RETVAL = back;
		} else {
		  XSRETURN_UNDEF;
		}
	OUTPUT:
		RETVAL
	CLEANUP:
		if(buffer) {
		  dk_delete(buffer); buffer = NULL;
		}

