/*
Copyright (c) 2000-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

/**	@file	dkconfd.h
	Configuration defaults.
	The settings in this file are used if config.h can not be used
	(i.e. on systems where ./configure can not be run).
*/

#ifndef DKCONFD_INC

/** Make sure to include the file only once. */
#define DKCONFD_INC 1

#if __BORLANDC__ || __BCPLUSPLUS__
/* + BC31 */
/*
	Note: These settings are for BC 3.1 on DOS. If you have something
	newer, i.e. C++ Builder or so you might want to copy the
	settings from the MSVC50 section to here.
*/
#define HAVE_ISDIGIT		1
#define HAVE_NO_INODES		1
#define HAVE_CODEPAGES		1
#define SIZEOF_INT		2
#define SIZEOF_SHORT		2
#define SIZEOF_LONG		4
#define HAVE_LONG_LONG_INT	0
#define HAVE_ALLDOTALL		1
#define	HAVE_PROTOTYPES		1
#define HAVE_FEATURE_DOS_EXEC	1
#define HAVE_DOS_DRIVE_LETTER	1
#define HAVE_FEATURE_DOS	1
#define HAVE_FEATURE_BACKSLASH	1
#define HAVE_FEATURE_DRIVECHAR	1
#define HAVE_FEATURE_FN83	1
#define HAVE_STRCHR		1
#define HAVE_STRRCHR		1
#define HAVE_STRICMP		1
#define HAVE_CTYPE_H		1
#if __HUGE__ || __LARGE__
#define HAVE_FARCALLOC		1
#define HAVE_FARMALLOC		1
#define	HAVE_FARFREE		1
#define HAVE_FARCORELEFT	1
#endif
#define HAVE_MALLOC		1
#define HAVE_CALLOC		1
#define HAVE_FREE		1
#define HAVE_CORELEFT		1
#define HAVE_MEMSET		1
#define HAVE_MEMCMP		1
#define HAVE_MEMCPY		1
#define HAVE_STDLIB_H		1
#define HAVE_IO_H		1
#define HAVE_STDDEF_H		1
#define HAVE_STRING_H		1
#define HAVE_SYS_TYPES_H	1
#define HAVE_TIME_H		1
#define HAVE_SYS_STAT_H		1
#define HAVE_BIOS_H		1
#define HAVE_DIRECT_H		1
#define HAVE_DIRENT_H		0
#define HAVE_DIR_H		1
#define HAVE_ALLOC_H		1
#define HAVE_MALLOC_H		1
#define HAVE_MATH_H		1
#define HAVE_SIGNAL_H		1
#define HAVE_PROCESS_H		1
#define HAVE_DOS_H		1
#define HAVE_VOLATILE		1
#define HAVE_FINDFIRST		1
#define HAVE_STRICMP		1
#define HAVE_OPENDIR		1
#define HAVE_GETCWD		1
#define HAVE_IOCTL		1
#define HAVE_GETPID		1
#define HAVE_UNLINK		1
#define HAVE_RMDIR		1
#define HAVE_FILENO		1
#define HAVE_SIGNAL		1
#define HAVE_STAT		1
#define HAVE_MKDIR		1
#define HAVE_REMOVE		1
#define HAVE_LOCK		1
#define HAVE_SLEEP		1
#define HAVE_FNCASEINS		1
#define HAVE_SOCKLEN_T		0
#define HAVE_SIZE_T		1
#define HAVE_ISATTY		0
#define HAVE_TERMIOS_H		0
#define HAVE_SYS_TERMIOS_H	0
#define HAVE_SYS_TTOLD_H	0
#define HAVE_TCGETATTR		0
#define HAVE_TCFLUSH		0
#define HAVE_WINCON_H		0
#define HAVE_GETSTDHANDLE	0
#define HAVE_SETJMP_H		1
#define HAVE_DOSWIN_SETMODE	1
#define HAVE_GETPEERNAME	0
#define HAVE_GETSOCKNAME	0
/* - BC31 */
#else
/* + !BC31 */
#if _MSC_VER >= 1100
/* + MSVC50 */
#define HAVE_CTYPE_H		1
#define HAVE_SYS_WAIT_H		0
#define TIME_WITH_SYS_TIME	0
#define HAVE_SIGNAL_H		0
#define HAVE_SIGSET		0
#define HAVE_SIGNAL		0
#define HAVE_SIGACTION		0
#define HAVE_NETDB_H		0
#define HAVE_ARPA_INET_H	0
#define HAVE_ISDIGIT		1
#define HAVE_NO_INODES		1
#define HAVE_CODEPAGES		1
#define SIZEOF_SHORT		2
#define SIZEOF_INT		4
#define SIZEOF_LONG		4
#if _MSC_VER >= 1310
#define HAVE_LONG_LONG_INT	1
#define HAVE__FINDFIRST32	0
#define HAVE__FINDFIRST64	1
#define HAVE__STAT32		0
#define HAVE__STAT64		1
#else
#define HAVE_LONG_LONG_INT	0
#define HAVE__FINDFIRST		1
#define HAVE__STAT		1
#endif
#define HAVE__POPEN		1
#define HAVE_FEATURE_DOS_EXEC	1
#define HAVE_DOS_DRIVE_LETTER	1
#define HAVE_ALLDOTALL		0
#define HAVE_STRICMP		0
#define HAVE__STRICMP		1
#define HAVE_MALLOC		1
#define HAVE_FREE		1
#define HAVE_CALLOC		1
#define HAVE_GETCWD		1
#define HAVE_MEMCPY		1
#define HAVE_MEMCMP		1
#define HAVE_MEMSET		1
#define HAVE_GETPID		1
#define HAVE_UNLINK		0
#define HAVE__UNLINK		1
#define HAVE_RMDIR		0
#define HAVE__RMDIR		1
#define HAVE_FILENO		0
#define HAVE__FILENO		1
#define HAVE_SELECT		1
#define HAVE_SOCKET		1
#define HAVE_SETSOCKOPT		1
#define HAVE_STAT		0
#define HAVE_MKDIR		0
#define HAVE__MKDIR		1
#define HAVE_REMOVE		1
#define HAVE_HTONL		0
#define HAVE_GETCWD		1
#define HAVE_OPEN		1
#define HAVE_CLOSE		1
#define HAVE_READ		1
#define HAVE_WRITE		1
#define HAVE_LSTAT		0
#define HAVE_REMOVE		1
#define HAVE_LOCKING		1
#define HAVE_IO_H		1
#define HAVE_STRING_H		1
#define HAVE_STDLIB_H		1
#define HAVE_UNISTD_H		0
#define HAVE_MALLOC_H		1
#define HAVE_DIRECT_H		1
#define HAVE_MEMORY_H		1
#define HAVE_WINDOWS_H		1
#define HAVE_WINBASE_H		1
#define HAVE_WINREG_H		1
#define HAVE_WINSOCK2_H		1
#define HAVE_WINCON_H		1
#define HAVE_GETSTDHANDLE	1
#if HAVE_WINSOCK2_H
#define HAVE_GETHOSTBYNAME	1
#define HAVE_GETHOSTNAME	0
#define HAVE_GETSERVBYNAME	1
#define HAVE_GETPEERNAME	1
#define HAVE_GETSOCKNAME	1
#endif
#define HAVE_PROCESS_H		1
#define HAVE_SYS_TYPES_H	1
#define HAVE_SYS_STAT_H		1
#define HAVE_ERRNO_H		1
#define HAVE_STDDEF_H		1
#define HAVE_FEATURE_DLL	1
#define USE_FEATURE_DLL		1
#define HAVE_TIME_H		1
#define HAVE_SYS_STAT_H		1
#define HAVE_SYS_LOCKING_H	1
#define HAVE_MATH_H		1
#define	HAVE_PROTOTYPES		1
#define HAVE_FEATURE_BACKSLASH	1
#define HAVE_FEATURE_DRIVECHAR	1
#define HAVE_VOLATILE		1
#define HAVE_STRCHR		1
#define HAVE_STRRCHR		1
#define HAVE_STRDUP		1
#define HAVE_CONIO_H		1
#define HAVE__KBHIT		1
#define HAVE__GETCH		1
#define HAVE_SLEEP		0
#define HAVE_GETMODULEFILENAME	1
#define HAVE_GETMODULEHANDLE	1
#define HAVE_GETCOMPUTERNAME	1
#define HAVE_GETCURRENTDIRECTORY	1
#define HAVE_GETCURRENTPROCESSID	1
#define HAVE_GETUSERNAME	1
#define HAVE_GETWINDOWSDIRECTORY	1
#define HAVE_GETSYSTEMDIRECTORY		1
#define HAVE_WCHAR_H		1
#define HAVE_WCSCHR		1
#define HAVE_WCSRCHR		1
#define HAVE_WCSCASECMP		0
#define HAVE_WCSICMP		0
#define HAVE_WCSLEN		1
#define HAVE_WCSCMP		1
#define HAVE_WCSCPY		1
#define HAVE__SETMODE		1
#define HAVE__FDOPEN		1
#define HAVE_SETMODE		0
#define HAVE_FDOPEN		0
#define HAVE_FNCASEINS		1
#define HAVE_SOCKLEN_T		0
#define HAVE_SIZE_T		1
#define HAVE_STDARG_H		1
#define HAVE_VARARG_H		0
#define HAVE_VARARGS_H		1
#define	HAVE_ISATTY		0
#define HAVE_TERMIOS_H		0
#define HAVE_SYS_TERMIOS_H	0
#define HAVE_SYS_TTOLD_H	0
#define HAVE_TCGETATTR		0
#define HAVE_TCFLUSH		0
#define HAVE_SETJMP_H		1
#define HAVE_DOSWIN_SETMODE	1
#define HAVE_FCNTL_H		1
#define HAVE_RAND		1
#define HAVE_SRAND		1
#define HAVE_INITSTATE		0
#define HAVE_SETSTATE		0
#define HAVE_RANDOM		0
#define HAVE_LRAND48		0
#define HAVE_SEED48		0
#define HAVE_NRAND48		0
#define HAVE_DEV_URANDOM	0
#define HAVE_DEV_RANDOM		0
/* - MSVC50 */
#else
/* + !BC31 && !MSVC50 */
#if defined(__sun)
/* + __sun */
#define HAVE_ISDIGIT		1
#define WORDS_BIGENDIAN		1
#define HAVE_FEATURE_DOS_EXEC	0
#define HAVE_ALLDOTALL		0
#define HAVE_PROTOTYPES		1
#define HAVE_FINDFIRST		0
#define HAVE_STRCHR		1
#define HAVE_STRRCHR		1
#define HAVE_STRCASECMP		1
#define HAVE_STRICMP		0
#define HAVE_STRDUP		1
#define HAVE_FARCALLOC		0
#define HAVE_FARMALLOC		0
#define HAVE_FARCFREE		0
#define HAVE_FARFREE		0
#define HAVE_FARCORELEFT	0
#define HAVE_CALLOC		1
#define HAVE_MALLOC		1
#define HAVE_CFREE		1
#define HAVE_FREE		1
#define HAVE_CORELEFT		0
#define HAVE_MEMSET		1
#define HAVE_BZERO		1
#define HAVE_MEMCMP		1
#define HAVE_BCMP		1
#define HAVE_MEMCPY		1
#define HAVE_BCOPY		1
#define HAVE_OPENDIR		1
#define HAVE_LSTAT		1
#define HAVE_GETCWD		1
#define HAVE_GETWD		1
#define HAVE_GETHOSTBYNAME	1
#define HAVE_GETHOSTNAME	1
#define HAVE_GETUID		1
#define	HAVE_GETEUID		1
#define HAVE_GETGID		1
#define HAVE_GETEGID		1
#define HAVE_GETSERVBYNAME	1
#define HAVE_GETADDRINFO	0
#define HAVE_GETNETPATH		0
#define HAVE_NETDIR_GETBYNAME	0
#define HAVE_FCNTL		1
#define HAVE_FCNTL_H		1
#define HAVE_IOCTL		1
#define HAVE_GETPID		1
#define HAVE_GETPGRP		1
#define HAVE_GETPPID		1
#define HAVE_GETPGID		1
#define HAVE_UNLINK		1
#define HAVE_FILENO		1
#define HAVE_SETPWENT		1
#define HAVE_ENDPWENT		1
#define HAVE_GETPWENT		1
#define HAVE_GETPWNAM		1
#define HAVE_GETPWUID		1
#define HAVE_SETGRENT		1
#define HAVE_ENDGRENT		1
#define HAVE_GETGRENT		1
#define HAVE_GETGRNAM		1
#define HAVE_NDBM_H		1
#define HAVE_GETGRGID		1
#define HAVE_SELECT		1
#define HAVE_POLL		1
#define HAVE_SOCKET		1
#define HAVE_SETSOCKOPT		1
#define HAVE_SIGNAL		1
#define HAVE_SIGNAL_H		1
#define HAVE_SIGSET		1
#define HAVE_SIGACTION		1
#define HAVE_SYSLOG		1
#define HAVE_SETUID		1
#define HAVE_SETEUID		1
#define HAVE_YP_BIND		1
#define HAVE_RINT		1
#define HAVE_STAT		1
#define HAVE_MKDIR		1
#define HAVE_MKDIR2		1
#define HAVE_REMOVE		1
#define HAVE_HTONL		1
#define HAVE_GETRLIMIT		1
#define HAVE_SETSID		1
#define HAVE_LOCKF		1
#define HAVE_FLOCK		0
#define HAVE_LOCK		0
#define HAVE_STDLIB_H		1
#define HAVE_IO_H		0
#define HAVE_STDDEF_H		1
#define HAVE_STRING_H		1
#define HAVE_STRINGS_H		1
#define HAVE_UNISTD_H		1
#define HAVE_FEATURE_DLL	0
#define USE_FEATURE_DLL		0
#define HAVE_SYS_TYPES_H	1
#define HAVE_STROPTS_H		1
#define HAVE_ERRNO_H		1
#define HAVE_SYS_PARAM_H	1
#define HAVE_SYS_TIME_H		1
#define HAVE_TIME_H		1
#define HAVE_SYS_STAT_H		1
#define HAVE_SYS_STATVFS_H	1
#define HAVE_SYS_STROPTS_H	1
#define HAVE_SYS_FILE_H		1
#define HAVE_SYS_UIO_H		1
#define HAVE_SYS_UN_H		1
#define HAVE_SYS_SUNDDI_H	1
#define HAVE_BIOS_H		0
#define HAVE_DIR_H		0
#define HAVE_DIRENT_H		1
#define HAVE_DIRECT_H		0
#define HAVE_MALLOC_H		1
#define HAVE_ALLOC_H		0
#define HAVE_SYSRES_H		0
#define HAVE_XTI_H		1
#define HAVE_TIUSER_H		1
#define HAVE_SYS_SOCKET_H	1
#define HAVE_WINSOCK2_H		0
#define HAVE_NETINET_IN_H	1
#define HAVE_ARPA_INET_H	1
#define HAVE_NETDB_H		1
#define HAVE_RPCSVC_YP_PROT_H	1
#define HAVE_RPCSVC_YPCLNT_H	1
#define HAVE_GRP_H		1
#define HAVE_PWD_H		1
#define HAVE_MATH_H		1
#define HAVE_VOLATILE		1
#define	HAVE_UNLINK		1
#define HAVE_RMDIR		1
#define HAVE_FEATURE_DOS	0
#define HAVE_FEATURE_BACKSLASH  0
#define HAVE_FEATURE_DRIVECHAR  0
#define HAVE_FEATURE_FN83       0
#define HAVE_FINDFIRST		0
#define HAVE_FINDFIRST32	0
#define HAVE__GETCWD		1
#define HAVE__OPEN		1
#define HAVE__CLOSE		1
#define HAVE__READ		1
#define HAVE__WRITE		1
#define HAVE__STAT		1
#define HAVE__LSTAT		1
#define HAVE__MKDIR		1
#define HAVE__REMOVE		0
#define HAVE__FILENO		1
#define HAVE__LOCKING		0
#define HAVE_CTYPE_H		1
#define HAVE_SYSLOG_H		1
#define HAVE_SYS_SYSTEMINFO_H	1
#define HAVE_SYSINFO		1
#define HAVE_DOTFILENAMES	1
#define HAVE_SLEEP		1
#define HAVE_WCHAR_H		1
#define HAVE_WCSCHR		1
#define HAVE_WCSRCHR		1
#define HAVE_WCSCASECMP		0
#define HAVE_WCSICMP		0
#define HAVE_WCSLEN		1
#define HAVE_WCSCMP		1
#define HAVE_WCSCPY		1
#define HAVE_SETMODE		0
#define HAVE_FNCASEINS		0
#define HAVE_LONG_LONG_INT	1
#define HAVE_SOCKLEN_T		0
#define HAVE_SIZE_T		1
#define HAVE_STDARG_H		1
#define HAVE_VARARG_H		0
#define HAVE_VARARGS_H		1
#define	HAVE_ISATTY		1
#define HAVE_TERMIOS_H		1
#define HAVE_SYS_TERMIOS_H	1
#define HAVE_SYS_TTOLD_H	1
#define HAVE_TCGETATTR		1
#define HAVE_TCFLUSH		1
#define HAVE_WINCON_H		0
#define HAVE_GETSTDHANDLE	0
#define HAVE_SETJMP_H		1
#define HAVE_GETPEERNAME	1
#define HAVE_GETSOCKNAME	1
/* - __sun */
#else
/* + !__sun && !BC31 && !MSVC50 */
#define HAVE_LONG_LONG_INT	0
#define HAVE_ISDIGIT		1
#define HAVE_SETJMP_H		1
/* - !__sun && !BC31 && !MSVC50 */
#endif
/* - !BC31 && !MSVC50 */
#endif
/* - !BC31 */
#endif

#ifndef HAVE_ZLIB_H
#define HAVE_ZLIB_H 1
#endif
#ifndef HAVE_BZLIB_H
#define HAVE_BZLIB_H 1
#endif

#endif

