/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <png.h>


static char *color_types[] = {
  "<unknown>",
  "gray",
  "gray-alpha",
  "palette",
  "rgb",
  "rgb-alpha",
  NULL
};

static
void
run_for(char *filename)
{
  png_uint_32 ppm = 0UL, xppm = 0UL, yppm = 0UL;
  FILE *f = NULL;
  char *cts;
  f = dksf_fopen(filename, "rb");
  if(f) {
    png_structp	pp;
    png_infop	pi;
    pp = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
    if(pp) {
      pi = png_create_info_struct(pp);
      if(pi) {
        if(setjmp(pp->jmpbuf) == 0) {
	  unsigned long wi = 0UL, he = 0UL;
	  int bd = 0, ct = 0, it = 0, zt = 0, ft = 0, ch = 0;
	  int have_res = 0;
	  png_init_io(pp, f);
	  png_read_info(pp, pi);
	  png_get_IHDR(pp, pi, &wi, &he, &bd, &ct, &it, &zt, &ft);
	  ch = png_get_channels(pp, pi);
	  cts = color_types[0];
	  switch(ct) {
	    case PNG_COLOR_TYPE_GRAY: {
	      cts = color_types[1];
	    } break;
	    case PNG_COLOR_TYPE_GRAY_ALPHA: {
	      cts = color_types[2];
	    } break;
	    case PNG_COLOR_TYPE_PALETTE: {
	      cts = color_types[3];
	    } break;
	    case PNG_COLOR_TYPE_RGB: {
	      cts = color_types[4];
	    } break;
	    case PNG_COLOR_TYPE_RGB_ALPHA: {
	      cts = color_types[5];
	    } break;
	  }
	  if((ppm = png_get_pixels_per_meter(pp, pi))) {
	    have_res = 1;
	  }
	  if((xppm = png_get_x_pixels_per_meter(pp, pi))) {
	    have_res = 1;
	  }
	  if((yppm = png_get_y_pixels_per_meter(pp, pi))) {
	    have_res = 1;
	  }
	  printf(
	    "%s: w=%lu h=%lu ct=%d (%s) bd=%d ch=%d it=%d zt=%d ft=%d r=%d\n",
	    filename, wi, he, ct, cts, bd, ch, it, zt, ft, have_res
	  );
	  if(have_res) {
	    printf("%s: ppm=%lu xppm=%lu yppm=%lu\n",
	      filename, ppm, xppm, yppm
	    );
	  }
	} else {
	}
        png_destroy_info_struct(pp, &pi); pi = NULL;
      } else {
        fprintf(stderr, "pngreport: Not enough memory!\n"); fflush(stderr);
      }
      png_destroy_read_struct(&pp, NULL, NULL); pp = NULL;
    } else {
      fprintf(stderr, "pngreport: Not enough memory!\n"); fflush(stderr);
    }
    fclose(f); f = NULL;
  } else {
    fprintf(stderr, "pngreport: Failed to open \"%s\"!\n", filename);
    fflush(stderr);
  }
}


int main(int argc, char *argv[])
{
  int i;
  if(argc > 1) {
    for(i = 1; i < argc; i++) {
      run_for(argv[i]);
    }
  }
  exit(0); return 0;
}


