package DKrause::Application;

use 5.000000;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use DKrause::Application ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('DKrause::Application', $VERSION);

# Preloaded methods go here.

1;
__END__
=head1 NAME

DKrause::Application - Perl extension to the dkapp module

=head1 SYNOPSIS

  use DKrause::Application;

  $app = DKrause::Application::new($an, $gn, $scd $f_silent, $f_filter);

  $app->setSourceFileName("input.txt");
  $app->setSourceLineNumber(23);
  $app->log($logprio, $message);
  $fn5 = $app->getSourceFileName();
  $ln1 = $app->getSourceLineNumber();
  $app->setKeepTemporaryFiles(3);

  $val = $app->getPreference($key, $excludes);
  $bool1 = $app->getPreferenceBoolean("key");
  $ul1   = $app->getPreferenceUnsignedLong("another-key");
  $st3   = $app->getPreferenceString("yet.another.key");
  $app->setPreference($key, $value);

  $str = $app->transformString("$(user.uid)");
  $fn  = $app->transformStringOrFilename("c:/temp/$(user.uid).dat", 1);

  $fn2 = $app->findConfigurationFile("something.cfg");
  $fn3 = $app->findDataFile("something.txt");
  $st2 = $app->findString("myapp.stt", "/info/003", "Default string value");

  $stream1 = $app->readDataFile($filename);
  $stream2 = $app->readConfigurationFile("something.cfg");
  $stream3 = $app->writeFile("outputfile.txt");
  $stream4 = $app->openFile("somefile.txt", "r", "bzip2");
  $fn4 = $app->tempFileName();

  $app->unconfigure();
  $n = $app->getApplicationName();

  $maxpathlen = $app->getMaxPathLength();
  $maxfiles = $app->getMaxFiles();
  $directory = $app->getcwd();
  $filename = $app->getExecutableFileName("program");
  $st5 = $app->combinePaths($directory, "../../x.dat");

  if($app->isAbsolutePath($st5)) {
  }

  $suffix = $app->getFileNameSuffix($st5);
  $fn6 = $app->getLastFileName($st5);
  $fn7 = $app->correctFileName("c:/windows/system32");
  $app->removeDirectory("c:/temp/test");
  $app->removeFile($st5);
  $strm = $app->getLogStream();

=head1 DESCRIPTION

This module provides an interface to the dkapp module.
It can be used to set an retrieve preferences, to search for localized
messages, to search for configuration and data files and to issue
log messages.

In the constructor $an is an application name, $gn is the application
group name, $scd is the system configuration directory (/etc or
/usr/local/etc), $f_silent is the silence flag (no logging to stdout
or stderr), $f_filter is the filter flag (normal output goes to stdout,
so we want no log output to stdout).

The setSourceFileName() and setSourceLineNumber()
methods can be used before calls to log() if the
log message is related to a position in a source code or configuration file.

The getPreference(), getPreferenceBoolean(), getPreferenceUnsignedLong
and getPreferenceString() methods can be used to retrieve preferences,
setPfeference() sets a preference value().

The transformString() and transformStringOrFilename() methods replace
macros in strings:

  $(app).name)     Application name.
  $(user.name)     User name.
  $(user.home)     The users home directory.
  $(user.uid)      UID of the user running the current process.
  $(user.gid)      GID of the user running the current process.
  $(user.euid)     Effective UID of the current process.
  $(user.egid)     Effective GID of the current process.
  $(host.name)     Hostname.
  $(host.domain)   DNS domain of the host.
  $(app.dir)       Application resource directory.
  $(shared.dir)    Shared resource directory (application group).
  $(temp.dir)      Temporary directory.
  $(process.pid)   PID of the current process.
  $(process.ppid)  PID of the parent process.
  $(process.pgid)  The process group ID.

The transformStringOrFilename() method can additionally replaces slashes
by backslashes or vice versa.

The fincConfigurationFile() and findDataFile() methods can be used to
search for files.

The findString() method first searches for a string table file, in the
file it attempts to find the string for a given key.

The readConfigurationFile() and readDataFile() methods search for files
and open them for reading. A DKrause::Stream object reference is returned.

The writeFile() method opens a file for writing and returns a
DKrause::Stream object reference. The openFile() method opens a file
in a specified mode and adds a compression filter (``plain'', ``gzip''
or ``bzip2'') before returning a DKrause::Stream object reference.

The unconfigure() method resets all *user-defined' preferences
(permanent options) for the application. System preferences prepared by the
administrator remain intact.

The getApplicationName() method returns the application name as specified
in the constructor.

The getMaxPathLength() function returns the maximum length of a file name
in bytes.

The getMaxFiles() function returns the maximum number of files open at the
same time.

The getcwd() method returns the current working directory.

The getExecutableFileName() method returns the name of the executable
file for a given program name.

The combinePaths() method concatenates two file paths.

The isAbsolutePath() method tests, whether a file name is specified as
absolute path name.

The getFileNameSuffix() method returns the suffix of a file name.

The getLastFileName() method returns the last part of a path
(after the last slash/backslash).

The correctFileName() method converts slashes to backslashes or vice versa
in a file name.

The removeFile() and removeDirectory() methods can be used to delete
files and directories.

The getLogStream() method returns a DKrause::Stream object to access the
log file of the application.

=head2 EXPORT

None by default.



=head1 SEE ALSO

dkapp(3).

=head1 AUTHOR

Dirk Krause, E<lt>krause@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

=cut
