/*
Copyright (c) 2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	uab.c	Backend module.
*/


/** in the uab module. */
#define UAB_C	1


#include "useraudi.h"



#line 51 "uab.ctr"



int
uab_compare_lognames DK_P3(void *,l, void *,r, int,cr) {
  int back = 0;
  if(l) {
    if(r) {
      back = strcmp((char *)l, (char *)r);
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



void
uab_delete DK_P2(UAC *,uac, UAB *,u) {
  char *n;
  UAB_API uabapi;
  UAP *uap;
  
  if(u) {
    if(u->s_ex) {
      if(u->i_ex) {
        if(u->f) {
          uabapi.a.c = UA_API_DESTROY_DATA;
	  uabapi.a.f = 0; uabapi.a.t = NULL;
	  uabapi.a.v = NULL; uabapi.a.i = NULL;
	  (*(u->f))(uac, (void *)u, &uabapi);
	}
        dksto_it_reset(u->i_ex);
	while((n = (char *)dksto_it_next(u->i_ex)) != NULL) {
	  
	  dk_delete(n);
	}
        dksto_it_close(u->i_ex);
      }
      dksto_close(u->s_ex);
    } u->s_ex = NULL; u->i_ex = NULL;
    if(u->s_a) {
      if(u->i_a) {
        
        dksto_it_reset(u->i_a);
	while((uap = (UAP *)dksto_it_next(u->i_a)) != NULL) {
	  uau_property_delete(uap);
	}
        dksto_it_close(u->i_a);
      }
      dksto_close(u->s_a);
    } u->s_a = NULL; u->i_a = NULL;
    if(u->s_m) {
      if(u->i_m) {
        
        dksto_it_reset(u->i_m);
	while((uap = (UAP *)dksto_it_next(u->i_m)) != NULL) {
	  uau_property_delete(uap);
	}
        dksto_it_close(u->i_m);
      }
    } u->s_m = NULL; u->i_m = NULL;
    dk_delete(u);
  } 
}



UAB *
uab_new DK_P6(UAC *,uac,unsigned,n, int,t, ua_be_fct_t,*f, char *,fn, unsigned long,lineno)
{
  UAB *back = NULL;
  UAB_API uabapi;
  
  uabapi.a.c = UA_API_AVAILABLE;
  uabapi.a.f = 0; uabapi.a.t = NULL;
  uabapi.a.v = NULL; uabapi.a.i = NULL;
  (*f)(uac, NULL, &uabapi);
  if(uabapi.r.s) {
    back = dk_new(UAB,1);
    if(back) {
      back->s_ex = dksto_open(0);
      if(back->s_ex) {
        dksto_set_comp(back->s_ex, uab_compare_lognames, 0);
        back->i_ex = dksto_it_open(back->s_ex);
      }
      back->s_a = NULL; back->i_a = NULL;
      back->s_m = NULL; back->i_m = NULL;
      back->spec = NULL;
      back->f = f;
      back->nb = n;
      back->bet = t;
      back->ht = USERAUD_HASH_UNKNOWN;
      back->st = 0;
      back->sl = 0;
      if((back->s_ex) && (back->i_ex)) {
        uabapi.a.c = UA_API_CREATE_DATA;
	uabapi.a.f = 0; uabapi.a.t = NULL;
	uabapi.a.v = NULL; uabapi.a.i = NULL;
	(*f)(uac, (void *)back, &uabapi);
	if(!(uabapi.r.s)) {
	  uab_delete(uac, back); back = NULL;
	  ualog_file_lineno_1(
	    uac, DK_LOG_LEVEL_ERROR, fn, lineno, 21
	  );
	}
      } else {
        uab_delete(uac, back); back = NULL;
        ualog_file_lineno_1(
	  uac, DK_LOG_LEVEL_ERROR, fn, lineno, 14
        );
      }
    } else {
      ualog_file_lineno_1(
	uac, DK_LOG_LEVEL_ERROR, fn, lineno, 14
      );
    }
  } else {
    ualog_file_lineno_1(uac, DK_LOG_LEVEL_ERROR, fn, lineno, 20);
  } 
  return back;
}


