/*
Copyright (c) 2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/



/**	@file	uatool.c	Tool functions module. */


/** In the uatool module. */
#define UATOOL_C	1

#include "useraudi.h"




#line 50 "uatool.ctr"




/**	Names used to find PRNG seed data.
*/
static char *kw[] = {
/*   0 */	"/dev/urandom",
/*   1 */	"/dev/random",
/*   2 */	"EGDSOCKET",
/*   3 */	"/var/run/egd-pool",
/*   4 */	"RANDFILE",
/*   5 */	"\n",
NULL
};



time_t
uat_modtime DK_P1(char *,fn) {
  time_t back = (time_t)0;
  
  if(fn) {
#if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE
  struct stat64 st;
  if(stat64(fn, &st) == 0) {
    back = st.st_mtime;
  }
#else
/* if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE */
  struct stat st;
  if(stat(fn, &st) == 0) {
    back = st.st_mtime;
  }
#endif
/* if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE */
  } 
  return back;
}



struct passwd *
uat_getpwnam DK_P1(char *,n) {
  struct passwd *back = NULL;
#if DK_HAVE_GETPWNAM
  back = getpwnam(n);
#else
  struct passwd *ptr;
  int fcc;
#if DK_HAVE_SETPWENT
  setpwent();
#endif
  fcc = 1;
  do {
    fcc = 0;
    ptr = getpwent();
    if(ptr) {
      f_cc= 1;
      if(ptr->pw_name) {
        if(strcmp(n, ptr->pw_name) == 0) {
	  back = ptr;
	}
      }
    } else {
      f_cc = 0;
    }
  } while((back == NULL) && f_cc && (useraud_can_continue_outer_loop()));
#if DK_HAVE_SETPWENT
  endpwent();
#endif
#endif
  
  return back;
}


struct spwd *
uat_getspnam DK_P1(char *,n) {
  struct spwd *back = NULL;
#if DK_HAVE_GETSPNAM && DK_HAVE_SHADOW_H
  back = getspnam(n);
#else
#if DK_HAVE_GETSPENT
  struct spwd *ptr;
  int f_cc;
#if DK_HAVE_SETSPENT
  setspent();
#endif
  f_cc = 1;
  do {
    ptr = getspent();
    if(ptr) {
      if(ptr->sp_namp) {
        if(strcmp(ptr->sp_namp, n) == 0) {
	  back = ptr; f_cc = 0;
	}
      }
    } else {
      f_cc = 0;
    }
  } while(f_cc && useraud_can_continue_outer_loop());
#if DK_HAVE_SETSPENT
  endspent();
#endif
#else
/* can not retrieve shadown entry. */
#endif
#endif
  
  return back;
}



struct group *
uat_getgrnam DK_P1(char *,gn) {
  struct group *back = NULL;
#if DK_HAVE_GETGRNAM
#else
#if DK_HAVE_GETGRENT
  struct group *ptr;
  int f_cc;
#if DK_HAVE_SETGRENT
  setgrent();
#endif
  f_cc = 1;
  do {
    f_cc = 0;
    ptr = getgrent();
    if(ptr) {
      f_cc = 1;
      if(ptr->gr_name) {
        if(strcmp() == 0) {
	  back = ptr; f_cc = 0;
	}
      }
    }
  } while(f_cc)
#if DK_HAVE_SETGRENT
  endgrent();
#endif
#endif
#endif
  
  return back;
}



void
uat_save_seed DK_P1(UAC *,uac) {
  uid_t u;
  gid_t g;
  int can_use_file = 1;
  FILE *fipo;
  
  u = geteuid();
  g = getegid();	
  if(uac->seedname) {	
    can_use_file = 1;
#if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE
    {
      struct stat64 st;
      if(stat64(uac->seedname, &st) == 0) {	
        can_use_file = 0;
	switch(st.st_mode & S_IFMT) {
	  case S_IFREG: {			
	    if((st.st_uid == u) && (st.st_gid == g)) {
	      
	      if(!(st.st_mode & 077)) {	
	        can_use_file = 1;
	      }
	    }
	  } break;
	}
      } else {				
        can_use_file = 1;
      }
    }
#else
    {
      struct stat st;
      if(stat(uac->seedname, &st) == 0) {	
        can_use_file = 0;
	switch(st.st_mode & S_IFMT) {
	  case S_IFREG: {			
	    if((st.st_uid == u) && (st.st_gid == g)) {
	      
	      if(!(st.st_mode & 077)) {	
	        can_use_file = 1;
	      }
	    }
	  } break;
	}
      } else {				
        can_use_file = 1;
      }
    }
#endif
    if(can_use_file) {		
      fipo = fopen(uac->seedname, "w");
      if(fipo) {		
        fputc('\n', fipo);
        fclose(fipo);
	chmod(uac->seedname, 0700);
	RAND_write_file(uac->seedname);
      }
    }
  } 
}



/**	Attempt to read random seed data from one file or device.
	@param	uac	UAC structure.
	@param	fn	File name.
	@return	1 on success, 0 on error.
*/
static
int
attempt_rand DK_P2(UAC *,uac, char *,fn) {
  int back = 0;
  int have_stat = 0;
  int perms = 0;
  uid_t u;
  gid_t g;
#if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE
  struct stat64 st;
  if(stat64(fn, &st) == 0) {
    have_stat = 1;
    perms = st.st_mode;
    u = st.st_uid;
    g = st.st_gid;
  }
#else
  struct stat st;
  if(stat(fn, &st) == 0) {
    have_stat = 1;
    perms = st.st_mode;
    u = st.st_uid;
    g = st.st_gid;
  }
#endif
  
  if(have_stat) {			
    switch(perms & S_IFMT) {
      case S_IFCHR: case S_IFBLK: {	
        RAND_load_file(fn, 1024);
	if(RAND_status() == 1) { back = 1; }
      } break;
      case S_IFSOCK: {			
        RAND_egd(fn);
	if(RAND_status() == 1) { back = 1; }
      } break;
      case S_IFREG: {			
        if(!(perms & (077))) {		
	  RAND_load_file(fn, -1L);
	  if(RAND_status() == 1) { back = 1; }
	}
      } break;
    }
  } 
  return back;
}



int
uat_get_seed DK_P1(UAC *,uac) {
  int back = 0;
  char *ptr;
  
  if(uac->seedname) {
    if(attempt_rand(uac, uac->seedname)) {
      if(RAND_status() == 1) { back = 1; }
    }
  } else {
    ptr = getenv(kw[4]);
    if(ptr) {
      if(attempt_rand(uac, ptr)) {
        if(RAND_status() == 1) { back = 1; } 
      }
    }
  }
  if(!back) {
    if(attempt_rand(uac, kw[0])) {
      if(RAND_status() == 1) { back = 1; }
    }
  }
  if(!back) {
    if(attempt_rand(uac, kw[1])) {
      if(RAND_status() == 1) { back = 1; }
    }
  }
  if(!back) {
    ptr = getenv(kw[2]);
    if(ptr) {
      if(attempt_rand(uac, ptr)) {
        if(RAND_status() == 1) { back = 1; }
      }
    } else {
      if(attempt_rand(uac, kw[3])) {
        if(RAND_status() == 1) { back = 1; }
      }
    }
  } 
  return back;
}



int
uat_create_parent DK_P4(UAC *,uac, char *,fn, uid_t,nu, gid_t,ng) {
  char *p1;
  char *p2;
  char *ptr;
  int back = 0;
  
  ptr = fn; p1 = NULL;
  while(*ptr) {
    if(*ptr == '/') {
      p1 = ptr;
    }
    ptr++;
  }
  if(p1) {
    back = 1;
    *p1 = '\0';		
    p2 = NULL;
    do {
      if(p2) {
        p2++;
	p2 = dkstr_chr(p2, '/');
      } else {
        p2 = dkstr_chr(fn, '/');
      }
      if(p2) {
        *p2 = '\0';	
	if(strlen(fn)) {
#if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE
        {
	  struct stat64 st;
	  if(stat64(fn, &st) == 0) {
	    if(!S_ISDIR(st.st_mode)) {
	      back = 0;		
	    }
	  } else {
	    if(mkdir(fn, 0700) == 0) {
	      if(chown(fn, nu, ng)) {
	        back = 0;	
	      }
	    } else {		
	      back = 0;
	    }
	  }
	}
#else
#if DK_HAVE_STAT
	{
	  struct stat st;
	  if(stat(fn, &st) == 0) {
	    if(!S_ISDIR(st.st_mode)) {
	      back = 0;		
	    }
	  } else {
	    if(mkdir(fn, 0700) == 0) {
	      if(chown(fn, nu, ng) != 0) {
	        back = 0;	
	      }
	    } else {		
	      back = 0;
	    }
	  }
	}
#else
#endif
#endif
	}
	*p2 = '/';
      }
    } while(p2);
#if DK_HAVE_STAT64 && DK_HAVE_LARGEFILE64_SOURCE
    {
    }
#else
#if DK_HAVE_STAT
    {
    }
#else
#endif
#endif
    *p1 = '/';
  }
  
  return back;
}



