package DKrause::FigWriter;

use 5.000000;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use DKrause::FigWriter ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('DKrause::FigWriter', $VERSION);

# Preloaded methods go here.

1;
__END__
=head1 NAME

DKrause::FigWriter - Perl extension for writing Fig files

=head1 SYNOPSIS

  use DKrause::FigWriter;

  $fw = DKrause::FigWriter::newCm(16.0, 9.0); # or newInches(...);
  $fw->rectangle( 1.0, 1.0, 15.0, 8.0);
  $fw->arcBox(2.0, 2.0, 14.0, 7.0, 1.0);
  $fw->image(3.0, 3.0, 5.0, 

=head1 DESCRIPTION

=head2 OVERVIEW

This module writes a *.fig file, the same file format as produced by XFig,
jFig and WinFig.

The graphics is constructed in memory and written by a writeFile() or
writeStream() call.

Like for all ``normal'' graphics operations the origin is the
lower left corner, coordinates grow upwards an to the right side.
Angles are in mathematical sense (not clockwise).

=head2 CONSTRUCTORS

The constructors newCm() and newInches() have 2 arguments: width and height
in the given unit.

=head2 GRAPHICS INSTRUCTIONS

=head3 SETUP INSTRUCTIONS

=head4 LAYER CONTROL

The setLayer() method sets the layer to use for all following graphics
instructions.

The layerUp() method goes one layer up.


=head4 COLORS

The defineColor() function defines a new color. The arguments are the
R-, G, and B-value of the color. The function returns the index of the
new color in the color table.

The setPenColor() method chooses a pen color by index.

The setPenColorByName() method chooses a pen color by name (i.e. ``blue.dark'').

The setFillColor() method chooses a fill color by index.

The setFillColorByName() method chooses a fill color by name.

=head4 FILL STYLE

The fill style can be set by using one of the setFillNone(), setFillBlack(),
setFillSaturation(), setFillLeftDiagonal30(), setFillRightDiagonal30(),
setFillCrosshatch30(), setFillLeftDiagonal45(), setFillRightDiagonal45(),
setFillCrosshatch45(), setFillHorizontalBricks(), setFillVerticalBricks(),
setFillHorizontalLines(), setFillVerticalLines(), setFillCrosshatch(),
setFillHorizontalShinglesRight(), setFillHorizontalShinglesLeft(),
setFillVerticalShinglesA(), setFillVerticalShinglesB(), setFillFishScales(),
setFillSmallFishScales(), setFillCircles(), setFillHexagons(),
setFillOctagons(), setFillHorizontalTireTreads() or setFillVerticalTireTreads()
methods.

The setFillSaturation() method has one argument, a numeric value
(multiple of 5). Numbers from 0 to 100 mean colors from black to
fill-color, numbers from 100 to 200 mean colors from fill-color to white.

=head4 DRAW STYLE

The setLineWidth() method sets the linewidth for all following graphics
operations. The argument is the line width in 1/80 inch.

The setLineStyleSolid(), setLineStyleDashed(), setLineStyleDotted(),
setLineStyleDashDotted, setLineStyleDashDoubleDotted() and
setLineStyleDashTripleDotted() methods set the line style for all following
graphics elements.

ThesetLineWidth() method sets the line width for all following
graphics elements.

=head4 LINE JOIN

The setLineJoinMitered(), setLineJoinRounded() and setLineJoinBeveled()
functions can be used to set line join style.

=head4 LINE CAP

The setLineCapButted(), setLineCapRounded() and setLineCapProjecting()
functions can be used to set the line end style.

=head4 ARROW HEADS

The
setArrowheadForwardStick(), setArrwowheadForwardTriangle(),
setArrowheadForwardIndentend, setArrowheadForwardPointed(),
setArrowheadForwardWidthHeight(),
setArrowheadBackwardStick(), setArrwowheadBackwardTriangle(),
setArrowheadBackwardIndentend, setArrowheadBackwardPointed(),
and
setArrowheadBackwardWidthHeight()
methods can be used to set up forward and backward arrows.

The setArrowheadDirections() method chooses where to point an arrowhead:
1=forward, 2=backward, 3=both.

=head4 ANGLE SETUP

The setAngleDegrees() and setAngleRadians() function can be used to
switch between angle unit.

=head4 TEXT SETUP

Use setTextAlignLeft(), setTextAlignCentered() or textAlignRight() to specify
horizontal text align.

The setTextFlagRigid() method make text rigid or not (increasing graphics
element does not change text size). The argument is the new rigid flag value.

The setTextFlagSpecial() method sets the ``special text flag'' for all
following texts. The argument to this function is the new flag value.

The setTextFontPs() method chooses a new PS font for all following texts,
the argument is the font index:

  0 Times Roman
  1 Times Italic
  2 Times Bold
  3 Times Bold Italic
  4 Avantgarde Book
  5 Avantgarde Book Oblique
  6 Avantgarde Demi
  7 Avantgarde Demi Oblique
  8 Bookman Light
  9 Bookman Light Italic
 10 Bookman Demi
 11 Bookman Demi Italic
 12 Courier
 13 Courier Oblique
 14 Courier Bold
 15 Courier Bold Oblique
 16 Helvetica
 17 Helvetica Oblique
 18 Helvetica Bold
 18 Helvetica Bold Oblique
 20 Helvetica Narrow
 21 Helvetica Narrow Oblique
 22 Helvetica Narrow Bold
 23 Helvetica Narrow Bold Oblique
 24 New Century Schoolbook Roman
 25 New Century Schoolbook Italic
 26 New Century Schoolbook Bold
 27 New Century Schoolbook BOld Oblique
 28 Palatino Roman
 29 Palatino Italic
 30 Palatino Bold
 31 Palatino BOld Italic
 32 Symbol
 33 Zapf Chancery Medium Italic
 34 Zapf Dingbats

The setTextFontPsByName() method allows to choose a text font by name,
i.e. ``Times Roman''.

The setTextFontLatex() method chooses a LaTeX font for all following texts,
0=default, 1=roman, 2=bold, 3=italic, 4=sans-serif, 5=typewriter.

The setTextSize() method specifies the text size in PS points.

The setutf8() method specifies whether or not the texts apecified to text
functions are UTF-8 encoded or not. The argument to the function is the
new UTF-8 flag.

=head3 GRAPHICS ELEMENTS INSTRUCTIONS

=head4 RECTANGLE

Use the rectangle() method to draw a rectangle. The arguments are
x0, y0, x1, y1.

=head4 ARCBOX (rectangle with rounded corners)

Use the arcBox() method to draw a rectangle with rounded corners.
The arguments are x0, y0, x1, y1 and r (corner radius).

=head4 IMAGE

The image method places an included image. The arguments are
x0, y0, x1, y1 and the image file name.

=head4 POLYGONS AND POLYLINES

The polygon() method starts a new polygon, the polyline() method starts a 
new polyline.

The point() method adds yet another point to the polygon/polyline.
The arguments are x and y.

=head4 SPLINES

The splineOpen() method starts a new open spline, the splineClosed()
method starts a new closed spline.

The splinePoint() method adds yet another point to the spline. The arguments
are x, y, and s. The s parameter is in the range -1...+1.
-1 means ``Curve goes through point smoothely'', 0 means ``curve goest through
the point but has a break in the point'', 1 means 
``curve is near to the point''.

=head4 ARCS

The arcOpen() method adds an open arc, parameters are x, y, r, a0 (start
angle) and a1 (end angle). The angle is given in radians or degree,
whatever you have set up before.

The arcClosed() method adds a closed arc.

=head4 CIRCLES AND ELLIPSES

The circle() method draws a circle, the arguments are x, y and r.

The ellipse() method draws an ellipse, the arguments are x, y, rx, ry
and a rotation angle.

=head4 TEXT

The text() method draws text. The parameters are x, y, the text to draw
and the rotation angle.

=head4 LOG MESSAGES

The setVerbose() method sets the module in verbose mode (the argument is the
new verbose flag).

=head4 OUTPUT

The writeFile() method writes the graphics to the file specified as argument.

The writeStream() method writes the graphics to the DKr4ause::Stream
object specified as argument.

=head2 EXPORT

None by default.

=head1 AUTHOR

Dirk Krause, E<lt>krause@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

=cut
