package DKrause::LaTeXEncoder;

use 5.000000;
use strict;
use warnings;

require Exporter;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use DKrause::LaTeXEncoder ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

our $VERSION = '0.01';

require XSLoader;
XSLoader::load('DKrause::LaTeXEncoder', $VERSION);

# Preloaded methods go here.

1;
__END__

=head1 NAME

DKrause::LaTeXEncoder - Perl extension for encoding text to LaTeX

=head1 SYNOPSIS

  use DKrause::LaTeXEncoder;

  $le = DKrause::LaTeXEncoder::new("/usr/local/share/uc2lat-t");

  $s = $le->convert("c:\\windows\\system32\\my_dir.dat");

=head1 DESCRIPTION

=head2 OVERVIEW

This module encodes ASCII text to the corresponding LaTeX command.
Some characters (i.e. ``_'') can not be used directly in LaTeX,
the appropriate LaTeX code must be used (i.e. ``\textunderscore{}'').

=head2 SETUP

The argument to the constructor is a directory containing
Unicode-to-LaTeX translation tables.

=head2 INPUT ENCODING

The setutf8() method can be used to specifiy input encoding, the argument
is either 1 (UTF-8 encoding) or 0 (ISO-LATIN-1 encoding).

=head2 CONVERSION

The convert() method converts the text given as argument to the corresponding
LaTeX code.

=head2 EXPORT

None by default.

=head1 SEE ALSO

=head1 AUTHOR

Dirk Krause, E<lt>krause@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2010 by Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

=cut
