/*
Copyright (c) 1998-2005, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  its contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#ifndef DK_TRACE_INC
#define DK_TRACE_INC 1


#ifdef EXTERN
#undef EXTERN
#endif
#ifndef DK_TRACE_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#define DK_PR(a) a

EXTERN void  dktrace_end    DK_PR((void)) ;
EXTERN void  dktrace_init   DK_PR((char *filename)) ;
EXTERN FILE *dktrace_file   DK_PR((void)) ;
EXTERN void  dk_trace_end    DK_PR((void)) ;
EXTERN void  dk_trace_init   DK_PR((char *filename)) ;
EXTERN FILE *dk_trace_file   DK_PR((void)) ;
EXTERN void  dktrace_time    DK_PR((void));
EXTERN void  dk_trace_time   DK_PR((void));
EXTERN void  dktrace_stdout_time DK_PR((void));
#ifdef __cplusplus
}
#endif
/* ifdef __cplusplus */

#define TR_STR(x)	((x) ? (x) : "(NULL)")
#define TR_PTR(x)	((x) ? "PTR" : "(NULL)")

#endif
/* ifndef DK_TRACE_INC */

