:

# ##### Start of configuration section

#
# YOU MUST CORRECT AT LEAST DKT_ARCH TO REFLECT YOUR SYSTEMS ARCHITECTURE!
#

DKT_PKG_INSTALL_ROOT=
DKT_PREFIX=/usr/local
DKT_SYSCONFDIR=/etc
DKT_LOCALSTATEDIR=/var
DKT_ARCH=sparc

# When installing the packa the files go to the following locations:
# binary files         ${DKT_PKG_INSTALL_ROOT}${DKT_PREFIX}/bin (or sbin)
# libraries	       ${DKT_PKG_INSTALL_ROOT}${DKT_PREFIX}/lib
# include files:       ${DKT_PKG_INSTALL_ROOT}${DKT_PREFIX}/include
# configuration files: ${DKT_PKG_INSTALL_ROOT}${DKT_SYSCONFDIR}

# If default settings above are not changed, the directories are:
# /usr/local/bin (and /usr/local/sbin)
# /usr/local/lib
# /usr/local/include
# /etc

# ##### End of configuration section

SRCDIR=`pwd`
VERSION=`cat version.txt`
PKGTMP=$SRCDIR/pkg/dktools
[ -d "$PKGTMP" ] || mkdir -p "$PKGTMP"
chmod 755 "$PKGTMP"
touch destdir.dat

# The --with-rpm is correct here. Do not remove it.
./configure \
	--prefix=$DKT_PREFIX \
	--sysconfdir=$DKT_SYSCONFDIR \
	--localstatedir=$DKT_LOCALSTATEDIR \
	--with-lzw \
	--with-rpm

export DESTDIR="$PKGTMP"
make DESTDIR="$PKGTMP" install
cat - > "$PKGTMP"/pkginfo <<EOF
PKG=DKtools
NAME=Dirk Krauses tools and libraries
ARCH=$DKT_ARCH
VERSION=$VERSION
CATEGORY=application
VENDOR=Dirk Krause
PSTAMP=Dirk Krause
CLASSES=none
EOF
if [ "X$DKT_PKG_INSTALL_ROOT" != "X" ]
then
  echo "BASEDIR=$DKT_PKG_INSTALL_ROOT" >> "$PKGTMP"/pkginfo
fi

cat - > "$PKGTMP"/postinstall <<MY_EOF
PI_PREFIX=$DKT_PREFIX
PI_ETC=$DKT_SYSCONFDIR
if [ "X$PKG_INSTALL_ROOT" != "X" ]
then
PI_PREFIX="\${PKG_INSTALL_ROOT}\${PI_PREFIX}"
PI_ETC="\${PKG_INSTALL_ROOT}\${PI_ETC}"
fi
cat - > \${PI_ETC}/appdefaults << PI_EOF
[*]
# -- The decision about language, region and encoding
# -- is left up to the LANG environment variable now.
# /ui/lang		=	en
# /ui/lang		=	de
# /ui/lang/env		=	off
/dir/tmp		=	\\\$(user.home)/tmp
/log/file/name		=	\\\$(temp.dir)/\\\$(app.name).\\\$(process.pid).log
/log/file/level		=	progress
/log/file/keep		=	error
/log/file/time		=	on
/log/file/split		=	on
/log/stdout/level	=	none
/log/stdout/time	=	off
/log/stderr/level	=	error
/log/stderr/time	=	off
/log/stderr/split	=	off
/dir/app=\${PI_PREFIX}/share/\$(app.name)
/dir/shared=\${PI_PREFIX}/share
PI_EOF
MY_EOF

cat - > "$PKGTMP"/preremove <<MY_EOF
PI_PREFIX=$DKT_PREFIX
PI_ETC=$DKT_SYSCONFDIR
if [ "X$PKG_INSTALL_ROOT" != "X" ]
then
PI_PREFIX="\${PKG_INSTALL_ROOT}\${PI_PREFIX}"
PI_ETC="\${PKG_INSTALL_ROOT}\${PI_ETC}"
fi
rm -fr \${PI_ETC}/appdefaults
MY_EOF

cd "$PKGTMP"
perl "$SRCDIR"/dkmkproto.pl
pkgmk -o -d ..
cd ..
pkgtrans -s `pwd` "$SRCDIR"/dktools-$VERSION DKtools
cd "$SRCDIR"


