/*
Copyright (c) 2008-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include "dkbif.h"
#include "dkbifi.h"
#include "pnm.h"

#include "dkstr.h"

static
void
run_for(char *filename)
{
  FILE *f;
  int rows = 0, cols = 0, format = 0;
  xel **array;
  xelval maxxelval;
  f = dksf_fopen(filename, "rb");
  if(f) {
    pnm_readpnminit(f,&cols,&rows,&maxxelval,&format);
    printf(
      "%s: w=%d h=%d max=%d format=%d\n",
      filename, cols, rows, maxxelval, format
    );
    fclose(f); f = NULL;
  } else {
    printf("%s: ERROR: Failed to open file!\n", filename);
  }
}


static char buffer[4096];

int main(int argc, char *argv[])
{
  char *p;
  int i;
  if(argc > 1) {
    for(i = 1; i < argc; i++) { run_for(argv[i]); }
  } else {
    while(fgets(buffer, sizeof(buffer), stdin)) {
      p = dkstr_start(buffer, NULL);
      if(p) {
        dkstr_chomp(p, NULL);
	run_for(p);
      }
    }
  }
  exit(0); return 0;
}



