/*
Copyright (c) 2001-2010, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>

#include <dk.h>
#include <dksf.h>



/**	@file	tabrep.c	The tabrep program.
*/




/* ********************************************************************* */
/* *                                                                   * */
/* *   Tabrep - tabulator repositioning                                * */
/* *                                                                   * */
/* *   tabrep                                                          * */
/* *   tabrep <inputfile>                                              * */
/* *   tabrep <inputfile> <outputfile>                                 * */
/* *                                                                   * */
/* *   The tabrep program replaces tabulator by                        * */
/* *   one or multiple spaces.                                         * */
/* *   The purpose is to insert C sources into                         * */
/* *   verbatim environments of TeX.                                   * */
/* *                                                                   * */
/* ********************************************************************* */

#line 62 "tabrep.ctr"




/**	Exit status.
*/
static int exval = 1;



/**	Input buffer.
*/
static char buffer[16384];



/**	Run for opened input and output file.
	@param	in	Input file.
	@param	out	Output file.
*/
static
void
run_for_files DK_P2(FILE *,in, FILE *,out)
{
  int   position;
  size_t sz;
  int can_continue; int i;
  can_continue = 1; position = 0; exval = 0;
  while(can_continue) {
    sz = fread(buffer,sizeof(char),sizeof(buffer),in);
    if(sz > 0) {
      for(i = 0; i < ((int)sz); i++) {
	switch(buffer[i]) {
	  case '\r':
	  case '\n':
	  {
	    fputc(buffer[i], out); position = 0;
	  } break;
	  case '\t': {
	    fputc(' ', out); position++;
	    while(position % 8) { fputc(' ', out); position++; }
	  } break;
	  default: {
	    fputc(buffer[i], out); position += 1;
	  } break;
	}
      }
    } else {
      can_continue = 0;
    }
  }
}



/**	The main() function of the tabrep program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
#if DK_HAVE_PROTOTYPES
int main(int argc, char *argv[])
#else
int main(argc, argv) int argc; char *argv[];
#endif
{
  switch(argc) {
    case 1: {
      run_for_files(stdin, stdout);
    } break;
    case 2: {
      FILE *inputfile;
      inputfile = dksf_fopen(argv[1], "r");
      if(inputfile) {
	run_for_files(inputfile, stdout);
	fclose(inputfile);
      }
    } break;
    case 3: {
      FILE *inputfile, *outputfile;
      inputfile = dksf_fopen(argv[1], "r");
      if(inputfile) {
	outputfile = dksf_fopen(argv[2], "w");
	if(outputfile) {
	  run_for_files(inputfile, outputfile);
	  fclose(outputfile);
	}
      }
    } break;
  }
  exit(exval); return exval;
}

