<?php

/************************************************************************/
/* DOCEBO LMS - Learning Managment System                               */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2004                                                   */
/* http://www.docebo.com                                                */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if(!defined('IN_DOCEBO')) die('You cannot access this file directly');

require_once( dirname(__FILE__).'/class.question.php' );

class TextEntry_Question extends Question {
	
	function TextEntry_Question( $id ) {
		parent::Question( $id );
	}
	
	function getQuestionType() {
		return 'text_entry';
	}
	
	/**
	 * function create()
	 *
	 * @param $back_url	the url where the function retutn at the end of the operation
	 * @return nothing
	 */
	function create( $idTest, $back_test ) {
		$lang =& DoceboLanguage::createInstance('test');
		
		require_once($GLOBALS['where_framework'].'/lib/lib.form.php');
		$url_encode = htmlentities(urlencode($back_test));
		
		if(isset($_POST['add_question'])) {
			//insert question
			if(substr_count($_POST['title_quest'], '[answer]') != 1) {
				errorCommunication($lang->def('_TEST_ERR_BAD_ANSWER_TAG')
					.getBackUi('index.php?modname=question&amp;op=create&amp;type_quest='
					.$this->getQuestionType().'&amp;idTest='.$idTest.'&amp;back_test='.$url_encode, $lang->def('_BACK')));
			}
			$ins_query = "
			INSERT INTO ".$GLOBALS['prefix_lms']	."_testquest 
			( idTest, idCategory, type_quest, title_quest, difficult, time_assigned, sequence, page ) VALUES 
			( 	'".(int)$idTest."', 
				'".(int)$_POST['idCategory']."', 
				'".$this->getQuestionType()."', 
				'".$_POST['title_quest']."',
				'".(int)$_POST['difficult']."', 
				'".(int)$_POST['time_assigned']."', 
				'".$this->_getNextSequence($idTest)."', 
				'".$this->_getPageNumber($idTest)."' ) ";
			if(!mysql_query($ins_query)) {
				
				errorCommunication($lang->def('_TEST_ERR_INS_QUEST')
					.getBackUi('index.php?modname=question&amp;op=create&amp;type_quest='
					.$this->getQuestionType().'&amp;idTest='.$idTest.'&amp;back_test='.$url_encode, $lang->def('_BACK')));
			}
			
			//find id of auto_increment colum
			list($idQuest) = mysql_fetch_row(mysql_query("SELECT LAST_INSERT_ID()"));
			if(!$idQuest) {
				errorCommunication($lang->def('_TEST_ERR_INS_ANSWER')
					.getBackUi(ereg_replace('&', '&amp;', $back_test), $lang->def('_BACK')));
			}
			
			//insert answer
			$ins_answer_query = "
			INSERT INTO ".$GLOBALS['prefix_lms']	."_testquestanswer 
			( idQuest, is_correct, answer, comment, score_correct, score_incorrect ) VALUES 
			( 	'".$idQuest."', 
				'1', 
				'".strtolower($_POST['answer'])."', 
				'".$_POST['comment']."', 
				'".$this->_checkScore($_POST['score_correct'])."', 
				'".$this->_checkScore($_POST['score_incorrect'])."' ) ";
			if(!mysql_query($ins_answer_query)) {
				
				errorCommunication($lang->def('_TEST_ERR_INS_ANSWER')
					.getBackUi(ereg_replace('&', '&amp;', $back_test), $lang->def('_BACK')));
			}
			//back to question list
			jumpTo($back_test);
		}
		//category form
			require_once($GLOBALS['where_lms'].'/lib/lib.questcategory.php');
			$categories = Questcategory::getCategory();
		//writing difficult array
		$arr_dufficult = array(5 => '5 - '.$lang->def('_VERY_HARD'), 4 => '4 - '.$lang->def('_HARD'), 3 => '3 - '.$lang->def('_MEDIUM'), 2 => '2 - '.$lang->def('_EASY'), 1 => '1 - '.$lang->def('_VERY_EASY'));
		
		$GLOBALS['page']->add(getTitleArea($lang->def('_TEST_SECTION'), 'test')
			.'<div class="std_block">'
			.getBackUi(ereg_replace('&', '&amp;', $back_test), $lang->def('_BACK'))
			.'<div class="title_big">'
			.$lang->def('_QUEST_ACRN_'.strtoupper($this->getQuestionType())).' - '
			.$lang->def('_QUEST_'.strtoupper($this->getQuestionType()))
			.'</div><br />'
			.Form::openForm('form_add_quest', 'index.php?modname=question&amp;op=create')
		
			.Form::openElementSpace()
			.Form::getHidden('type_quest', 'type_quest', $this->getQuestionType())
			.Form::getHidden('idTest', 'idTest', $idTest)
			.Form::getHidden('back_test', 'back_test', $url_encode)
		
			.Form::getTextarea($lang->def('_TEST_QUEST_TITLE'), 'title_quest', 'title_quest', '[answer]'), 'content');
		if (count($categories) > 1)
			$GLOBALS['page']->add( Form::getDropdown($lang->def('_TEST_QUEST_CATEGORY'), 'idCategory', 'idCategory', $categories), 'content');
		
		$GLOBALS['page']->add(Form::getDropdown( $lang->def('_TEST_DIFFICULT'), 'difficult', 'difficult', $arr_dufficult, 3)
			.Form::getTextfield( $lang->def('_TEST_QUEST_TIMEASS'), 'time_assigned', 'time_assigned', 5, 
			( isset($_POST['time_assigned']) ? $_POST['time_assigned'] : '00000' ), $lang->def('_TEST_QUEST_TIMEASS'),
			$lang->def('_TIME_SECOND') )
			.'<div class="no_float"></div><br />'
			.'<table class="test_answer"  summary="'.$lang->def('_TEST_ANSWER_SUMMARY').'">'."\n"
			.'<caption>'.$lang->def('_TEST_ANSWER').'</caption>'."\n"
			.'<tr>'
			.'<th class="image">'.$lang->def('_TEST_CORRECT').'</th>'
			.'<th><label for="answer">'.$lang->def('_TEST_TEXT_ANSWER').'</label></th>'
			.'<th><label for="comment">'.$lang->def('_TEST_COMMENT').'</label></th>'
			.'<th colspan="2">'.$lang->def('_TEST_POINT').'</th>'
			.'</tr>'."\n"
			.'<tr class="line_answer">'
			.'<td rowspan="2" class="align_center">'
			//img si correct
			.'<img src="'.getPathImage().'test/correct.gif" alt="'.$lang->def('_TEST_ISCORRECT').'" />'
			.'</td>'
			.'<td rowspan="2">'
			//answer
			.'<input type="text" class="test_text_answer" id="answer" name="answer" alt="'.$lang->def('_TEST_TEXT_ANSWER').'" maxlength="255" value="'./*$lang->def('_QUEST_ANSWER').*/'" />'
			.'</td>'
			.'<td rowspan="2" class="image">'
			//comment
			.'<textarea class="test_comment" id="comment" name="comment" cols="14" rows="3">'./*$lang->def('_QUEST_COMMENT').*/'</textarea>'
			.'</td>'
			.'<td class="test_ifcorrect">'
			.'<label for="score_correct">'.$lang->def('_TEST_IFCORRECT').'</label>'
			.'</td>'
			.'<td class="align_right">'
			//score correct
			.'<input type="text" class="test_point" id="score_correct" name="score_correct" alt="'.$lang->def('_TEST_IFCORRECT').'" size="5" value="0.0" />'
			.'</td>'
			.'</tr>'."\n"
			.'<tr class="line_answer">'
			.'<td class="test_ifcorrect">'
			.'<label for="score_incorrect">'.$lang->def('_TEST_IFINCORRECT').'</label>'
			.'</td>'
			.'<td class="align_right">'
			//score incorrect
			.'- <input type="text" class="test_point" id="score_incorrect" name="score_incorrect" alt="'.$lang->def('_TEST_IFINCORRECT').'" size="5" value="0.0" />'
			.'</td>'
			.'</tr>'."\n"
			.'</table>'
			.Form::closeElementSpace()
		
			.Form::openButtonSpace()
			.Form::getButton('add_question', 'add_question', $lang->def('_SAVE'))
			.Form::closeButtonSpace()
		
			.Form::closeForm()
			.'</div>', 'content');
	}
	
	/**
	 * function edit()
	 *
	 * @param $back_url	the url where the function retutn at the end of the operation
	 * @return nothing
	 */
	function edit( $back_test ) {
		$lang =& DoceboLanguage::createInstance('test');
		
		require_once($GLOBALS['where_framework'].'/lib/lib.form.php');
		$url_encode = htmlentities(urlencode($back_test));
		
		if(isset($_POST['add_question'])) {
			//modify question
			if(substr_count($_POST['title_quest'], '[answer]') != 1) {
				errorCommunication($lang->def('_TEST_ERR_BAD_ANSWER_TAG')
					.getBackUi('index.php?modname=question&amp;op=create&amp;type_quest='
					.$this->getQuestionType().'&amp;idQuest='.$this->id.'&amp;back_test='.$url_encode, $lang->def('_BACK')));
			}
			
			$mod_query = "
			UPDATE ".$GLOBALS['prefix_lms']	."_testquest 
			SET idCategory = '".$_POST['idCategory']."', 
				type_quest = '".$this->getQuestionType()."', 
				title_quest = '".$_POST['title_quest']."', 
				difficult = '".$_POST['difficult']."',
				time_assigned = '".$_POST['time_assigned']."'
			WHERE idQuest = '".(int)$this->id."'";
			if(!mysql_query($mod_query)) {
				
				errorCommunication($lang->def('_TEST_ERR_MOD_QUEST')
					.getBackUi('index.php?modname=question&amp;op=edit&amp;type_quest='
					.$this->getQuestionType().'&amp;idQuest='.$this->id.'&amp;back_test='.$url_encode, $lang->def('_BACK')));
			}
			//modify answer
			$mod_answer_query = "
			UPDATE ".$GLOBALS['prefix_lms']	."_testquestanswer 
			SET answer = '".strtolower($_POST['answer'])."',
				comment = '".$_POST['comment']."',
				score_correct = '".$this->_checkScore($_POST['score_correct'])."', 
				score_incorrect = '".$this->_checkScore($_POST['score_incorrect'])."'
			WHERE idQuest = '".(int)$this->id."'";
			if(!mysql_query($mod_answer_query)) {
				
				errorCommunication($lang->def('_TEST_ERR_INS_ANSWER')
					.getBackUi(ereg_replace('&', '&amp;', $back_test), $lang->def('_BACK')));
			}
			//back to quest list
			jumpTo( ''.$back_test);
		}
		//finding categories
				require_once($GLOBALS['where_lms'].'/lib/lib.questcategory.php');
			$categories = Questcategory::getCategory();
		//create array of difficult
		$arr_dufficult = array(5 => '5 - '.$lang->def('_VERY_HARD'), 4 => '4 - '.$lang->def('_HARD'), 3 => '3 - '.$lang->def('_MEDIUM'), 2 => '2 - '.$lang->def('_EASY'), 1 => '1 - '.$lang->def('_VERY_EASY'));
		//load data
		list($cat_sel, $title_quest, $diff_sel, $sel_time) = mysql_fetch_row(mysql_query("
		SELECT idCategory, title_quest, difficult, time_assigned
		FROM ".$GLOBALS['prefix_lms']	."_testquest 
		WHERE idQuest = '".(int)$this->id."'"));
		list($answer, $comment, $score_correct, $score_incorrect) = mysql_fetch_row(mysql_query("
		SELECT answer, comment, score_correct, score_incorrect 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'"));
		
		//drawing form
		$GLOBALS['page']->add(
			getTitleArea($lang->def('_TEST_SECTION'), 'test')
			.'<div class="std_block">'
			.getBackUi(ereg_replace('&', '&amp;', $back_test), $lang->def('_BACK'))
			.'<div class="title_big">'
			.$lang->def('_QUEST_ACRN_'.strtoupper($this->getQuestionType())).' - '
			.$lang->def('_QUEST_'.strtoupper($this->getQuestionType()))
			.'</div><br />'
			.Form::openForm('form_mod_quest', 'index.php?modname=question&amp;op=edit')
		
			.Form::openElementSpace()
			.Form::getHidden('type_quest', 'type_quest', $this->getQuestionType())
			.Form::getHidden('idQuest', 'idQuest', $this->id)
			.Form::getHidden('back_test', 'back_test', $url_encode)
		
			.Form::getTextarea($lang->def('_TEST_QUEST_TITLE'), 'title_quest', 'title_quest', $title_quest), 'content');
		if (count($categories) > 1)
			$GLOBALS['page']->add(Form::getDropdown( $lang->def('_TEST_QUEST_CATEGORY'), 'idCategory', 'idCategory', $categories,
				( isset($_POST['idCategory']) ? $_POST['idCategory'] : $cat_sel )), 'content');
		
		$GLOBALS['page']->add(Form::getDropdown( $lang->def('_TEST_DIFFICULT'), 'difficult', 'difficult', $arr_dufficult, $diff_sel)
			.Form::getTextfield( $lang->def('_TEST_QUEST_TIMEASS'), 'time_assigned', 'time_assigned', 5, 
				( isset($_POST['time_assigned']) ? $_POST['time_assigned'] : $sel_time ), $lang->def('_TEST_QUEST_TIMEASS'),
			$lang->def('_TIME_SECOND') )
			.'<div class="no_float"></div><br />'
			.'<table class="test_answer"  summary="'.$lang->def('_TEST_ANSWER_SUMMARY').'">'."\n"
			.'<caption>'.$lang->def('_TEST_ANSWER').'</caption>'."\n"
			.'<tr>'."\n"
			.'<th class="image">'.$lang->def('_TEST_CORRECT').'</th>'
			.'<th><label for="answer">'.$lang->def('_TEST_TEXT_ANSWER').'</label></th>'
			.'<th><label for="comment">'.$lang->def('_TEST_COMMENT').'</label></th>'
			.'<th colspan="2">'.$lang->def('_TEST_POINT').'</th>'
			.'</tr>'."\n"
			
			.'<tr class="line_answer">'."\n"
			.'<td rowspan="2" class="align_center">'
			//img is correct
			.'<img src="'.getPathImage().'test/correct.gif" alt="'.$lang->def('_TEST_ISCORRECT').'" />'
			.'</td>'
			.'<td rowspan="2">'
			//answer
			.'<input type="text" class="test_text_anwer" id="answer" name="answer" alt="'.$lang->def('_TEST_TEXT_ANSWER').'" maxlength="255" value="'.$answer.'" />'
			.'</td>'
			.'<td rowspan="2" class="image">'
			//comment
			.'<textarea class="test_comment" id="comment" name="comment" cols="14" rows="3">'.$comment.'</textarea>'
			.'</td>'
			.'<td class="test_ifcorrect">'
			.'<label for="score_correct">'.$lang->def('_TEST_IFCORRECT').'</label>'
			.'</td>'
			.'<td class="align_right">'
			//score correct
			.'<input type="text" class="test_point" id="score_correct" name="score_correct" alt="'.$lang->def('_TEST_IFCORRECT').'" size="5" value="'.$score_correct.'" />'
			.'</td>'
			.'</tr>'."\n"
			.'<tr class="line_answer">'."\n"
			.'<td class="test_ifcorrect">'
			.'<label for="score_incorrect">'.$lang->def('_TEST_IFINCORRECT').'</label>'
			.'</td>'
			.'<td class="align_right">'
			//score incorrect
			.'- <input type="text" class="test_point" id="score_incorrect" name="score_incorrect" alt="'.$lang->def('_TEST_IFINCORRECT').'" size="5"  value="'.$score_incorrect.'" />'
			.'</td>'
			.'</tr>'."\n"
			.'</table>'."\n"
			.Form::closeElementSpace()
		
			.Form::openButtonSpace()
			.Form::getButton('add_question', 'add_question', $lang->def('_SAVE'))
			.Form::closeButtonSpace()
		
			.Form::closeForm()
			.'</div>', 'content');
	}
	
	function del() {
		
		
		//delete answer
		if(!mysql_query("
		DELETE FROM ".$GLOBALS['prefix_lms']	."_testtrack_answer 
		WHERE idQuest = '".$this->id."'")) return false;
		
		//remove answer
		if(!mysql_query("
		DELETE FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".$this->id."'")) {
			return false;
		}
		//remove question
		return mysql_query("
		DELETE FROM ".$GLOBALS['prefix_lms']	."_testquest 
		WHERE idQuest = '".$this->id."'");
	}
	
	/**
	 * this function create a copy of a question and return the corresponding id
	 * 
	 * @return int 	return the id of the new question if success else return false
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function copy( $new_id_test, $back_test = NULL ) {
		
		
		//retriving question
		list($sel_cat, $quest, $sel_diff, $time_ass, $sequence, $page) = mysql_fetch_row(mysql_query("
		SELECT idCategory, title_quest, difficult, time_assigned, sequence, page 
		FROM ".$GLOBALS['prefix_lms']	."_testquest 
		WHERE idQuest = '".(int)$this->id."'"));
		//insert question
		$ins_query = "
		INSERT INTO ".$GLOBALS['prefix_lms']	."_testquest 
		( idTest, idCategory, type_quest, title_quest, difficult, time_assigned, sequence, page ) VALUES 
		( 	'".(int)$new_id_test."', 
			'".(int)$sel_cat."', 
			'".$this->getQuestionType()."', 
			'".mysql_escape_string($quest)."',
			'".(int)$sel_diff."', 
			'".$time_ass."',
			'".(int)$sequence."',
			'".(int)$page."' ) ";
		if(!mysql_query($ins_query)) return false;
		//find id of auto_increment colum
		list($new_id_quest) = mysql_fetch_row(mysql_query("SELECT LAST_INSERT_ID()"));
		if(!$new_id_quest) return false;
		
		//retriving new answer
		$re_answer = mysql_query("
		SELECT idAnswer, is_correct, answer, comment, score_correct, score_incorrect 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'
		ORDER BY idAnswer");
		while(list($idAnswer, $is_correct, $answer, $comment, $score_c, $score_inc) = mysql_fetch_row($re_answer)) {
			
			//insert answer
			$ins_answer_query = "
			INSERT INTO ".$GLOBALS['prefix_lms']	."_testquestanswer 
			( idQuest, is_correct, answer, comment, score_correct, score_incorrect ) VALUES
			( 	'".(int)$new_id_quest."', 
				'".(int)$is_correct."', 
				'".mysql_escape_string($answer)."', 
				'".mysql_escape_string($comment)."',
				'".$this->_checkScore($score_c)."', 
				'".$this->_checkScore($score_inc)."') ";
			if(!mysql_query($ins_answer_query)) return false;
		}
		return $new_id_quest;
	}
	
	/**
	 * display the quest for play, if 
	 * 
	 * @param 	int		$num_quest 			the number of the quest to display in front of the quest title
	 * @param 	bool	$shuffle_answer 	randomize the answer display order
	 * @param 	int		$id_track 			where find the answer, if find -> load
	 * @param 	bool	$freeze 			if true, when load disable the user interaction
	 * 
	 * @return string of html question code
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function play( $num_quest, $shuffle_answer = false, $id_track = 0, $freeze = false ) {
		$lang =& DoceboLanguage::createInstance('test');
		
		list($id_quest, $title_quest) = mysql_fetch_row(mysql_query("
		SELECT idQuest, title_quest 
		FROM ".$GLOBALS['prefix_lms']	."_testquest 
		WHERE idQuest = '".$this->id."'"));
		
		$re_answer = mysql_query("
		SELECT idAnswer, answer 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'
		ORDER BY idAnswer");
		
		$find_prev = false;
		$id_answer_do = 0;
		if($id_track != 0) {
			
			//recover previous information
			$recover_answer = "
			SELECT more_info 
			FROM ".$GLOBALS['prefix_lms']	."_testtrack_answer 
			WHERE idQuest = '".(int)$this->id."' AND 
				idTrack = '".(int)$id_track."'";
			$re_answer_do = mysql_query($recover_answer);
			if(mysql_num_rows($re_answer_do)) {
				
				//find previous answer
				$find_prev = true;
				list($answer_do) = mysql_fetch_row($re_answer_do);
			}
		}
		
		list($id_answer, $answer) = mysql_fetch_row($re_answer);
		$num_char = strlen($answer);
		$text = '<input class="test_te_input" type="text" id="quest_'.$id_quest.'" name="quest['.$id_quest.']" '
				.'maxlength="'.strlen($answer).'" '
				.'value="'.( $find_prev ? $answer_do : str_repeat($lang->def('_QUEST_TE_ANSWERHERE'), $num_char) ).'"'
				.( $find_prev && $freeze ? ' disabled="disabled"' : '' )
				.' />';
		
		
		return '<div class="play_question">'."\n"
            .'<div>'.$lang->def('_QUEST_'.strtoupper($this->getQuestionType())).'</div>'
			.'<div class="title_question">'.$num_quest.') '.$lang->def('_TEST_TE_TITLE').'</div>'."\n"
			.'<div class="answer_question">'
			.'<label for="quest_'.$id_quest.'">'.ereg_replace('\[answer\]', $text, $title_quest).'</label>'
			.'</div>'."\n"
			.'</div>'."\n";
	}
	
	/**
	 * save the answer to the question in an proper format
	 * 
	 * @param  int		$id_track		the relative id_track
	 * @param  array	$source			source of the answer send by the user
	 * @param  bool		$can_overwrite	if the answer for this question exists and this is true, the old answer 
	 *									is updated, else the old answer will be leaved
	 * 
	 * @return bool	true if success false otherwise
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function storeAnswer( $id_track, &$source, $can_overwrite = false ) {
		
		
		$result = true;
		
		if($this->userDoAnswer($id_track)) {
			if($can_overwrite) {
				
				return $this->updateAnswer($id_track, $source);
			}
			else return false;
		}
		
		$re_answer = mysql_query("
		SELECT idAnswer, answer, score_correct, score_incorrect 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'");
		list($id_answer, $answer, $score_corr, $score_incorr) = mysql_fetch_row($re_answer);
		
		if(strtolower($answer) == strtolower(stripslashes($source['quest'][$this->id]))) $is_correct = true;
		else $is_correct = false;
		
		$track_query = "
		INSERT INTO ".$GLOBALS['prefix_lms']	."_testtrack_answer ( idTrack, idQuest, idAnswer, score_assigned, more_info ) 
		VALUES (
			'".(int)$id_track."', 
			'".(int)$this->id."', 
			'".(int)$id_answer."', 
			'".( $is_correct ? $score_corr : -$score_incorr )."', 
			'".$source['quest'][$this->id]."' )";
		return  mysql_query($track_query);
	}
	
	/**
	 * save the answer to the question in an proper format overwriting the old entry
	 * 
	 * @param  int		$id_track	the relative id_track
	 * @param  array	$source		source of the answer send by the user
	 * 
	 * @return bool	true if success false otherwise
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function updateAnswer( $id_track, &$source ) {
		
		
		$re_answer = mysql_query("
		SELECT idAnswer, answer, score_correct, score_incorrect 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'");
		list($id_answer, $answer, $score_corr, $score_incorr) = mysql_fetch_row($re_answer);
		
		if(strtolower($answer) == strtolower(stripslashes($source['quest'][$this->id]))) $is_correct = true;
		else $is_correct = false;
		
		return mysql_query("
		UPDATE ".$GLOBALS['prefix_lms']	."_testtrack_answer 
		SET score_assigned = '".( $is_correct ? $score_corr : -$score_incorr )."', 
			more_info = '".$source['quest'][$this->id]."' 
		WHERE idTrack = '".(int)$id_track."' AND 
			idQuest = '".$this->id."'");
	}
	
	/**
	 * delete the old answer
	 * 
	 * @param  int		$id_track	the relative id_track
	 * 
	 * @return bool	true if success false otherwise
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function deleteAnswer( $id_track ) {
		
		
		return mysql_query("
		DELETE FROM ".$GLOBALS['prefix_lms']	."_testtrack_answer 
		WHERE idTrack = '".(int)$id_track."' AND 
			idQuest = '".$this->id."'");
	}
	
	/**
	 * get the method used to obtain result automatic or manual
	 * 
	 * @return string 	contain one of these value :
	 *					'none' if the question doesn't return any score (such as title or break_page)
	 *					'manual' if the score is set by a user, 
	 *					'auto' if the system automatical assign a result
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function getScoreSetType() {
		
		
		return 'auto';
	}
	
	/**
	 * display the question with the result of a user
	 * 
	 * @param  	int		$id_track		the test relative to this question
	 * @param  	int		$num_quest		the quest sequqnce number
	 * 
	 * @return array	return an array with xhtml code in this way
	 * 					string	'quest' 	=> the quest, 
	 *					double	'score'		=> score obtained from this question, 
	 *					string	'comment'	=> relative comment to the quest )
	 * 
	 * 
	 * @access public
	 * @author Fabio Pirovano (fabio@docebo.com)
	 */
	function displayUserResult( $id_track, $num_quest, $show_solution ) {
		$lang =& DoceboLanguage::createInstance('test');
		
		$quest = '';
		$comment = '';
		$com_is_correct = '';
		
		list($id_quest, $title_quest) = mysql_fetch_row(mysql_query("
		SELECT idQuest, title_quest 
		FROM ".$GLOBALS['prefix_lms']	."_testquest 
		WHERE idQuest = '".$this->id."'"));
		
		$re_answer = mysql_query("
		SELECT idAnswer, answer, comment 
		FROM ".$GLOBALS['prefix_lms']	."_testquestanswer 
		WHERE idQuest = '".(int)$this->id."'
		ORDER BY idAnswer");
		
		//recover previous information
		$recover_answer = "
		SELECT more_info 
		FROM ".$GLOBALS['prefix_lms']	."_testtrack_answer 
		WHERE idQuest = '".(int)$this->id."' AND 
			idTrack = '".(int)$id_track."'";
		list($answer_do) = mysql_fetch_row(mysql_query($recover_answer));
		
		list($id_answer, $answer, $com) = mysql_fetch_row($re_answer);
		
		
		$text = '<span class="text_bold">'.( trim($answer_do) != '' ? $answer_do : $lang->def('_EMPTY_ANSWER') ).'</span>';
		if(strtolower($answer_do) == strtolower($answer)) {
			$text .= ' <strong class="test_answer_correct">'.$lang->def('_TEST_CORRECT').'</strong>';
		} else {
			$text .= ' <strong class="test_answer_incorrect">'.$lang->def('_TEST_INCORRECT').'</strong>';
			if($show_solution) $com_is_correct = '<strong>'.$lang->def('_TEST_ISNOT_THECORRECT').' : </strong>'.$answer;
			$comment = $com;
		}
		
		$quest = '<div class="play_question">'."\n"
			.'<div class="title_question">'.$num_quest.') '.$lang->def('_TEST_TE_TITLE').'</div>'."\n"
			.'<div class="answer_question">'
			.str_replace('[answer]', $text, $title_quest)
			.'</div>'."\n"
			.'</div>'."\n";
		
		return array(	'quest' 	=> $quest, 
						'score'		=> $this->userScore($id_track), 
						'comment'	=> ( $com_is_correct != '' ? $com_is_correct.'<br />' : '' ).$comment );
		
	}
}

?>
