/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.logging.Logger;

public class Graphics2D {
    private Font font;
    private Graphics g;
    private int trans;

    public Graphics2D(Graphics g) {
        this.setGraphics(g);
        this.font = Font.getDefaultSystemFont();
    }

    public int getColor() {
        return this.g.getColor();
    }

    public void setTransform(int t) {
        this.trans = t;
    }

    public void setColor(int c) {
        if (Graphics2D.isTransparent(c)) {
            Logger.warn("trying to set a transparent color: " + Integer.toHexString(c));
            Logger.dumpStack();
        }
        this.g.setColor(c);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.g.drawRect(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w));
    }

    public void fillRect(int x, int y, int w, int h) {
        this.g.fillRect(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(this.convertTrans(x1, y1), this.convertTrans(y1, x1), this.convertTrans(x2, y2), this.convertTrans(y2, x2));
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.g.fillTriangle(this.convertTrans(x1, y1), this.convertTrans(y1, x1), this.convertTrans(x2, y2), this.convertTrans(y2, x2), this.convertTrans(x3, y3), this.convertTrans(y3, x3));
    }

    public void drawRegion(Image src, int x_src, int y_src, int width, int height, int x_dest, int y_dest) {
        int x1 = this.convertTrans(x_dest, y_dest);
        int y1 = this.convertTrans(y_dest, x_dest);
        int x = x_src;
        int y = y_src;
        int w = width;
        int h = height;
        if (w <= 0 || h <= 0) {
            Logger.warn("trying to draw Region with width=" + w + " height=" + h);
            Logger.dumpStack();
        }
        this.g.drawRegion(src, x, y, w, h, this.trans, x1, y1, 20);
    }

    public void drawImage(Image src, int x, int y) {
        this.drawRegion(src, 0, 0, src.getWidth(), src.getHeight(), x, y);
    }

    public void drawImage(Image img, int src_x, int src_y, int src_w, int src_h, int dest_x, int dest_y, int dest_w, int dest_h) {
        int tile;
        int pos_y;
        if (src_w <= 0 || src_h <= 0 || dest_w <= 0 || dest_h <= 0) {
            return;
        }
        int[] c = this.getClip();
        this.clipRect(dest_x, dest_y, dest_w, dest_h);
        int start_x = dest_x >= c[0] ? dest_x : dest_x + (c[0] - dest_x) / src_w * src_w;
        int start_y = dest_y >= c[1] ? dest_y : dest_y + (c[1] - dest_y) / src_h * src_h;
        int end_x = dest_x + dest_w <= c[0] + c[2] ? dest_x + dest_w : c[0] + c[2];
        int end_y = dest_y + dest_h <= c[1] + c[3] ? dest_y + dest_h : c[1] + c[3];
        for (int pos_x = start_x; pos_x < end_x; pos_x += src_w) {
            for (pos_y = start_y; pos_y < end_y; pos_y += src_h) {
                this.drawRegion(img, src_x, src_y, src_w, src_h, pos_x, pos_y);
            }
        }
        this.setClip(c);
        if (Midlet.getPlatform() != 8 && (tile = (end_x - start_x) / src_w * ((end_y - start_y) / src_h)) > 15) {
            Logger.info("going to tile a very small image " + tile + " times: src_w=" + src_w + " src_h=" + src_h + " dest_w=" + dest_w + " dest_h=" + dest_h);
            if (tile > 30) {
                Logger.info("###########################################################");
                this.g.setColor(new Random().nextInt());
                for (int pos_x = start_x; pos_x < end_x; pos_x += src_w) {
                    this.g.drawLine(pos_x, start_y, pos_x, end_y);
                }
                for (pos_y = start_y; pos_y < end_y; pos_y += src_h) {
                    this.g.drawLine(start_x, pos_y, end_x, pos_y);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScaledImage(Image img, int x, int y, int w, int h) {
        try {
            Class.forName("javax.microedition.m3g.Background");
            int maxView = Integer.MAX_VALUE;
            try {
                Object o = Graphics3D.getProperties().get("maxViewportDimension");
                maxView = (Integer)o;
            }
            catch (Throwable e) {
                // empty catch block
            }
            Image2D image2D = new Image2D(99, (Object)img);
            Background background = new Background();
            background.setColor(-52);
            background.setImage(image2D);
            Graphics3D iG3D = Graphics3D.getInstance();
            try {
                iG3D.bindTarget((Object)this.g, true, 8);
                iG3D.setViewport(x, y, Math.min(maxView, w), Math.min(maxView, h));
                iG3D.clear(background);
            }
            finally {
                iG3D.releaseTarget();
            }
        }
        catch (Throwable e) {
            Logger.warn(e);
            this.drawImage(img, x + w / 2 - img.getWidth() / 2, y + h / 2 - img.getHeight() / 2);
        }
    }

    public void drawSprite(Sprite src, int frame, int x, int y) {
        src.setFrame(frame);
        src.setPosition(this.convertTrans(x, y), this.convertTrans(y, x));
        src.setTransform(this.trans);
        src.paint(this.g);
    }

    private int convertTrans(int a, int b) {
        return Graphics2D.convertTransform(a, b, this.trans);
    }

    private static int convertTransform(int a, int b, int transform) {
        if (transform == 0 || transform == 1) {
            return a;
        }
        if (transform == 3 || transform == 2) {
            return -a;
        }
        if (transform == 5 || transform == 4) {
            return b;
        }
        return -b;
    }

    public int getClipX() {
        int cx = this.g.getClipX();
        int cy = this.g.getClipY();
        return this.convertTrans(cx, cy);
    }

    public int getClipY() {
        int cx = this.g.getClipX();
        int cy = this.g.getClipY();
        return this.convertTrans(cy, cx);
    }

    public int getClipWidth() {
        int cw = this.g.getClipWidth();
        int ch = this.g.getClipHeight();
        return this.convertTrans(cw, ch);
    }

    public int getClipHeight() {
        int cw = this.g.getClipWidth();
        int ch = this.g.getClipHeight();
        return this.convertTrans(ch, cw);
    }

    public void clipRect(int x, int y, int w, int h) {
        this.g.clipRect(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w));
    }

    public void setClip(int x, int y, int w, int h) {
        this.g.setClip(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w));
    }

    public void translate(int x, int y) {
        this.g.translate(this.convertTrans(x, y), this.convertTrans(y, x));
    }

    public int getTranslateX() {
        return this.convertTrans(this.g.getTranslateX(), this.g.getTranslateY());
    }

    public int getTranslateY() {
        return this.convertTrans(this.g.getTranslateY(), this.g.getTranslateX());
    }

    public void drawString(String drawString, int tx, int ty) {
        this.font.drawString(this.g, drawString, tx, ty, 20);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getStrokeStyle() {
        return this.g.getStrokeStyle();
    }

    public void setStrokeStyle(int stroke) {
        this.g.setStrokeStyle(stroke);
    }

    public void fillRoundRect(int x, int y, int w, int h, int a1, int a2) {
        this.g.fillRoundRect(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w), a1, a2);
    }

    public void drawRoundRect(int x, int y, int w, int h, int a1, int a2) {
        this.g.drawRoundRect(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(w, h), this.convertTrans(h, w), a1, a2);
    }

    public void fillArc(int x, int y, int width, int height, int angle, int arc) {
        this.g.fillArc(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(width, height), this.convertTrans(height, width), angle, arc);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillArc(x, y, width, height, 0, 360);
    }

    public void drawArc(int x, int y, int width, int height, int angle, int arc) {
        this.g.drawArc(this.convertTrans(x, y), this.convertTrans(y, x), this.convertTrans(width, height), this.convertTrans(height, width), angle, arc);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360);
    }

    void setGraphics(Graphics gtmp) {
        this.g = gtmp;
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public int getTransform() {
        return this.trans;
    }

    public int[] getClip() {
        return new int[]{this.getClipX(), this.getClipY(), this.getClipWidth(), this.getClipHeight()};
    }

    public void setClip(int[] clip) {
        this.setClip(clip[0], clip[1], clip[2], clip[3]);
    }

    public Font getFont() {
        return this.font;
    }

    public static boolean isTransparent(int color) {
        return (color & 0xFF000000) == 0;
    }

    public static boolean isOpaque(int color) {
        return (color & 0xFF000000) == -16777216;
    }

    public static int parseColor(String value, int base) {
        boolean addAlpha = false;
        if (value.startsWith("#")) {
            base = 16;
            value = value.substring(1);
        } else if (value.startsWith("0x")) {
            base = 16;
            value = value.substring(2);
        }
        if (base == 16) {
            addAlpha = value.length() == 6;
        }
        int r = (int)Long.parseLong(value, base);
        return addAlpha ? 0xFF000000 | r : r;
    }
}

