/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.logging.DesktopLogger;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.QueueProcessorThread;
import net.yura.mobile.util.Url;

public abstract class Midlet
extends MIDlet {
    public static final int PLATFORM_NOT_DEFINED = 0;
    public static final int PLATFORM_NOKIA_S40 = 1;
    public static final int PLATFORM_NOKIA_S60 = 2;
    public static final int PLATFORM_SONY_ERICSSON = 3;
    public static final int PLATFORM_SAMSUNG = 4;
    public static final int PLATFORM_MOTOROLA = 5;
    public static final int PLATFORM_SIEMENS = 6;
    public static final int PLATFORM_LG = 7;
    public static final int PLATFORM_ME4SE = 8;
    public static final int PLATFORM_WTK = 9;
    public static final int PLATFORM_ANDROID = 10;
    public static final int PLATFORM_BLACKBERRY = 11;
    private static int platform = Midlet.detectPlatform();
    private DesktopPane rootpane;
    private Hashtable platformReqParams;
    public static String resdir;
    static /* synthetic */ Class class$net$yura$mobile$gui$Midlet;

    public Midlet() {
        QueueProcessorThread.CHANGE_PRIORITY = Midlet.getPlatform() != 10 && Midlet.getPlatform() != 11;
        this.rootpane = this.makeNewRootPane();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.rootpane);
        this.rootpane.repaint();
    }

    protected DesktopPane makeNewRootPane() {
        return new DesktopPane(this, -16777216, null);
    }

    protected abstract void initialize(DesktopPane var1);

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        this.rootpane.kill();
        this.notifyDestroyed();
    }

    protected void pauseApp() {
    }

    protected void startApp() {
    }

    public static int getPlatform() {
        return platform;
    }

    private static int detectPlatform() {
        if (Midlet.hasClass("net.rim.device.api.ui.UiApplication")) {
            return 11;
        }
        if (Midlet.hasClass("org.me4se.MIDletRunner")) {
            return 8;
        }
        String currentPlatform = System.getProperty("microedition.platform");
        if (currentPlatform == null) {
            currentPlatform = "";
        }
        if (currentPlatform.indexOf("Nokia") >= 0) {
            if (Midlet.hasClass("com.nokia.mid.impl.isa.ui.gdi.Pixmap")) {
                return 1;
            }
            return 2;
        }
        if (currentPlatform.indexOf("SonyEricsson") >= 0 || System.getProperty("com.sonyericsson.java.platform") != null) {
            return 3;
        }
        if (Midlet.hasClass("com.samsung.util.Vibration")) {
            return 4;
        }
        if (Midlet.hasClass("com.motorola.multimedia.Vibrator") || Midlet.hasClass("com.motorola.graphics.j3d.Effect3D") || Midlet.hasClass("com.motorola.multimedia.Lighting") || Midlet.hasClass("com.motorola.multimedia.FunLight") || Midlet.hasClass("com.motorola.phonebook.PhoneBookRecord")) {
            return 5;
        }
        if (Midlet.hasClass("com.siemens.mp.io.File")) {
            return 6;
        }
        if (Midlet.hasClass("mmpp.media.MediaPlayer") || Midlet.hasClass("mmpp.phone.Phone") || Midlet.hasClass("mmpp.lang.MathFP") || Midlet.hasClass("mmpp.media.BackLight")) {
            return 7;
        }
        if (currentPlatform.indexOf("wtk") >= 0) {
            return 9;
        }
        if (Midlet.hasClass("android.app.Activity")) {
            return 10;
        }
        return 0;
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Midlet getMidlet() {
        return DesktopPane.getDesktopPane().midlet;
    }

    public void platformRequestForResult(String url, Object arg, int requestCode) {
        Url u = new Url(url);
        u.addQueryParameter("requestCode", String.valueOf(requestCode));
        this.platformRequest(u.toString(), arg);
    }

    public void platformRequest(String url, Object arg) {
        try {
            if (this.platformReqParams == null) {
                this.platformReqParams = new Hashtable();
            }
            if (arg != null) {
                this.platformReqParams.put(url, arg);
            }
            this.platformRequest(url);
        }
        catch (Exception e) {
            Logger.warn(e);
            throw new RuntimeException(e.toString());
        }
    }

    public Object retrievePlatformRequestParam(String url) {
        Object res = this.platformReqParams.remove(url);
        return res;
    }

    public static void call(String number) {
        try {
            Midlet.getMidlet().platformRequest("tel:" + number);
        }
        catch (Exception e) {
            Logger.warn("can not call: " + number + " " + e.toString());
            Logger.warn(e);
        }
    }

    public static void openURL(String url) {
        try {
            Midlet.getMidlet().platformRequest(url);
        }
        catch (Exception e) {
            Logger.warn("can not open url: " + url + " " + e.toString());
            Logger.warn(e);
        }
    }

    public static void vibration(int duration) {
        try {
            Display.getDisplay((MIDlet)Midlet.getMidlet()).vibrate(duration);
        }
        catch (Exception e) {
            Logger.warn("can not vibration " + e.toString());
            Logger.warn(e);
        }
    }

    public static void exit() {
        try {
            Midlet.getMidlet().destroyApp(true);
        }
        catch (Exception ex) {
            Logger.warn(ex);
            throw new RuntimeException();
        }
    }

    public static void hide() {
        Display.getDisplay((MIDlet)Midlet.getMidlet()).setCurrent(null);
    }

    public static Image createImage(String name) {
        try {
            InputStream is = Midlet.getMidlet().getResourceAsStreamImpl(name);
            if (is != null) {
                return Image.createImage((InputStream)is);
            }
        }
        catch (Throwable th) {
            Logger.warn(th);
        }
        try {
            return Image.createImage((String)name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(String name) {
        InputStream is = Midlet.getMidlet().getResourceAsStreamImpl(name);
        if (is != null) {
            return is;
        }
        return (class$net$yura$mobile$gui$Midlet == null ? (class$net$yura$mobile$gui$Midlet = Midlet.class$("net.yura.mobile.gui.Midlet")) : class$net$yura$mobile$gui$Midlet).getResourceAsStream(name);
    }

    protected InputStream getResourceAsStreamImpl(String name) {
        InputStream is;
        if (resdir != null && (is = (class$net$yura$mobile$gui$Midlet == null ? (class$net$yura$mobile$gui$Midlet = Midlet.class$("net.yura.mobile.gui.Midlet")) : class$net$yura$mobile$gui$Midlet).getResourceAsStream(resdir + name)) != null) {
            return is;
        }
        return null;
    }

    public void onResult(int requestCode, int resultCode, Object obj) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Midlet.getPlatform() != 8) {
            Logger.setLogger(new DesktopLogger(2));
        }
        try {
            String rd = System.getProperty("resdir");
            if (rd != null) {
                resdir = rd;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

