/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui;

import java.util.Vector;
import net.yura.mobile.gui.Animation;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.components.Frame;
import net.yura.mobile.logging.Logger;

public class Transition
implements Runnable {
    Frame frame;
    Frame other;
    boolean makeVisible;
    int length;

    public static void setVisible(Frame frame, boolean visible) {
        Transition t = new Transition();
        t.frame = frame;
        t.makeVisible = visible;
        t.length = 150;
        if (visible) {
            frame.setLocation(frame.getDesktopPane().getWidth(), 0);
            frame.setVisible(true);
        } else {
            frame.setLocation(0, 0);
        }
        Vector v = frame.getDesktopPane().getAllFrames();
        t.other = v.size() > 1 ? v.elementAt(v.size() - 2) : null;
        if (t.other != null) {
            if (visible) {
                t.other.setLocation(0, 0);
            } else {
                t.other.setLocation(-frame.getDesktopPane().getWidth(), 0);
            }
        }
        new Thread(t).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            long start;
            int sleep = 1000 / Animation.FPS;
            long lastWait = start = System.currentTimeMillis();
            long finish = lastWait + (long)this.length;
            int startX = this.frame.getX();
            int startY = this.frame.getY();
            int targetX = this.makeVisible ? 0 : this.frame.getDesktopPane().getWidth();
            int targetY = 0;
            double xStep = (double)((targetX - startX) * sleep) / (double)this.length;
            double yStep = (double)((targetY - startY) * sleep) / (double)this.length;
            while (true) {
                int timeIntoAnimation = (int)(lastWait - start);
                int currentFrame = timeIntoAnimation / sleep;
                int xMove = (int)((double)currentFrame * xStep);
                int yMove = (int)((double)currentFrame * yStep);
                int nowX = this.frame.getX();
                int nowY = this.frame.getY();
                this.frame.setLocation(startX + xMove, startY + yMove);
                if (this.other != null) {
                    int xDiff = startX + xMove - nowX;
                    int yDiff = startY + yMove - nowY;
                    this.other.setLocation(this.other.getX() + xDiff, this.other.getY() + yDiff);
                }
                DesktopPane.getDesktopPane().repaint();
                lastWait = Animation.workoutSleep(sleep, lastWait);
                if (lastWait >= finish) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (Throwable ex) {
            Logger.warn(ex);
            return;
        }
        finally {
            this.frame.setLocation(0, 0);
            if (this.other != null) {
                this.other.setLocation(0, 0);
            }
            if (this.makeVisible) {
                DesktopPane.getDesktopPane().repaint();
            } else {
                this.frame.setVisible(false);
            }
        }
    }
}

