/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Label;
import net.yura.mobile.gui.components.MenuBar;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.gui.components.Window;

public class Menu
extends Button {
    private boolean open;
    private int slide = 32;
    private int destX;
    private int destY;
    private Icon arrowDirection;

    public Menu() {
        this.popup = Menu.makePopup();
    }

    public Menu(String string) {
        this();
        this.setText(string);
    }

    public void fireActionPerformed() {
        super.fireActionPerformed();
        this.setPopupMenuVisible(true);
    }

    protected void addImpl(Component c, Object cons, int index) {
        Menu.getPopupMenu(this.popup).insert(c, index);
    }

    public void removeAll() {
        Menu.getPopupMenu(this.popup).removeAll();
    }

    public Button findMneonicButton(int mnu) {
        return Menu.getPopupMenu(this.popup).findMneonicButton(mnu);
    }

    protected void workoutMinimumSize() {
        super.workoutMinimumSize();
        if (!this.isTopLevelMenu()) {
            this.width += this.arrowDirection != null ? this.arrowDirection.getIconWidth() + this.gap : 0;
        }
    }

    public void paintComponent(Graphics2D g) {
        super.paintComponent(g);
        if (!this.isTopLevelMenu() && this.arrowDirection != null) {
            this.arrowDirection.paintIcon(this, g, this.width - this.padding - this.arrowDirection.getIconWidth(), (this.height - this.arrowDirection.getIconHeight()) / 2);
        }
    }

    public void setMenuRenderer(ListCellRenderer renderer) {
        Menu.getPopupMenu(this.popup).setCellRenderer(renderer);
    }

    public void updateUI() {
        super.updateUI();
        this.arrowDirection = (Icon)this.theme.getProperty("arrow", 0);
    }

    public void addSeparator() {
        this.add(Menu.makeSeparator());
    }

    public Vector getMenuComponents() {
        MenuBar bar = Menu.getPopupMenu(this.popup);
        return bar.getItems();
    }

    public static Component makeSeparator() {
        Label separator = new Label();
        separator.setPreferredSize(-1, 1);
        separator.setName("Separator");
        return separator;
    }

    public static Window makePopup() {
        Window popup = new Window();
        popup.setCloseOnFocusLost(true);
        MenuBar menuItems = new MenuBar();
        menuItems.setLayoutOrientation(0);
        menuItems.setLoop(!Boolean.FALSE.equals(DesktopPane.get("LOOP_MENU")));
        popup.addWindowListener(menuItems);
        popup.add(new ScrollPane(menuItems));
        popup.setName("Menu");
        Button cancel = new Button((String)DesktopPane.get("cancelText"));
        cancel.setActionCommand("close");
        cancel.addActionListener(menuItems);
        cancel.setMnemonic(-11);
        popup.addCommand(cancel);
        if (Midlet.getPlatform() == 10) {
            Button cancel2 = new Button((String)DesktopPane.get("menuText"));
            cancel2.setActionCommand("close");
            cancel2.addActionListener(menuItems);
            cancel2.setMnemonic(-12);
            popup.addCommand(cancel2);
        } else {
            menuItems.setUseSelectButton(true);
        }
        return popup;
    }

    public static MenuBar getPopupMenu(Window popup) {
        return (MenuBar)((ScrollPane)popup.getComponents().firstElement()).getView();
    }

    public void setPopupMenuVisible(boolean vis) {
        if (vis) {
            Component parent1 = this.getParent();
            if (parent1 instanceof MenuBar) {
                Menu.getPopupMenu((Window)this.popup).owner = (MenuBar)parent1;
            }
            this.popup.setDesktopPane(this.getDesktopPane());
            Menu.setupSize(this.popup);
            Border insets = this.getInsets();
            Menu.positionMenuRelativeTo(this.popup, this.getXOnScreen() - insets.getLeft(), this.getYOnScreen() - insets.getTop(), this.getWidthWithBorder(), this.getHeightWithBorder(), this.isTopLevelMenu() ? 16 : 8);
            Menu.setupSnap(this.popup);
            this.openMenuAtLocation();
        }
    }

    private boolean isTopLevelMenu() {
        Component parent1 = this.getParent();
        return !(parent1 instanceof MenuBar) || ((MenuBar)parent1).getLayoutOrientation() == 3;
    }

    public static void setupSize(Window window) {
        window.pack();
        DesktopPane dp = window.getDesktopPane();
        int w = window.getWidthWithBorder();
        int h = window.getHeightWithBorder();
        int maxh = dp.getHeight() - dp.getMenuHeight() * 2;
        if (h > maxh) {
            h = maxh;
            w += Menu.extraWidth(window);
        }
        if (w > dp.getWidth()) {
            w = dp.getWidth();
        }
        Border insets = window.getInsets();
        window.setSize(w - insets.getLeft() - insets.getRight(), h - insets.getTop() - insets.getBottom());
    }

    public static void positionMenuRelativeTo(Window window, int x, int y, int width, int height, int direction) {
        DesktopPane dp = window.getDesktopPane();
        int w = window.getWidthWithBorder();
        int h = window.getHeightWithBorder();
        if (direction != 8) {
            boolean up;
            int right = dp.getWidth() - x - width;
            boolean bl = up = y + height / 2 > dp.getHeight() / 2;
            y = up ? (y -= h) : (y += height);
            if (x > 0 && right == 0) {
                x = dp.getWidth() - w;
            }
        } else {
            x += width;
        }
        Border insets = window.getInsets();
        window.setLocation(x + insets.getLeft(), y + insets.getTop());
        window.makeVisible();
    }

    private static int extraWidth(Panel p) {
        Vector children = p.getComponents();
        for (int c = 0; c < children.size(); ++c) {
            int e;
            Component comp = (Component)children.elementAt(c);
            if (comp instanceof ScrollPane) {
                return ((ScrollPane)comp).getBarThickness();
            }
            if (!(comp instanceof Panel) || (e = Menu.extraWidth((Panel)comp)) <= 0) continue;
            return e;
        }
        return 0;
    }

    private static void setupSnap(Window popup) {
        DesktopPane dp = DesktopPane.getDesktopPane();
        boolean left = popup.getXWithBorder() == 0;
        boolean top = popup.getYWithBorder() == 0;
        boolean right = popup.getXWithBorder() + popup.getWidthWithBorder() == dp.getWidth();
        boolean bottom = popup.getYWithBorder() + popup.getHeightWithBorder() == dp.getHeight();
        popup.snap = (left ? 4 : 0) | (top ? 16 : 0) | (right ? 8 : 0) | (bottom ? 32 : 0);
    }

    public void openMenuInCentre() {
        this.popup.pack();
        this.popup.setLocationRelativeTo(null);
        this.openMenuAtLocation();
    }

    private void openMenuAtLocation() {
        DesktopPane dp = this.getDesktopPane();
        if (!this.isVisible()) {
            int x = this.popup.getXWithBorder();
            int y = this.popup.getYWithBorder();
            int w = this.popup.getInsets().getLeft();
            int h = this.popup.getInsets().getTop();
            if (this.slide == 32) {
                this.popup.setLocation(w + x, h + dp.getHeight());
            }
            if (this.slide == 16) {
                this.popup.setLocation(w + x, h - this.popup.getHeightWithBorder());
            }
            if (this.slide == 8) {
                this.popup.setLocation(w + dp.getWidth(), h + y);
            }
            if (this.slide == 4) {
                this.popup.setLocation(w - this.popup.getWidthWithBorder(), h + y);
            }
            int offsetX = this.popup.getX() - this.popup.getXWithBorder();
            int offsetY = this.popup.getY() - this.popup.getYWithBorder();
            this.destX = x + offsetX;
            this.destY = y + offsetY;
            this.open = false;
            dp.animateComponent(this);
        }
        dp.add(this.popup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws InterruptedException {
        try {
            int travelDistance = 0;
            if (this.slide == 32) {
                travelDistance = this.popup.getY() - this.destY;
            } else if (this.slide == 16) {
                travelDistance = this.destY - this.popup.getY();
            } else if (this.slide == 8) {
                travelDistance = this.popup.getX() - this.destX;
            } else if (this.slide == 4) {
                travelDistance = this.destX - this.popup.getX();
            }
            int menuMoveSpeed = travelDistance / 3 + 1;
            int step = menuMoveSpeed / 10 + 1;
            while (true) {
                if ((menuMoveSpeed -= step) < step) {
                    menuMoveSpeed = step;
                }
                if (!this.open) {
                    int pX = this.popup.getX();
                    int pY = this.popup.getY();
                    if (this.slide == 32) {
                        if ((pY -= menuMoveSpeed) < this.destY) {
                            pY = this.destY;
                        }
                    } else if (this.slide == 16) {
                        if ((pY += menuMoveSpeed) > this.destY) {
                            pY = this.destY;
                        }
                    } else if (this.slide == 8) {
                        if ((pX -= menuMoveSpeed) < this.destX) {
                            pX = this.destX;
                        }
                    } else if (this.slide == 4 && (pX += menuMoveSpeed) > this.destX) {
                        pX = this.destX;
                    }
                    this.popup.getDesktopPane().repaintHole(this.popup);
                    this.popup.setLocation(pX, pY);
                    this.popup.repaint();
                    if (pY == this.destY && pX == this.destX) {
                        break;
                    }
                }
                this.wait(50);
            }
        }
        finally {
            if (!this.open) {
                this.open = true;
                this.popup.getDesktopPane().repaintHole(this.popup);
                this.popup.setLocation(this.destX, this.destY);
                this.popup.makeVisible();
                this.popup.repaint();
            }
        }
    }
}

