/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.io;

import java.io.IOException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import net.yura.mobile.logging.Logger;

public abstract class BTDiscovery
implements DiscoveryListener {
    public boolean start(int accessCode) {
        try {
            String name = LocalDevice.getLocalDevice().getFriendlyName();
            String address = LocalDevice.getLocalDevice().getBluetoothAddress();
            this.handleMyId(name, address);
            if (BTDiscovery.isSupported()) {
                DiscoveryAgent discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
                discoveryAgent.startInquiry(accessCode, (DiscoveryListener)this);
                return true;
            }
        }
        catch (IOException ex) {
            Logger.warn(ex);
        }
        return false;
    }

    public void deviceDiscovered(RemoteDevice device, DeviceClass deviceClass) {
        boolean isPhone = deviceClass.getMajorDeviceClass() == 512;
        try {
            if (isPhone) {
                String name = device.getFriendlyName(false);
                String address = device.getBluetoothAddress();
                this.handleRemoteId(name, address);
            }
        }
        catch (Throwable t) {
            Logger.error(t);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void servicesDiscovered(int transId, ServiceRecord[] serviceRecords) {
        try {
            if (serviceRecords.length != 1) return;
        }
        catch (Throwable t) {
            Logger.error(t);
        }
    }

    public void inquiryCompleted(int discoveryType) {
        try {
            this.handleInquiryCompleted();
        }
        catch (Throwable t) {
            Logger.error(t);
        }
    }

    public void serviceSearchCompleted(int transId, int responseCode) {
    }

    public abstract void handleMyId(String var1, String var2);

    public abstract void handleRemoteId(String var1, String var2);

    public abstract void handleInquiryCompleted();

    protected static boolean isSupported() {
        String btVersion = System.getProperty("bluetooth.api.version");
        return btVersion != null && !"".equals(btVersion.trim());
    }
}

